/*
 * Decompiled with CFR 0.152.
 */
package me.drex.vanish.config;

import java.nio.file.Path;
import me.drex.vanish.VanishMod;
import me.drex.vanish.config.VanishConfig;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public class ConfigManager {
    private static final Logger LOGGER = VanishMod.LOGGER;
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("vanish.hocon");
    private static VanishConfig vanishConfig = new VanishConfig();

    private ConfigManager() {
    }

    public static void load() throws Exception {
        LOGGER.info("Loading configuration...");
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(CONFIG_FILE)).build();
        CommentedConfigurationNode rootNode = (CommentedConfigurationNode)loader.load();
        if (!CONFIG_FILE.toFile().exists()) {
            LOGGER.info("Creating configuration file!");
            rootNode.set(VanishConfig.class, (Object)new VanishConfig());
            loader.save(rootNode);
        }
        vanishConfig = rootNode.get(VanishConfig.class, new VanishConfig());
    }

    public static VanishConfig vanish() {
        return vanishConfig;
    }
}

