/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.drex.villagerconfig.mixin.MerchantOfferAccessor;
import me.drex.villagerconfig.util.loot.VCLootContextParams;
import net.minecraft.class_1297;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1914;
import net.minecraft.class_217;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_3853;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5819;
import net.minecraft.class_73;
import net.minecraft.class_79;
import net.minecraft.class_82;
import net.minecraft.class_8567;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class BehaviorTrade
implements class_3853.class_1652 {
    private final class_79 costA;
    private final Optional<class_79> costB;
    private final class_79 result;
    private final class_5658 priceMultiplier;
    private final class_5658 traderExperience;
    private final class_5658 maxUses;
    protected final Predicate<class_47> compositeCondition;
    private final List<class_5341> conditions;
    private final Map<String, class_5658> referenceProviders;
    private final boolean rewardExperience;

    BehaviorTrade(class_79 costA, Optional<class_79> costB, class_79 result, class_5658 priceMultiplier, class_5658 traderExperience, class_5658 maxUses, List<class_5341> conditions, Map<String, class_5658> referenceProviders, boolean rewardExperience) {
        this.costA = costA;
        this.costB = costB;
        this.result = result;
        this.priceMultiplier = priceMultiplier;
        this.traderExperience = traderExperience;
        this.maxUses = maxUses;
        this.conditions = conditions;
        this.compositeCondition = class_217.method_924((Predicate[])((Predicate[])conditions.toArray(new class_5341[0])));
        this.referenceProviders = referenceProviders;
        this.rewardExperience = rewardExperience;
    }

    @Nullable
    public class_1914 method_7246(class_1297 entity, class_5819 random) {
        class_8567 lootParams = new class_8567.class_8568((class_3218)entity.method_37908()).method_51874(class_181.field_24424, (Object)entity.method_19538()).method_51874(class_181.field_1226, (Object)entity).method_51874(VCLootContextParams.NUMBER_REFERENCE, this.generateNumberReferences(entity, random)).method_51875(VCLootContextParams.VILLAGER_LOOT_CONTEXT);
        class_47 lootContext = new class_47.class_48(lootParams).method_309(null);
        AtomicReference<class_1799> costA = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicReference<class_1799> costB = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicReference<class_1799> result = new AtomicReference<class_1799>(class_1799.field_8037);
        this.addRandomItem(result::set, lootContext, this.result);
        this.addRandomItem(costB::set, lootContext, this.costB.orElse(class_73.method_401().method_419()));
        this.addRandomItem(costA::set, lootContext, this.costA);
        class_1914 tradeOffer = new class_1914(costA.get(), costB.get(), result.get(), this.maxUses.method_366(lootContext), this.traderExperience.method_366(lootContext), this.priceMultiplier.method_32454(lootContext));
        ((MerchantOfferAccessor)tradeOffer).setRewardExp(this.rewardExperience);
        return tradeOffer;
    }

    private void addRandomItem(Consumer<class_1799> consumer, class_47 lootContext, class_79 lootPoolEntryContainer) {
        class_5819 randomSource = lootContext.method_294();
        ArrayList entries = Lists.newArrayList();
        MutableInt totalWeight = new MutableInt();
        lootPoolEntryContainer.expand(lootContext, lootPoolEntry -> {
            int weight = lootPoolEntry.method_427(lootContext.method_302());
            if (weight > 0) {
                entries.add(lootPoolEntry);
                totalWeight.add(weight);
            }
        });
        int size = entries.size();
        if (totalWeight.intValue() == 0 || size == 0) {
            return;
        }
        if (size == 1) {
            ((class_82)entries.get(0)).method_426(consumer, lootContext);
            return;
        }
        int j = randomSource.method_43048(totalWeight.intValue());
        for (class_82 lootPoolEntry2 : entries) {
            if ((j -= lootPoolEntry2.method_427(lootContext.method_302())) >= 0) continue;
            lootPoolEntry2.method_426(consumer, lootContext);
            return;
        }
    }

    private Map<String, Float> generateNumberReferences(class_1297 entity, class_5819 random) {
        class_8567 lootParams = new class_8567.class_8568((class_3218)entity.method_37908()).method_51875(class_173.field_1175);
        class_47 simpleContext = new class_47.class_48(lootParams).method_309(null);
        return this.referenceProviders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Float.valueOf(((class_5658)entry.getValue()).method_32454(simpleContext))));
    }

    public static class Serializer
    implements JsonSerializer<BehaviorTrade>,
    JsonDeserializer<BehaviorTrade> {
        private static final Type REFERENCE_PROVIDERS_TYPE = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, class_5658.class}).getType();

        public BehaviorTrade deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonElement, (String)"behaviour trade");
            class_79 costA = (class_79)class_3518.method_15272((JsonObject)jsonObject, (String)"cost_a", (JsonDeserializationContext)context, class_79.class);
            Optional<class_79> costB = Optional.ofNullable((class_79)class_3518.method_15283((JsonObject)jsonObject, (String)"cost_b", null, (JsonDeserializationContext)context, class_79.class));
            class_79 result = (class_79)class_3518.method_15272((JsonObject)jsonObject, (String)"result", (JsonDeserializationContext)context, class_79.class);
            class_5658 priceMultiplier = (class_5658)class_3518.method_15283((JsonObject)jsonObject, (String)"price_multiplier", (Object)class_44.method_32448((float)0.2f), (JsonDeserializationContext)context, class_5658.class);
            class_5658 traderExperience = (class_5658)class_3518.method_15283((JsonObject)jsonObject, (String)"trader_experience", (Object)class_44.method_32448((float)0.0f), (JsonDeserializationContext)context, class_5658.class);
            class_5658 maxUses = (class_5658)class_3518.method_15283((JsonObject)jsonObject, (String)"max_uses", (Object)class_44.method_32448((float)12.0f), (JsonDeserializationContext)context, class_5658.class);
            class_5341[] conditions = (class_5341[])class_3518.method_15283((JsonObject)jsonObject, (String)"conditions", (Object)new class_5341[0], (JsonDeserializationContext)context, class_5341[].class);
            Map referenceProviders = Collections.emptyMap();
            if (jsonObject.has("reference_providers")) {
                referenceProviders = (Map)context.deserialize(jsonObject.get("reference_providers"), REFERENCE_PROVIDERS_TYPE);
            }
            boolean rewardExperience = class_3518.method_15258((JsonObject)jsonObject, (String)"reward_experience", (boolean)true);
            return new BehaviorTrade(costA, costB, result, priceMultiplier, traderExperience, maxUses, List.of(conditions), referenceProviders, rewardExperience);
        }

        public JsonElement serialize(BehaviorTrade behaviorTrade, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("cost_a", context.serialize((Object)behaviorTrade.costA));
            behaviorTrade.costB.ifPresent(lootPoolEntryContainer -> jsonObject.add("cost_b", context.serialize(lootPoolEntryContainer)));
            jsonObject.add("result", context.serialize((Object)behaviorTrade.result));
            jsonObject.add("price_multiplier", context.serialize((Object)behaviorTrade.priceMultiplier));
            jsonObject.add("trader_experience", context.serialize((Object)behaviorTrade.traderExperience));
            jsonObject.add("max_uses", context.serialize((Object)behaviorTrade.maxUses));
            if (!behaviorTrade.conditions.isEmpty()) {
                jsonObject.add("conditions", context.serialize(behaviorTrade.conditions));
            }
            if (!behaviorTrade.referenceProviders.isEmpty()) {
                jsonObject.add("reference_providers", context.serialize(behaviorTrade.referenceProviders, REFERENCE_PROVIDERS_TYPE));
            }
            jsonObject.addProperty("reward_experience", Boolean.valueOf(behaviorTrade.rewardExperience));
            return jsonObject;
        }
    }

    public static class Builder {
        private final class_79 costA;
        private Optional<class_79> costB = Optional.empty();
        private final class_79 result;
        private class_5658 priceMultiplier = class_44.method_32448((float)0.2f);
        private class_5658 traderExperience = class_44.method_32448((float)1.0f);
        private class_5658 maxUses = class_44.method_32448((float)12.0f);
        private final List<class_5341> conditions = Lists.newArrayList();
        private final Map<String, class_5658> referenceProviders = new HashMap<String, class_5658>();
        private boolean rewardExperience = true;

        public Builder(class_79.class_80<?> costA, class_79.class_80<?> result) {
            this.costA = costA.method_419();
            this.result = result.method_419();
        }

        public Builder(class_79.class_80<?> costA, class_79.class_80<?> costB, class_79.class_80<?> result) {
            this.costA = costA.method_419();
            this.costB = Optional.of(costB.method_419());
            this.result = result.method_419();
        }

        public Builder priceMultiplier(float priceMultiplier) {
            return this.priceMultiplier((class_5658)class_44.method_32448((float)priceMultiplier));
        }

        public Builder priceMultiplier(class_5658 priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder traderExperience(float traderExp) {
            return this.traderExperience((class_5658)class_44.method_32448((float)traderExp));
        }

        public Builder traderExperience(class_5658 traderExp) {
            this.traderExperience = traderExp;
            return this;
        }

        public Builder when(class_5341.class_210 builder) {
            this.conditions.add(builder.build());
            return this;
        }

        public Builder maxUses(float maxUses) {
            return this.maxUses((class_5658)class_44.method_32448((float)maxUses));
        }

        public Builder maxUses(class_5658 maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder numberReference(String id, class_5658 numberProvider) {
            this.referenceProviders.put(id, numberProvider);
            return this;
        }

        public Builder rewardExperience(boolean rewardExp) {
            this.rewardExperience = rewardExp;
            return this;
        }

        public BehaviorTrade build() {
            return new BehaviorTrade(this.costA, this.costB, this.result, this.priceMultiplier, this.traderExperience, this.maxUses, this.conditions, this.referenceProviders, this.rewardExperience);
        }
    }
}

