/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import me.drex.villagerconfig.data.TradeTier;
import net.minecraft.class_3518;
import net.minecraft.class_3853;
import net.minecraft.class_3988;

public class TradeTable {
    final List<TradeTier> tiers;

    public TradeTable(List<TradeTier> tiers) {
        this.tiers = tiers;
    }

    private TradeTier getTradeTier(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Villager level must at least be 1");
        }
        if (this.tiers.size() >= level) {
            return this.tiers.get(level - 1);
        }
        return TradeTier.EMPTY;
    }

    public class_3853.class_1652[] getTradeOffers(class_3988 villager, int level) {
        TradeTier tradeTier = this.getTradeTier(level);
        return tradeTier.getTradeOffers(villager);
    }

    public int requiredExperience(int level) {
        return this.getTradeTier(level).requiredExperience();
    }

    public int maxLevel() {
        return this.tiers.size();
    }

    public static class Serializer
    implements JsonSerializer<TradeTable>,
    JsonDeserializer<TradeTable> {
        public TradeTable deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonElement, (String)"trade table");
            TradeTier[] tiers = (TradeTier[])class_3518.method_15272((JsonObject)jsonObject, (String)"tiers", (JsonDeserializationContext)context, TradeTier[].class);
            return new TradeTable(List.of(tiers));
        }

        public JsonElement serialize(TradeTable tradeTable, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("tiers", context.serialize(tradeTable.tiers));
            return jsonObject;
        }
    }
}

