/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.mixin;

import me.drex.villagerconfig.VillagerConfig;
import me.drex.villagerconfig.config.ConfigManager;
import me.drex.villagerconfig.data.TradeTable;
import me.drex.villagerconfig.util.interfaces.IVillager;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3850;
import net.minecraft.class_3853;
import net.minecraft.class_3988;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1646.class})
public abstract class VillagerMixin
extends class_3988 {
    @Shadow
    public abstract class_3850 method_7231();

    public VillagerMixin(class_1299<? extends class_3988> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"canRestock"}, at={@At(value="RETURN")}, cancellable=true)
    public void removeRefreshTradesInfo(CallbackInfoReturnable<Boolean> cir) {
        if (ConfigManager.CONFIG.oldTrades.enabled) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"updateTrades"}, at={@At(value="HEAD")}, cancellable=true)
    public void putCustomTrades(CallbackInfo ci) {
        TradeTable tradeTable = this.getTradeTable();
        if (tradeTable != null) {
            class_3850 villagerData = this.method_7231();
            int level = villagerData.method_16925();
            class_3853.class_1652[] customOffers = tradeTable.getTradeOffers(this, level);
            this.method_19170(this.method_8264(), customOffers, customOffers.length);
            ci.cancel();
        }
    }

    @Redirect(method={"shouldIncreaseLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/VillagerData;canLevelUp(I)Z"))
    public boolean adjustMaxLevel(int level) {
        return this.customCanLevelUp(level);
    }

    @Redirect(method={"shouldIncreaseLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/VillagerData;getMaxXpPerLevel(I)I"))
    public int adjustUpperLevelExperience(int level) {
        return this.customUpperLevelExperience(level);
    }

    @Inject(method={"increaseMerchantCareer"}, at={@At(value="TAIL")})
    public void onLevelUp(CallbackInfo ci) {
        if (ConfigManager.CONFIG.oldTrades.enabled) {
            ((IVillager)((Object)this)).enableTrades();
        }
    }

    private int customUpperLevelExperience(int level) {
        TradeTable tradeTable;
        if (this.customCanLevelUp(level) && (tradeTable = this.getTradeTable()) != null) {
            return tradeTable.requiredExperience(level + 1);
        }
        return class_3850.method_19195((int)level);
    }

    private boolean customCanLevelUp(int level) {
        TradeTable tradeTable = this.getTradeTable();
        if (tradeTable != null) {
            int maxLevel = tradeTable.maxLevel();
            return level >= 1 && level < maxLevel;
        }
        return class_3850.method_19196((int)level);
    }

    private TradeTable getTradeTable() {
        if (this.method_37908() instanceof class_3218) {
            class_2960 identifier = class_7923.field_41195.method_10221((Object)this.method_7231().method_16924());
            return VillagerConfig.TRADE_MANAGER.getTrade(identifier);
        }
        return null;
    }
}

