/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.drex.villagerconfig.data.BehaviorTrade;
import me.drex.villagerconfig.data.TradeGroup;
import me.drex.villagerconfig.data.TradeTable;
import me.drex.villagerconfig.data.TradeTier;
import me.drex.villagerconfig.json.TradeGsons;
import me.drex.villagerconfig.mixin.VillagerDataAccessor;
import me.drex.villagerconfig.util.loot.function.EnchantRandomlyLootFunction;
import me.drex.villagerconfig.util.loot.function.SetDyeFunction;
import me.drex.villagerconfig.util.loot.number.AddLootNumberProvider;
import me.drex.villagerconfig.util.loot.number.MultiplyLootNumberProvider;
import me.drex.villagerconfig.util.loot.number.ReferenceLootNumberProvider;
import net.minecraft.class_106;
import net.minecraft.class_111;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_152;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2105;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_2405;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3670;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_65;
import net.minecraft.class_6662;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_93;
import org.jetbrains.annotations.NotNull;

public class TradeProvider
implements class_2405 {
    private final class_7784.class_7489 pathResolver;
    public static final class_2960 WANDERING_TRADER_ID = new class_2960("wanderingtrader");
    private static final IntUnaryOperator WANDERING_TRADER_COUNT = i -> switch (i) {
        case 1 -> 5;
        case 2 -> 1;
        default -> 0;
    };

    public TradeProvider(class_7784 output) {
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39367, "trades");
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 writer) {
        HashMap map = Maps.newHashMap();
        for (class_3852 villagerProfession : class_7923.field_41195) {
            map.put(class_7923.field_41195.method_10221((Object)villagerProfession), new TradeData((Int2ObjectMap<class_3853.class_1652[]>)((Int2ObjectMap)class_3853.field_17067.getOrDefault(villagerProfession, new Int2ObjectArrayMap())), OfferCountType.VILLAGER));
        }
        map.put(WANDERING_TRADER_ID, new TradeData((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724, OfferCountType.WANDERING_TRADER));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            class_2960 identifier = (class_2960)entry.getKey();
            TradeData tradeData = (TradeData)entry.getValue();
            Path path = this.pathResolver.method_44107(identifier);
            return class_2405.method_10320((class_7403)writer, (JsonElement)this.toJson(tradeData), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String method_10321() {
        return "Trades";
    }

    private JsonElement toJson(TradeData tradeData) {
        int levels = tradeData.trades().size();
        TradeTier[] tiers = new TradeTier[levels];
        tradeData.trades().forEach((level, factoryArr) -> {
            TradeGroup tradeGroup = new TradeGroup((class_5658)class_44.method_32448((float)tradeData.offerCountType().getOfferCount((int)level)), Arrays.stream(factoryArr).map(this::convert).filter(Objects::nonNull).toList());
            tiers[level.intValue() - 1] = new TradeTier(VillagerDataAccessor.getNextLevelXpThresholds()[level - 1], List.of(tradeGroup));
        });
        TradeTable tradeTable = new TradeTable(List.of(tiers));
        return TradeGsons.GSON.toJsonTree((Object)tradeTable);
    }

    private BehaviorTrade convert(class_3853.class_1652 original) {
        if (original instanceof class_3853.class_4161) {
            class_3853.class_4161 factory = (class_3853.class_4161)original;
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18548).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18549))), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687)).priceMultiplier(factory.field_18552).traderExperience(factory.field_18551).maxUses(factory.field_18550).build();
        }
        if (original instanceof class_3853.class_4165) {
            class_3853.class_4165 factory = (class_3853.class_4165)original;
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18572))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18571.method_7909()).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18573)))).priceMultiplier(factory.field_18576).traderExperience(factory.field_18575).maxUses(factory.field_18574).build();
        }
        if (original instanceof class_3853.class_4166) {
            class_3853.class_4166 factory = (class_3853.class_4166)original;
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8766).method_438((class_117.class_118)new class_152.class_153().method_640(factory.field_18577, (class_5658)class_44.method_32448((float)factory.field_18578)))).traderExperience(factory.field_18579).build();
        }
        if (original instanceof class_3853.class_4164) {
            class_3853.class_4164 factory = (class_3853.class_4164)original;
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18565))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18563.method_7909()).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18564))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18566.method_7909()).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18567)))).priceMultiplier(factory.field_18570).traderExperience(factory.field_18569).maxUses(factory.field_18568).build();
        }
        if (original instanceof class_3853.class_4163) {
            class_3853.class_4163 factory = (class_3853.class_4163)original;
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18559))).method_438((class_117.class_118)class_141.method_35540((class_5658)ReferenceLootNumberProvider.create("enchantLevel"), (boolean)true)), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18558.method_7909()).method_438((class_117.class_118)new class_106.class_107((class_5658)ReferenceLootNumberProvider.create("enchantLevel")))).priceMultiplier(factory.field_18562).traderExperience(factory.field_18561).maxUses(factory.field_18560).numberReference("enchantLevel", (class_5658)class_5662.method_32462((float)5.0f, (float)19.0f)).build();
        }
        if (original instanceof class_3853.class_4162) {
            class_3853.class_4162 factory = (class_3853.class_4162)original;
            class_79.class_80[] children = new class_79.class_80[class_7923.field_41194.method_10204()];
            int i = 0;
            for (class_3854 villagerType : class_7923.field_41194) {
                class_2487 root = new class_2487();
                class_2487 villagerData = new class_2487();
                villagerData.method_10582("type", class_7923.field_41194.method_10221((Object)villagerType).toString());
                root.method_10566("VillagerData", (class_2520)villagerData);
                children[i] = class_77.method_411((class_1935)((class_1935)factory.field_18553.get(villagerType))).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18554))).method_421(class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_8915(new class_2105(root))));
                ++i;
            }
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_65.method_386((class_79.class_80[])children), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687)).priceMultiplier(0.05f).traderExperience(factory.field_18556).maxUses(factory.field_18555).build();
        }
        if (original instanceof class_3853.class_4167) {
            class_3853.class_4167 factory = (class_3853.class_4167)original;
            List<class_1842> potions = class_7923.field_41179.method_10220().filter(potion -> !potion.method_8049().isEmpty() && class_1845.method_20361((class_1842)potion)).toList();
            class_79.class_80[] entries = new class_79.class_80[potions.size()];
            for (int i = 0; i < potions.size(); ++i) {
                class_1842 potion2 = potions.get(i);
                entries[i] = class_77.method_411((class_1935)factory.field_18581.method_7909()).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18582))).method_438((class_117.class_118)class_6662.method_38927((class_1842)potion2));
            }
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18583))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18586).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18587))), (class_79.class_80<?>)class_93.method_35511((class_79.class_80[])entries)).priceMultiplier(factory.field_18588).traderExperience(factory.field_18585).maxUses(factory.field_18584).build();
        }
        if (original instanceof class_3853.class_1648) {
            class_3853.class_1648 factory = (class_3853.class_1648)original;
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8529), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)MultiplyLootNumberProvider.create(AddLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)2.0f), new class_5662((class_5658)class_44.method_32448((float)0.0f), (class_5658)AddLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)5.0f), MultiplyLootNumberProvider.create(new class_5658[]{ReferenceLootNumberProvider.create("enchantmentLevel"), class_44.method_32448((float)10.0f)})})), MultiplyLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)3.0f), ReferenceLootNumberProvider.create("enchantmentLevel")})}), ReferenceLootNumberProvider.create("treasureMultiplier")))), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8529).method_438((class_117.class_118)new EnchantRandomlyLootFunction.Builder().tradeEnchantments())).traderExperience(factory.field_18557).build();
        }
        if (original instanceof class_3853.class_1654) {
            class_3853.class_1654 factory = (class_3853.class_1654)original;
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18589))), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8251), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8895).method_438((class_117.class_118)new class_111.class_112().method_35521(100).method_499(factory.field_7473).method_502(factory.field_7474).method_500((byte)2).method_503(true)).method_438((class_117.class_118)class_3670.method_35549((class_2561)class_2561.method_43471((String)factory.field_37051)))).traderExperience(factory.field_18591).maxUses(factory.field_18590).build();
        }
        if (original instanceof class_3853.class_4160) {
            class_3853.class_4160 factory = (class_3853.class_4160)original;
            return new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18545))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18544), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18544).method_438((class_117.class_118)new SetDyeFunction.Builder(true)).method_438((class_117.class_118)new SetDyeFunction.Builder(true).method_524(class_219.method_932((float)0.3f))).method_438((class_117.class_118)new SetDyeFunction.Builder(true).method_524(class_219.method_932((float)0.2f)))).traderExperience(factory.field_18547).maxUses(factory.field_18546).build();
        }
        field_40831.warn("Unable to convert {}, generated json won't be complete!", original.getClass());
        return null;
    }

    public record TradeData(Int2ObjectMap<class_3853.class_1652[]> trades, OfferCountType offerCountType) {
    }

    public static enum OfferCountType {
        VILLAGER(i -> 2),
        WANDERING_TRADER(WANDERING_TRADER_COUNT);

        private final IntUnaryOperator operator;

        private OfferCountType(IntUnaryOperator operator) {
            this.operator = operator;
        }

        public int getOfferCount(int level) {
            return this.operator.apply(level);
        }
    }
}

