/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.util.loot.function;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import me.drex.villagerconfig.util.loot.LootItemFunctionTypes;
import me.drex.villagerconfig.util.loot.VCLootContextParams;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class EnchantRandomlyLootFunction
extends class_120 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<class_1887> include;
    private final List<class_1887> exclude;
    private final boolean tradeEnchantments;

    EnchantRandomlyLootFunction(class_5341[] conditions, Collection<class_1887> include, Collection<class_1887> exclude, boolean tradeEnchantments) {
        super(conditions);
        this.include = ImmutableList.copyOf(include);
        this.exclude = ImmutableList.copyOf(exclude);
        this.tradeEnchantments = tradeEnchantments;
    }

    @NotNull
    protected class_1799 method_522(@NotNull class_1799 stack, class_47 context) {
        class_5819 random = context.method_294();
        List<class_1887> enchantments = this.getEnchantments(stack);
        if (enchantments.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)stack);
            return stack;
        }
        class_1887 enchantment = enchantments.get(random.method_43048(enchantments.size()));
        return EnchantRandomlyLootFunction.addEnchantmentToStack(stack, enchantment, random, context);
    }

    private List<class_1887> getEnchantments(class_1799 stack) {
        if (!this.include.isEmpty()) {
            return this.include;
        }
        Stream<class_1887> stream = class_7923.field_41176.method_10220();
        if (!this.exclude.isEmpty()) {
            stream = stream.filter(enchantment -> !this.exclude.contains(enchantment));
        }
        if (this.tradeEnchantments) {
            stream = stream.filter(class_1887::method_25949);
        }
        boolean isBook = stack.method_31574(class_1802.field_8529);
        return stream.filter(enchantment -> isBook || enchantment.method_8192(stack)).toList();
    }

    private static class_1799 addEnchantmentToStack(class_1799 stack, class_1887 enchantment, class_5819 random, class_47 context) {
        int level = class_3532.method_15395((class_5819)random, (int)enchantment.method_8187(), (int)enchantment.method_8183());
        if (stack.method_31574(class_1802.field_8529)) {
            stack = new class_1799((class_1935)class_1802.field_8598);
            class_1772.method_7807((class_1799)stack, (class_1889)new class_1889(enchantment, level));
        } else {
            stack.method_7978(enchantment, level);
        }
        if (context.method_300(VCLootContextParams.NUMBER_REFERENCE)) {
            Map referenceProviders = (Map)context.method_296(VCLootContextParams.NUMBER_REFERENCE);
            referenceProviders.put("enchantmentLevel", Float.valueOf(level));
            referenceProviders.put("treasureMultiplier", Float.valueOf(enchantment.method_8193() ? 2.0f : 1.0f));
        }
        return stack;
    }

    @NotNull
    public class_5339 method_29321() {
        return LootItemFunctionTypes.ENCHANT_RANDOMLY;
    }

    public static class Serializer
    extends class_120.class_123<EnchantRandomlyLootFunction> {
        public void serialize(@NotNull JsonObject jsonObject, @NotNull EnchantRandomlyLootFunction enchantRandomlyLootFunction, @NotNull JsonSerializationContext jsonSerializationContext) {
            super.method_529(jsonObject, (class_120)enchantRandomlyLootFunction, jsonSerializationContext);
            Serializer.addEnchantments(jsonObject, enchantRandomlyLootFunction.include, "include");
            Serializer.addEnchantments(jsonObject, enchantRandomlyLootFunction.exclude, "exclude");
            jsonObject.addProperty("trade_enchantments", Boolean.valueOf(enchantRandomlyLootFunction.tradeEnchantments));
        }

        private static void addEnchantments(JsonObject jsonObject, List<class_1887> enchantments, String key) {
            if (!enchantments.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (class_1887 enchantment : enchantments) {
                    class_2960 identifier = class_7923.field_41176.method_10221((Object)enchantment);
                    if (identifier == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                    }
                    jsonArray.add((JsonElement)new JsonPrimitive(identifier.toString()));
                }
                jsonObject.add(key, (JsonElement)jsonArray);
            }
        }

        @NotNull
        public EnchantRandomlyLootFunction deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext context, class_5341 @NotNull [] lootConditions) {
            List<class_1887> include = Serializer.getEnchantments(jsonObject, "include");
            List<class_1887> exclude = Serializer.getEnchantments(jsonObject, "exclude");
            boolean tradeEnchantments = class_3518.method_15258((JsonObject)jsonObject, (String)"trade_enchantments", (boolean)false);
            return new EnchantRandomlyLootFunction(lootConditions, include, exclude, tradeEnchantments);
        }

        private static List<class_1887> getEnchantments(JsonObject jsonObject, String key) {
            ArrayList enchantments = Lists.newArrayList();
            if (jsonObject.has(key)) {
                JsonArray jsonArray = class_3518.method_15261((JsonObject)jsonObject, (String)key);
                for (JsonElement jsonElement : jsonArray) {
                    String string = class_3518.method_15287((JsonElement)jsonElement, (String)"enchantment");
                    class_1887 enchantment = (class_1887)class_7923.field_41176.method_17966(new class_2960(string)).orElseThrow(() -> new JsonSyntaxException("Unknown enchantment '" + string + "'"));
                    enchantments.add(enchantment);
                }
            }
            return enchantments;
        }
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final Set<class_1887> include = Sets.newHashSet();
        private final Set<class_1887> exclude = Sets.newHashSet();
        private boolean tradeEnchantments = false;

        public Builder include(class_1887 enchantment) {
            this.include.add(enchantment);
            return this;
        }

        public Builder exclude(class_1887 enchantment) {
            this.exclude.add(enchantment);
            return this;
        }

        public Builder tradeEnchantments() {
            this.tradeEnchantments = true;
            return this;
        }

        @NotNull
        public class_117 method_515() {
            return new EnchantRandomlyLootFunction(this.method_526(), this.include, this.exclude, this.tradeEnchantments);
        }

        @NotNull
        protected Builder getThis() {
            return this;
        }
    }
}

