/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump.mixin.client;

import com.mojang.authlib.GameProfile;
import genandnic.walljump.WallJump;
import genandnic.walljump.helper.Keybindings;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_7428;
import net.minecraft.class_744;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityWallJumpMixin
extends class_742 {
    @Shadow
    public class_744 field_3913;
    public int ticksWallClinged;
    private int ticksKeyDown;
    private double clingX;
    private double clingZ;
    private double lastJumpY = Double.MAX_VALUE;
    private Set<class_2350> walls = new HashSet<class_2350>();
    private Set<class_2350> staleWalls = new HashSet<class_2350>();

    @Shadow
    public abstract boolean method_3144();

    @Shadow
    public abstract float method_5705(float var1);

    private boolean isFree(class_238 box) {
        return this.method_37908().method_8587((class_1297)this, box) && !this.method_37908().method_22345(box);
    }

    public ClientPlayerEntityWallJumpMixin(class_638 world, GameProfile profile, class_7428 playerPublicKey) {
        super(world, profile);
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    private void wallJumpTickMovement(CallbackInfo ci) {
        this.doWallJump();
    }

    private void doWallJump() {
        if (!this.canWallJump()) {
            return;
        }
        if (this.method_24828() || this.method_31549().field_7479 || !this.method_37908().method_8316(this.method_24515()).method_15769() || this.method_3144()) {
            this.ticksWallClinged = 0;
            this.clingX = Double.NaN;
            this.clingZ = Double.NaN;
            this.lastJumpY = Double.MAX_VALUE;
            this.staleWalls.clear();
            return;
        }
        this.updateWalls();
        int n = this.ticksKeyDown = Keybindings.CLING.method_1434() ? this.ticksKeyDown + 1 : 0;
        if (this.ticksWallClinged < 1) {
            if (this.ticksKeyDown > 0 && this.ticksKeyDown < 4 && !this.walls.isEmpty() && this.canWallCling()) {
                this.field_42108.method_48570(2.5f);
                this.field_42108.field_42109 = 2.5f;
                if (WallJump.CONFIGURATION.jumpconfigs.autoRotation) {
                    this.method_36456(this.getClingDirection().method_10153().method_10144());
                    this.field_5982 = this.method_36454();
                }
                this.ticksWallClinged = 1;
                this.clingX = this.method_23317();
                this.clingZ = this.method_23321();
                this.playHitSound(this.getWallPos());
                this.spawnWallParticle(this.getWallPos());
            }
            return;
        }
        if (!Keybindings.CLING.method_1434() || this.method_24828() || !this.method_37908().method_8316(this.method_24515()).method_15769() || this.walls.isEmpty() || this.method_7344().method_7586() < 1) {
            this.ticksWallClinged = 0;
            if (!(this.field_6250 == 0.0f && this.field_6212 == 0.0f || this.method_24828() || this.walls.isEmpty())) {
                this.field_6017 = 0.0f;
                class_2540 passedData = new class_2540(Unpooled.buffer());
                passedData.writeBoolean(true);
                ClientPlayNetworking.send((class_2960)WallJump.WALL_JUMP_PACKET_ID, (class_2540)passedData);
                this.wallJump(WallJump.CONFIGURATION.jumpconfigs.wallJumpXextra, WallJump.CONFIGURATION.jumpconfigs.wallJumpHeight, WallJump.CONFIGURATION.jumpconfigs.wallJumpZextra);
                this.staleWalls = new HashSet<class_2350>(this.walls);
            }
            return;
        }
        if (WallJump.CONFIGURATION.jumpconfigs.autoRotation) {
            this.method_36456(this.getClingDirection().method_10153().method_10144());
            this.field_5982 = this.method_36454();
        }
        this.method_23327(this.clingX, this.method_23318(), this.clingZ);
        double motionY = this.method_18798().method_10214();
        if (motionY > 0.0) {
            motionY = 0.0;
        } else if (motionY < -0.6) {
            motionY += 0.2;
            this.spawnWallParticle(this.getWallPos());
        } else if (this.ticksWallClinged++ > WallJump.CONFIGURATION.jumpconfigs.wallSlideDelay) {
            motionY = -0.1;
            this.spawnWallParticle(this.getWallPos());
        } else {
            motionY = 0.0;
        }
        if (this.field_6017 > 2.0f) {
            this.field_6017 = 0.0f;
            class_2540 passedData = new class_2540(Unpooled.buffer());
            passedData.writeFloat((float)(motionY * motionY * 8.0));
            ClientPlayNetworking.send((class_2960)WallJump.FALL_DISTANCE_PACKET_ID, (class_2540)passedData);
        }
        this.method_18800(0.0, motionY, 0.0);
    }

    private boolean canWallJump() {
        if (WallJump.CONFIGURATION.jumpconfigs.useWallJump) {
            return true;
        }
        class_1799 stack = this.method_6118(class_1304.field_6166);
        if (!stack.method_7960()) {
            Map enchantments = class_1890.method_8222((class_1799)stack);
            return enchantments.containsKey(WallJump.WALLJUMP_ENCHANTMENT);
        }
        return false;
    }

    private boolean canWallCling() {
        if (this.method_6101() || this.method_18798().method_10214() > 0.1 || this.method_7344().method_7586() < 1) {
            return false;
        }
        if (!this.isFree(this.method_5829().method_989(0.0, -0.8, 0.0))) {
            return false;
        }
        if (WallJump.CONFIGURATION.jumpconfigs.allowReClinging || this.method_23318() < this.lastJumpY - 1.0 || this.method_23318() > this.lastJumpY + 1.0) {
            return true;
        }
        return !this.staleWalls.containsAll(this.walls);
    }

    private void updateWalls() {
        class_238 box = new class_238(this.method_23317() - 0.001, this.method_23318(), this.method_23321() - 0.001, this.method_23317() + 0.001, this.method_23318() + (double)this.method_5751(), this.method_23321() + 0.001);
        double dist = (double)(this.method_17681() / 2.0f) + (this.ticksWallClinged > 0 ? 0.1 : 0.06);
        class_238[] axes = new class_238[]{box.method_1012(0.0, 0.0, dist), box.method_1012(-dist, 0.0, 0.0), box.method_1012(0.0, 0.0, -dist), box.method_1012(dist, 0.0, 0.0)};
        int i = 0;
        this.walls = new HashSet<class_2350>();
        for (class_238 axis : axes) {
            class_2350 direction = class_2350.method_10139((int)i++);
            if (this.isFree(axis)) continue;
            this.walls.add(direction);
            this.field_5976 = true;
        }
    }

    private class_2350 getClingDirection() {
        return this.walls.isEmpty() ? class_2350.field_11036 : this.walls.iterator().next();
    }

    private class_2338 getWallPos() {
        class_2338 clingPos = this.method_24515().method_10093(this.getClingDirection());
        return this.method_37908().method_8320(clingPos).method_51367() ? clingPos : clingPos.method_10093(class_2350.field_11036);
    }

    private void wallJump(float x, float up, float z) {
        float strafe = Math.signum(this.field_6212) * up * up;
        float forward = Math.signum(this.field_6250) * up * up;
        float f = 1.0f / class_3532.method_15355((float)(strafe * strafe + up * up + forward * forward));
        strafe *= f;
        forward *= f;
        float f1 = class_3532.method_15374((float)(this.method_5791() * ((float)Math.PI / 180))) * 0.45f;
        float f2 = class_3532.method_15362((float)(this.method_5791() * ((float)Math.PI / 180))) * 0.45f;
        int jumpBoostLevel = 0;
        class_1293 jumpBoostEffect = this.method_6112(class_1294.field_5913);
        if (jumpBoostEffect != null) {
            jumpBoostLevel = jumpBoostEffect.method_5578() + 1;
        }
        class_243 motion = this.method_18798();
        this.method_18800(motion.method_10216() + (double)(strafe * f2 - forward * f1) + (double)x + (double)jumpBoostLevel * 0.125, (double)up + (double)jumpBoostLevel * 0.125, motion.method_10215() + (double)(forward * f2 + strafe * f1) + (double)z + (double)jumpBoostLevel * 0.125);
        this.lastJumpY = this.method_23318();
        this.playBreakSound(this.getWallPos());
        this.spawnWallParticle(this.getWallPos());
    }

    private void playHitSound(class_2338 blockPos) {
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        class_2498 soundType = blockState.method_26204().method_9573(blockState);
        this.method_5783(soundType.method_10596(), soundType.method_10597() * 0.25f, soundType.method_10599());
    }

    private void playBreakSound(class_2338 blockPos) {
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        class_2498 soundType = blockState.method_26204().method_9573(blockState);
        this.method_5783(soundType.method_10593(), soundType.method_10597() * 0.5f, soundType.method_10599());
    }

    private void spawnWallParticle(class_2338 blockPos) {
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (blockState.method_26217() != class_2464.field_11455) {
            class_243 pos = this.method_19538();
            class_2382 motion = this.getClingDirection().method_10163();
            this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), pos.method_10216(), pos.method_10214(), pos.method_10215(), (double)motion.method_10263() * -1.0, -1.0, (double)motion.method_10260() * -1.0);
        }
    }
}

