/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.waterballoon.item;

import com.google.common.collect.Lists;
import com.nyfaria.waterballoon.entity.ThrownBalloon;
import com.nyfaria.waterballoon.init.ItemInit;
import com.nyfaria.waterballoon.item.BalloonItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BazookaItem
extends class_1811 {
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;

    public BazookaItem(class_1792.class_1793 $$0) {
        super($$0);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemStack = player.method_5998(usedHand);
        if (BazookaItem.isCharged(itemStack)) {
            BazookaItem.performShooting(level, (class_1309)player, usedHand, itemStack, BazookaItem.getShootingPower(itemStack), 1.0f);
            BazookaItem.setCharged(itemStack, false);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!player.method_18808(itemStack).method_7960()) {
            if (!BazookaItem.isCharged(itemStack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                player.method_6019(usedHand);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public Predicate<class_1799> method_19268() {
        return itemStack -> itemStack.method_31574(ItemInit.WATER_BALLOON.get());
    }

    private static float[] getShotPitches(class_5819 random) {
        boolean bl = random.method_43056();
        return new float[]{1.0f, BazookaItem.getRandomShotPitch(bl, random), BazookaItem.getRandomShotPitch(!bl, random)};
    }

    public static void performShooting(class_1937 level, class_1309 shooter, class_1268 usedHand, class_1799 crossbowStack, float velocity, float inaccuracy) {
        List<class_1799> list = BazookaItem.getChargedProjectiles(crossbowStack);
        float[] fs = BazookaItem.getShotPitches(shooter.method_6051());
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            class_1799 itemStack = list.get(i);
            boolean bl2 = bl = shooter instanceof class_1657 && ((class_1657)shooter).method_31549().field_7477;
            if (itemStack.method_7960()) continue;
            if (i == 0) {
                BazookaItem.shootProjectile(level, shooter, usedHand, crossbowStack, itemStack, fs[i], bl, velocity, inaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                BazookaItem.shootProjectile(level, shooter, usedHand, crossbowStack, itemStack, fs[i], bl, velocity, inaccuracy, -10.0f);
                continue;
            }
            if (i != 2) continue;
            BazookaItem.shootProjectile(level, shooter, usedHand, crossbowStack, itemStack, fs[i], bl, velocity, inaccuracy, 10.0f);
        }
        BazookaItem.onCrossbowShot(level, shooter, crossbowStack);
    }

    private static float getRandomShotPitch(boolean isHighPitched, class_5819 random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }

    private static void onCrossbowShot(class_1937 level, class_1309 shooter, class_1799 crossbowStack) {
        if (shooter instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)shooter;
            if (!level.field_9236) {
                class_174.field_1196.method_9115(serverPlayer, crossbowStack);
            }
            serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)crossbowStack.method_7909()));
        }
        BazookaItem.clearChargedProjectiles(crossbowStack);
    }

    private static float getShootingPower(class_1799 crossbowStack) {
        return BazookaItem.containsChargedProjectile(crossbowStack, class_1802.field_8639) ? 1.6f : 3.15f;
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 livingEntity, int timeCharged) {
        int i = this.method_7881(stack) - timeCharged;
        float f = BazookaItem.getPowerForTime(i, stack);
        if (f >= 1.0f && !BazookaItem.isCharged(stack) && BazookaItem.tryLoadProjectiles(livingEntity, stack)) {
            BazookaItem.setCharged(stack, true);
            class_3419 soundSource = livingEntity instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            level.method_43128((class_1657)null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), class_3417.field_14626, soundSource, 1.0f, 1.0f / (level.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(class_1309 shooter, class_1799 crossbowStack) {
        int j = 1;
        boolean bl = shooter instanceof class_1657 && ((class_1657)shooter).method_31549().field_7477;
        class_1799 itemStack = shooter.method_18808(crossbowStack);
        for (int k = 0; k < j; ++k) {
            if (itemStack.method_7960() && bl) {
                itemStack = new class_1799((class_1935)ItemInit.WATER_BALLOON.get());
            }
            if (BazookaItem.loadProjectile(shooter, crossbowStack, itemStack, false, bl)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(class_1309 shooter, class_1799 crossbowStack, class_1799 ammoStack, boolean hasAmmo, boolean isCreative) {
        class_1799 itemStack;
        boolean bl;
        if (ammoStack.method_7960()) {
            return false;
        }
        boolean bl2 = bl = isCreative && ammoStack.method_7909() instanceof BalloonItem;
        if (!(bl || isCreative || hasAmmo)) {
            itemStack = ammoStack.method_7971(1);
            if (ammoStack.method_7960() && shooter instanceof class_1657) {
                ((class_1657)shooter).method_31548().method_7378(ammoStack);
            }
        } else {
            itemStack = ammoStack.method_7972();
        }
        BazookaItem.addChargedProjectile(crossbowStack, itemStack);
        return true;
    }

    public static boolean isCharged(class_1799 crossbowStack) {
        class_2487 compoundTag = crossbowStack.method_7969();
        return compoundTag != null && compoundTag.method_10577("Charged");
    }

    public static void setCharged(class_1799 crossbowStack, boolean isCharged) {
        class_2487 compoundTag = crossbowStack.method_7948();
        compoundTag.method_10556("Charged", isCharged);
    }

    private static void addChargedProjectile(class_1799 crossbowStack, class_1799 ammoStack) {
        class_2487 compoundTag = crossbowStack.method_7948();
        class_2499 listTag = compoundTag.method_10573("ChargedProjectiles", 9) ? compoundTag.method_10554("ChargedProjectiles", 10) : new class_2499();
        class_2487 compoundTag2 = new class_2487();
        ammoStack.method_7953(compoundTag2);
        listTag.add((Object)compoundTag2);
        compoundTag.method_10566("ChargedProjectiles", (class_2520)listTag);
    }

    private static List<class_1799> getChargedProjectiles(class_1799 crossbowStack) {
        class_2499 listTag;
        ArrayList list = Lists.newArrayList();
        class_2487 compoundTag = crossbowStack.method_7969();
        if (compoundTag != null && compoundTag.method_10573("ChargedProjectiles", 9) && (listTag = compoundTag.method_10554("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag2 = listTag.method_10602(i);
                list.add(class_1799.method_7915((class_2487)compoundTag2));
            }
        }
        return list;
    }

    private static void clearChargedProjectiles(class_1799 crossbowStack) {
        class_2487 compoundTag = crossbowStack.method_7969();
        if (compoundTag != null) {
            class_2499 listTag = compoundTag.method_10554("ChargedProjectiles", 9);
            listTag.clear();
            compoundTag.method_10566("ChargedProjectiles", (class_2520)listTag);
        }
    }

    public static boolean containsChargedProjectile(class_1799 crossbowStack, class_1792 ammoItem) {
        return BazookaItem.getChargedProjectiles(crossbowStack).stream().anyMatch(itemStack -> itemStack.method_31574(ammoItem));
    }

    private static void shootProjectile(class_1937 level, class_1309 shooter, class_1268 hand, class_1799 crossbowStack, class_1799 ammoStack, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!level.field_9236) {
            ThrownBalloon projectile = BazookaItem.getArrow(level, shooter, crossbowStack, ammoStack);
            class_243 vec3 = shooter.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(projectileAngle * ((float)Math.PI / 180)), vec3.field_1352, vec3.field_1351, vec3.field_1350);
            class_243 vec32 = shooter.method_5828(1.0f);
            Vector3f vector3f = vec32.method_46409().rotate((Quaternionfc)quaternionf);
            projectile.method_7485(vector3f.x(), vector3f.y(), vector3f.z(), velocity, inaccuracy);
            crossbowStack.method_7956(1, shooter, livingEntity -> livingEntity.method_20236(hand));
            level.method_8649((class_1297)projectile);
            level.method_43128((class_1657)null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15187, class_3419.field_15248, 1.0f, soundPitch);
        }
    }

    private static ThrownBalloon getArrow(class_1937 level, class_1309 livingEntity, class_1799 crossbowStack, class_1799 ammoStack) {
        ThrownBalloon arrowItem = new ThrownBalloon(livingEntity, level);
        arrowItem.method_16940(ammoStack);
        return arrowItem;
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
        if (!level.field_9236) {
            int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
            class_3414 soundEvent = this.getStartSound(i);
            class_3414 soundEvent2 = i == 0 ? class_3417.field_14860 : null;
            float f = (float)(stack.method_7935() - remainingUseDuration) / (float)BazookaItem.getChargeDuration(stack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                level.method_43128((class_1657)null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), soundEvent, class_3419.field_15248, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                level.method_43128((class_1657)null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), soundEvent2, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
    }

    public int method_7881(class_1799 stack) {
        return BazookaItem.getChargeDuration(stack) + 3;
    }

    public static int getChargeDuration(class_1799 crossbowStack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)crossbowStack);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

    private class_3414 getStartSound(int enchantmentLevel) {
        switch (enchantmentLevel) {
            case 1: {
                return class_3417.field_15011;
            }
            case 2: {
                return class_3417.field_14916;
            }
            case 3: {
                return class_3417.field_15089;
            }
        }
        return class_3417.field_14765;
    }

    private static float getPowerForTime(int useTime, class_1799 crossbowStack) {
        float f = (float)useTime / (float)BazookaItem.getChargeDuration(crossbowStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        List<class_1799> list = BazookaItem.getChargedProjectiles(stack);
        if (BazookaItem.isCharged(stack) && !list.isEmpty()) {
            class_1799 itemStack = list.get(0);
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.minecraft.crossbow.projectile").method_27693(" ").method_10852(itemStack.method_7954()));
            if (isAdvanced.method_8035() && itemStack.method_31574(class_1802.field_8639)) {
                ArrayList list2 = Lists.newArrayList();
                class_1802.field_8639.method_7851(itemStack, level, (List)list2, isAdvanced);
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        list2.set(i, class_2561.method_43470((String)"  ").method_10852((class_2561)list2.get(i)).method_27692(class_124.field_1080));
                    }
                    tooltipComponents.addAll(list2);
                }
            }
        }
    }

    public boolean method_7838(class_1799 stack) {
        return stack.method_31574((class_1792)this);
    }

    public int method_24792() {
        return 8;
    }
}

