/*
 * Decompiled with CFR 0.152.
 */
package net.birchfolks.wetlands.entity.custom;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.birchfolks.wetlands.WetlandsMod;
import net.birchfolks.wetlands.WetlandsSounds;
import net.birchfolks.wetlands.block.WetlandsBlocks;
import net.birchfolks.wetlands.particles.WetlandsParticles;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1427;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5712;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class AbstractGearGolemEntity
extends class_1427
implements class_5354 {
    private static final class_2940<Integer> STUN = class_2945.method_12791(AbstractGearGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> STATE = class_2945.method_12791(AbstractGearGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> UNEARED = class_2945.method_12791(AbstractGearGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)600, (int)1200);
    private int angerTime;
    @Nullable
    private UUID angryAt;

    public AbstractGearGolemEntity(class_1299<? extends class_1427> entityType, class_1937 world) {
        super(entityType, world);
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(UNEARED, (Object)false);
        this.field_6011.method_12784(STUN, (Object)0);
        this.field_6011.method_12784(STATE, (Object)0);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(UNEARED, (Object)nbt.method_10577("Uneared"));
        this.field_6011.method_12778(STUN, (Object)nbt.method_10550("Stan"));
        this.field_6011.method_12778(STATE, (Object)nbt.method_10550("State"));
        this.method_29512(this.method_37908(), nbt);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Uneared", ((Boolean)this.field_6011.method_12789(UNEARED)).booleanValue());
        nbt.method_10569("Stan", ((Integer)this.field_6011.method_12789(STUN)).intValue());
        nbt.method_10569("State", ((Integer)this.field_6011.method_12789(STATE)).intValue());
        this.method_29517(nbt);
    }

    protected class_3414 method_6011(class_1282 source) {
        return WetlandsSounds.GOLEM_HURT;
    }

    protected class_3414 method_6002() {
        return WetlandsSounds.GOLEM_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_15233, 1.0f, 0.5f);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8868) && !this.getUneared()) {
            int i = this.field_5974.method_39332(1, 2);
            for (int j = 0; j < i; ++j) {
                class_1542 itemEntity = this.method_5870((class_1935)WetlandsBlocks.GEAR_BLOCK, 1);
                if (itemEntity == null) continue;
                itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
            }
            this.setUneared(true);
            this.method_37908().method_43129((class_1657)null, (class_1297)this, class_3417.field_14975, class_3419.field_15248, 1.0f, 1.0f);
            this.method_32875(class_5712.field_28730, (class_1297)player);
            itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    private float getAttackDamage() {
        return (float)this.method_26825(class_5134.field_23721);
    }

    public boolean method_6121(class_1297 target) {
        this.method_37908().method_8421((class_1297)this, (byte)4);
        float f = this.getAttackDamage();
        float g = (int)f > 0 ? f / 2.0f + (float)this.field_5974.method_43048((int)f) : f;
        boolean bl = target.method_5643(this.method_48923().method_48812((class_1309)this), g);
        if (bl) {
            double var10000;
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                var10000 = livingEntity.method_26825(class_5134.field_23718);
            } else {
                var10000 = 0.0;
            }
            double d = var10000;
            double e = Math.max(0.0, 1.0 - d);
            target.method_18799(target.method_18798().method_1031(0.0, 0.6000000059604645 * e, 0.0));
            this.method_5723((class_1309)this, target);
        }
        this.method_5783(WetlandsSounds.GOLEM_ATTACK, 1.0f, 0.5f);
        return bl;
    }

    public boolean method_5643(class_1282 source, float amount) {
        double headStart = this.method_19538().method_1031((double)0.0, (double)(this.method_24833((class_4050)this.method_18376()).method_17940() * 0.85), (double)0.0).field_1351 - 0.3;
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_5526() instanceof class_1665) {
            if (this.getState() != AnimState.getId(AnimState.STUN) && this.getState() != AnimState.getId(AnimState.SLAM)) {
                if (source.method_5510().field_1351 >= headStart) {
                    this.setStun(140);
                    this.setState(AnimState.getId(AnimState.STUN));
                    if (amount * 2.0f >= this.method_6032()) {
                        this.method_6092(new class_1293(class_1294.field_5919, 1, 255, false, false));
                        if (!this.method_37908().method_8608() && source.method_5529() instanceof class_3222) {
                            WetlandsMod.HEADSHOT.method_8990((class_3222)source.method_5529(), (class_1297)this, source);
                        }
                    }
                } else {
                    return false;
                }
                Crack crack = this.getCrack();
                boolean bl = super.method_5643(source, amount * 2.0f);
                return bl;
            }
            return false;
        }
        Crack crack = this.getCrack();
        boolean bl = super.method_5643(source, amount);
        return bl;
    }

    public void method_5773() {
        super.method_5773();
        if (AnimState.stopAI(this.getState())) {
            this.field_6201.method_6276(class_1352.class_4134.field_18405, false);
            this.field_6201.method_6276(class_1352.class_4134.field_18407, false);
            this.field_6201.method_6276(class_1352.class_4134.field_18406, false);
        }
        if (AnimState.from(this.getState()) == AnimState.SHOOT) {
            this.field_6201.method_6276(class_1352.class_4134.field_18405, false);
            this.field_6201.method_6276(class_1352.class_4134.field_18407, false);
            this.field_6201.method_6276(class_1352.class_4134.field_18406, false);
        }
        if (AnimState.from(this.getState()) == AnimState.STUN) {
            this.spawnStunSparks();
            this.setStun(this.getStun() - 1);
            if (this.getStun() <= 0) {
                if (this.afterStunEffect()) {
                    this.setState(AnimState.getId(AnimState.SLAM));
                } else {
                    this.setState(AnimState.getId(AnimState.NONE));
                }
            }
        }
        if (this.field_5974.method_43057() < 0.08f) {
            this.spawnHandParticles();
        }
        if (AnimState.from(this.getState()) != AnimState.STUN && !this.method_37908().method_8608()) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
    }

    public void setUneared(boolean uneared) {
        this.field_6011.method_12778(UNEARED, (Object)uneared);
    }

    public boolean getUneared() {
        return (Boolean)this.field_6011.method_12789(UNEARED);
    }

    public void setStun(int stun) {
        this.field_6011.method_12778(STUN, (Object)stun);
    }

    public int getStun() {
        return (Integer)this.field_6011.method_12789(STUN);
    }

    public void spawnHandParticles() {
        this.spawnHandParticles(1.3f, 1.15f);
    }

    public void hitParticles(double x, double y, double z) {
        class_2680 state = this.method_37908().method_8320(new class_2338((int)x, (int)(y - 1.0), (int)z));
        float j = 10.0f;
        double k = Math.min((double)(0.2f + j / 15.0f), 2.5);
        int l = (int)(150.0 * k);
        for (int i = 0; i < 50; ++i) {
            this.method_37908().method_8406((class_2394)WetlandsParticles.RUST, x, y, z, this.field_5974.method_43058() * 0.4 - 0.2, 0.3, this.field_5974.method_43058() * 0.4 - 0.2);
            if (!(this.field_5974.method_43058() > 0.8)) continue;
            this.method_37908().method_8406((class_2394)class_2398.field_11237, x + this.field_5974.method_43058() * 2.0 - 1.0, y, z + this.field_5974.method_43058() * 2.0 - 1.0, 0.0, 0.1, 0.0);
        }
    }

    public void spawnHitParticles(double angle) {
        double g = (double)(this.field_6283 * ((float)Math.PI / 180)) + 2.5132741228718345 + angle;
        double g1 = (double)(this.field_6283 * ((float)Math.PI / 180)) + 0.6283185307179586 + angle;
        double h = Math.cos(g);
        double i = Math.sin(g);
        double h1 = Math.cos(g1);
        double i1 = Math.sin(g1);
        this.hitParticles(this.method_23317() + h * 2.0, this.method_23318(), this.method_23321() + i * 2.0);
        this.hitParticles(this.method_23317() + h1 * 2.0, this.method_23318(), this.method_23321() + i1 * 2.0);
    }

    public void spawnInitParticles() {
        this.spawnStunSparks();
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        for (int i = 0; i < 15; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11204, x, y + (double)this.method_17682() * 0.3, z, this.field_5974.method_43058() * 0.2 - 0.1, this.field_5974.method_43058() * 0.2, this.field_5974.method_43058() * 0.2 - 0.1);
        }
    }

    public void spawnHandParticles(float height, float offset) {
        class_2400 eff = class_2398.field_11251;
        double d = 0.0;
        double e = 0.1;
        double f = 0.0;
        double g = (double)(this.field_6283 * ((float)Math.PI / 180)) + Math.cos((float)this.field_6012 * 0.6662f) * 0.25;
        double h = Math.cos(g);
        double i = Math.sin(g);
        this.method_37908().method_8406((class_2394)eff, this.method_23317() + h * (double)offset, this.method_23318() + (double)height, this.method_23321() + i * (double)offset, d, e, f);
        this.method_37908().method_8406((class_2394)eff, this.method_23317() - h * (double)offset, this.method_23318() + (double)height, this.method_23321() - i * (double)offset, d, e, f);
    }

    public void spawnStunSparks() {
        float r = 0.98f;
        float v = (this.field_5974.method_43057() * (2.0f * r) - r) * 2.25f;
        for (int i = 0; i < 2; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
        }
    }

    public boolean afterStunEffect() {
        return false;
    }

    public void damageTargets(float radius) {
        for (class_1297 e : this.method_37908().method_8335(null, new class_238(this.method_19538().method_1031((double)(-radius), (double)(-radius), (double)(-radius)), this.method_19538().method_1031((double)radius, (double)radius, (double)radius)))) {
            double var10000;
            class_1309 living;
            if (!(e instanceof class_1309) || (living = (class_1309)e) == this) continue;
            double r = Math.sqrt(living.method_5858((class_1297)this));
            float d = (float)((double)radius - Math.min(r, (double)radius));
            boolean bl = living.method_5643(this.method_48923().method_48812((class_1309)this), d);
            if (!bl) continue;
            if (living instanceof class_1309) {
                class_1309 livingEntity = living;
                var10000 = livingEntity.method_26825(class_5134.field_23718);
            } else {
                var10000 = 0.0;
            }
            double dd = var10000;
            double ee = Math.max(0.0, 1.0 - dd);
            living.method_18799(living.method_18798().method_1031(0.0, 0.6000000059604645 * ee, 0.0));
            this.method_5723((class_1309)this, (class_1297)living);
        }
    }

    public Crack getCrack() {
        return Crack.from(this.method_6032() / this.method_6063());
    }

    public int getState() {
        return (Integer)this.field_6011.method_12789(STATE);
    }

    public void setState(int stateId) {
        this.field_6011.method_12778(STATE, (Object)stateId);
    }

    public static enum AnimState {
        NONE(0, false),
        ATTACK(1, false),
        STUN(2, true),
        SLAM(3, true),
        SHOOT(4, false),
        SPAWN(5, true);

        private static final List VALUES;
        private boolean stopAi = false;
        private int id;

        private AnimState(int id, boolean StopAi) {
            this.id = id;
            this.stopAi = StopAi;
        }

        public static AnimState from(int stateId) {
            AnimState state;
            Iterator var1 = VALUES.iterator();
            do {
                if (!var1.hasNext()) {
                    return NONE;
                }
                state = (AnimState)((Object)var1.next());
            } while (state.id != stateId);
            return state;
        }

        public static AnimState of(int stateId, boolean stopAi) {
            AnimState state = null;
            state.stopAi = stopAi;
            state.id = stateId;
            return state;
        }

        public static boolean stopAI(int stateId) {
            AnimState state = AnimState.from(stateId);
            return state.stopAi;
        }

        public static boolean stopAI(AnimState state) {
            return state.stopAi;
        }

        public static int getId(AnimState state) {
            return state.id;
        }

        static {
            VALUES = (List)Stream.of(AnimState.values()).sorted(Comparator.comparingDouble(state -> state.id)).collect(ImmutableList.toImmutableList());
        }
    }

    public static enum Crack {
        NONE(1.0f),
        LOW(0.66f),
        HIGH(0.33f);

        private static final List VALUES;
        private final float maxHealthFraction;

        private Crack(float maxHealthFraction) {
            this.maxHealthFraction = maxHealthFraction;
        }

        public static Crack from(float healthFraction) {
            Crack crack;
            Iterator var1 = VALUES.iterator();
            do {
                if (!var1.hasNext()) {
                    return NONE;
                }
                crack = (Crack)((Object)var1.next());
            } while (!(healthFraction < crack.maxHealthFraction));
            return crack;
        }

        static {
            VALUES = (List)Stream.of(Crack.values()).sorted(Comparator.comparingDouble(crack -> crack.maxHealthFraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

