/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.mixin.EditBoxAccess;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputValue<T>
extends ConfigValue<T, InputValue<T>> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?\\d*$");
    public static final Predicate<String> POSITIVE_INTEGER = s -> s.matches("\\d*$");
    public static final Predicate<String> DECIMAL = s -> s.matches("[-+]?\\d*([.]\\d*)?");
    public static final Predicate<String> POSITIVE_DECIMAL = s -> s.matches("\\d*([.]\\d*)?");
    public static final Predicate<String> IDENTIFIER = s -> s.matches("^[a-z\\d_./-]*$") || s.matches("^[a-z\\d_.-]*:[a-z\\d_./-]*$");
    private final Predicate<String> validator;
    private final Serializer<T> serializer;
    protected final WatchedTextfield textField;
    private boolean valueFromTextField = false;
    private boolean valueValid = true;

    public InputValue(String optionName, final T value, @Nullable T defaultValue, Consumer<T> save, Predicate<String> validator) {
        this(optionName, value, defaultValue, save, validator, new Serializer<T>(){

            @Override
            public String serialize(T t) {
                return String.valueOf(t);
            }

            @Override
            public T deserialize(String s) {
                if (value instanceof String) {
                    return s;
                }
                if (value instanceof Integer) {
                    return s.isEmpty() ? Integer.valueOf(0) : Integer.valueOf(s);
                }
                if (value instanceof Short) {
                    return s.isEmpty() ? Short.valueOf((short)0) : Short.valueOf(s);
                }
                if (value instanceof Byte) {
                    return s.isEmpty() ? Byte.valueOf((byte)0) : Byte.valueOf(s);
                }
                if (value instanceof Long) {
                    return s.isEmpty() ? Long.valueOf(0L) : Long.valueOf(s);
                }
                if (value instanceof Double) {
                    return s.isEmpty() ? Double.valueOf(0.0) : Double.valueOf(s);
                }
                if (value instanceof Float) {
                    return s.isEmpty() ? Float.valueOf(0.0f) : Float.valueOf(s);
                }
                throw new UnsupportedOperationException("Unsupported value type");
            }
        });
    }

    public InputValue(String optionName, T value, @Nullable T defaultValue, Consumer<T> save, Predicate<String> validator, Serializer<T> serializer) {
        super(optionName, value, defaultValue, save);
        this.validator = validator;
        this.serializer = serializer;
        this.textField = new WatchedTextfield();
        this.textField.method_1852(serializer.serialize(value));
    }

    @Override
    protected void drawValue(class_332 ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.method_1888(!this.isDisabled());
        this.textField.method_46421(x + width - this.textField.method_25368());
        this.textField.method_46419(y + (height - this.textField.method_25364()) / 2);
        this.textField.method_25394(ctx, mouseX, mouseY, partialTicks);
    }

    @Override
    public void tick() {
        this.textField.method_1865();
    }

    @NotNull
    public WatchedTextfield getListener() {
        return this.textField;
    }

    @Override
    protected void resetValue() {
        this.textField.method_1852(this.serializer.serialize(this.defaultValue));
    }

    @Override
    public boolean isValueValid() {
        return this.valueValid;
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        super.buildSearchKey(sb);
        sb.append(" ").append(this.textField.method_1882());
    }

    @Override
    private void setValue(String text) {
        if (!this.validator.test(text)) {
            this.valueValid = false;
            this.callWatchers();
            return;
        }
        this.valueFromTextField = true;
        try {
            this.setValue(this.serializer.deserialize(text));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.callWatchers();
    }

    @Override
    public void setValue(T value) {
        this.setValue(value, false);
        if (!this.valueFromTextField) {
            EditBoxAccess access = (EditBoxAccess)((Object)this.textField);
            access.wthit_value(this.serializer.serialize(value));
            this.textField.method_1875(access.wthit_value().length());
            this.textField.method_1884(this.textField.method_1881());
            this.callWatchers();
        }
        this.valueFromTextField = false;
        this.valueValid = true;
    }

    public static interface Serializer<T> {
        public String serialize(T var1);

        public T deserialize(String var1);
    }

    public class WatchedTextfield
    extends class_342 {
        public boolean grow;

        public WatchedTextfield() {
            super(((InputValue)InputValue.this).client.field_1772, 0, 0, 100, 18, (class_2561)class_2561.method_43473());
            this.grow = true;
            this.method_1863(InputValue.this::setValue);
            this.method_1880(Integer.MAX_VALUE);
        }

        private void recalculateWidth(boolean reset) {
            if (!this.grow) {
                return;
            }
            if (reset) {
                this.method_25358(100);
            } else {
                this.method_25358(class_3532.method_15340((int)(((InputValue)InputValue.this).client.field_1772.method_1727(this.method_1882()) + 8), (int)100, (int)300));
            }
            int cursor = this.method_1881();
            this.method_1883(0);
            this.method_1883(cursor);
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            this.recalculateWidth(!focused);
        }

        public void method_1867(@NotNull String string) {
            String string2;
            int l;
            EditBoxAccess access = (EditBoxAccess)((Object)this);
            int i = Math.min(this.method_1881(), access.wthit_highlightPos());
            int j = Math.max(this.method_1881(), access.wthit_highlightPos());
            int k = access.wthit_maxLength() - this.method_1882().length() - (i - j);
            if (k < (l = (string2 = string).length())) {
                string2 = string2.substring(0, k);
                l = k;
            }
            String string3 = new StringBuilder(this.method_1882()).replace(i, j, string2).toString();
            if (access.wthit_filter().test(string3)) {
                access.wthit_value(string3);
                this.method_1875(i + l);
                this.method_1884(this.method_1881());
                access.wthit_onValueChange(string3);
                this.recalculateWidth(false);
            }
        }
    }
}

