/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.attributeslib.ALConfig;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import dev.shadowsoffire.attributeslib.api.AttributeHelper;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.attributeslib.api.client.AddAttributeTooltipsEvent;
import dev.shadowsoffire.attributeslib.api.client.GatherEffectScreenTooltipsEvent;
import dev.shadowsoffire.attributeslib.api.client.GatherSkippedAttributeTooltipsEvent;
import dev.shadowsoffire.attributeslib.api.client.ItemTooltipCallbackWithPlayer;
import dev.shadowsoffire.attributeslib.packet.CritParticleMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_2396;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_657;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class AttributesLibClient
implements ClientModInitializer {
    private static final UUID FAKE_MERGED_UUID = UUID.fromString("a6b0ac71-e435-416e-a991-7623eaa129a4");

    public void onInitializeClient() {
        this.tooltips();
        this.effectGuiTooltips();
        this.potionTooltips();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(ALConfig.makeReloader());
        ParticleFactoryRegistry.getInstance().register((class_2396)ALObjects.Particles.APOTH_CRIT, class_657.class_3939::new);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CritParticleMessage.ID, (client, handler, buf, responseSender) -> {
            int id = buf.readInt();
            client.execute(() -> CritParticleMessage.apothCrit(id));
        });
    }

    public void tooltips() {
        ItemTooltipCallbackWithPlayer.EVENT.register((stack, context, list, player) -> {
            int markIdx1 = -1;
            int markIdx2 = -1;
            for (int i = 0; i < list.size(); ++i) {
                class_7417 patt3365$temp = ((class_2561)list.get(i)).method_10851();
                if (!(patt3365$temp instanceof class_2585)) continue;
                class_2585 tc = (class_2585)patt3365$temp;
                if ("ZENITH_REMOVE_MARKER".equals(tc.comp_737())) {
                    markIdx1 = i;
                }
                if (!"ZENITH_REMOVE_MARKER_2".equals(tc.comp_737())) continue;
                markIdx2 = i;
                break;
            }
            if (markIdx1 == -1 || markIdx2 == -1) {
                return;
            }
            ListIterator<class_2561> it = list.listIterator(markIdx1);
            for (int i = markIdx1; i < markIdx2 + 1; ++i) {
                it.next();
                it.remove();
            }
            int flags = AttributesLibClient.getHideFlags(stack);
            if (AttributesLibClient.shouldShowInTooltip(flags, class_1799.class_5422.field_25769)) {
                AttributesLibClient.applyModifierTooltips(player, stack, it::add, context);
            }
            ((AddAttributeTooltipsEvent)AddAttributeTooltipsEvent.EVENT.invoker()).getTooltip(stack, player, list, it, context);
        });
    }

    public void effectGuiTooltips() {
        GatherEffectScreenTooltipsEvent.GATHER_TOOLTIPS.register(e -> {
            String key;
            List<class_2561> tooltips = e.getTooltip();
            class_1293 effectInst = e.getEffectInstance();
            class_1291 effect = effectInst.method_5579();
            class_5250 name = (class_5250)tooltips.get(0);
            class_2561 duration = tooltips.remove(1);
            duration = class_2561.method_43469((String)"(%s)", (Object[])new Object[]{duration}).method_27692(class_124.field_1068);
            name.method_27693(" ").method_10852(duration);
            if (AttributesLib.getTooltipFlag().method_8035()) {
                name.method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"[%s]", (Object[])new Object[]{class_7923.field_41174.method_10221((Object)effect)}).method_27692(class_124.field_1080));
            }
            if (class_1074.method_4663((String)(key = effect.method_5567() + ".desc"))) {
                tooltips.add((class_2561)class_2561.method_43471((String)key).method_27692(class_124.field_1063));
            } else if (AttributesLib.getTooltipFlag().method_8035() && effect.method_5565().isEmpty()) {
                tooltips.add((class_2561)class_2561.method_43471((String)key).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
            }
            ArrayList list = Lists.newArrayList();
            Map map = effect.method_5565();
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    class_1322 attributemodifier = (class_1322)entry.getValue();
                    class_1322 attributemodifier1 = new class_1322(attributemodifier.method_6185(), effect.method_5563(effectInst.method_5578(), attributemodifier), attributemodifier.method_6182());
                    list.add(new Pair((Object)((class_1320)entry.getKey()), (Object)attributemodifier1));
                }
            }
            if (!list.isEmpty()) {
                for (Pair pair : list) {
                    tooltips.add((class_2561)IFormattableAttribute.toComponent((class_1320)pair.getFirst(), (class_1322)pair.getSecond(), AttributesLib.getTooltipFlag()));
                }
            }
        });
    }

    public void potionTooltips() {
        ItemTooltipCallback.EVENT.register((stack, context, tooltips) -> {
            List effects;
            if (!ALConfig.enablePotionTooltips) {
                return;
            }
            if (stack.method_7909() instanceof class_1812 && (effects = class_1844.method_8067((class_1799)stack)).size() == 1 && tooltips.size() >= 2) {
                class_1291 effect = ((class_1293)effects.get(0)).method_5579();
                String key = effect.method_5567() + ".desc";
                if (class_1074.method_4663((String)key)) {
                    tooltips.add(2, class_2561.method_43471((String)key).method_27692(class_124.field_1063));
                } else if (context.method_8035() && effect.method_5565().isEmpty()) {
                    tooltips.add(2, class_2561.method_43471((String)key).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
                }
            }
        });
    }

    public static Multimap<class_1320, class_1322> getSortedModifiers(class_1799 stack, class_1304 slot) {
        Multimap unsorted = stack.method_7926(slot);
        Multimap<class_1320, class_1322> map = AttributeHelper.sortedMap();
        for (Map.Entry ent : unsorted.entries()) {
            if (ent.getKey() != null && ent.getValue() != null) {
                map.put((Object)((class_1320)ent.getKey()), (Object)((class_1322)ent.getValue()));
                continue;
            }
            AttributesLib.LOGGER.debug("Detected broken attribute modifier entry on item {}.  Attr={}, Modif={}", (Object)stack, ent.getKey(), ent.getValue());
        }
        return map;
    }

    private static boolean shouldShowInTooltip(int pHideFlags, class_1799.class_5422 pPart) {
        return (pHideFlags & pPart.method_30269()) == 0;
    }

    private static int getHideFlags(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10573("HideFlags", 99) ? stack.method_7969().method_10550("HideFlags") : stack.method_7909().getDefaultTooltipHideFlags(stack);
    }

    private static void applyModifierTooltips(@Nullable class_1657 player, class_1799 stack, Consumer<class_2561> tooltip, class_1836 flag) {
        Multimap<class_1320, class_1322> mainhand = AttributesLibClient.getSortedModifiers(stack, class_1304.field_6173);
        Multimap<class_1320, class_1322> offhand = AttributesLibClient.getSortedModifiers(stack, class_1304.field_6171);
        Multimap<class_1320, class_1322> dualHand = AttributeHelper.sortedMap();
        for (class_1320 atr : mainhand.keys()) {
            Collection modifMh = mainhand.get((Object)atr);
            Collection modifOh = offhand.get((Object)atr);
            modifMh.stream().filter(a1 -> modifOh.stream().anyMatch(a2 -> a1.method_6189().equals(a2.method_6189()))).forEach(modif -> dualHand.put((Object)atr, modif));
        }
        dualHand.values().forEach(m -> {
            mainhand.values().remove(m);
            offhand.values().removeIf(m1 -> m1.method_6189().equals(m.method_6189()));
        });
        HashSet<UUID> skips = new HashSet<UUID>();
        ((GatherSkippedAttributeTooltipsEvent)GatherSkippedAttributeTooltipsEvent.EVENT.invoker()).gather(stack, player, skips, flag);
        AttributesLibClient.applyTextFor(player, stack, tooltip, dualHand, "both_hands", skips, flag);
        AttributesLibClient.applyTextFor(player, stack, tooltip, mainhand, class_1304.field_6173.method_5923(), skips, flag);
        AttributesLibClient.applyTextFor(player, stack, tooltip, offhand, class_1304.field_6171.method_5923(), skips, flag);
        for (class_1304 slot : class_1304.values()) {
            if (slot.ordinal() < 2) continue;
            Multimap<class_1320, class_1322> modifiers = AttributesLibClient.getSortedModifiers(stack, slot);
            AttributesLibClient.applyTextFor(player, stack, tooltip, modifiers, slot.method_5923(), skips, flag);
        }
    }

    private static class_5250 padded(String padding, class_2561 comp) {
        return class_2561.method_43470((String)padding).method_10852(comp);
    }

    private static class_5250 list() {
        return AttributeHelper.list();
    }

    private static void applyTextFor(@Nullable class_1657 player, class_1799 stack, Consumer<class_2561> tooltip, Multimap<class_1320, class_1322> modifierMap, String group, Set<UUID> skips, class_1836 flag) {
        if (!modifierMap.isEmpty()) {
            modifierMap.values().removeIf(m -> skips.contains(m.method_6189()));
            tooltip.accept((class_2561)class_2561.method_43473());
            tooltip.accept((class_2561)class_2561.method_43471((String)("item.modifiers." + group)).method_27692(class_124.field_1080));
            if (modifierMap.isEmpty()) {
                return;
            }
            IdentityHashMap baseModifs = new IdentityHashMap();
            modifierMap.forEach((attr, modif) -> {
                if (modif.method_6189().equals(((IFormattableAttribute)attr).getBaseUUID())) {
                    baseModifs.put(attr, new BaseModifier((class_1322)modif, (List<class_1322>)new ArrayList<class_1322>()));
                }
            });
            modifierMap.forEach((attr, modif) -> {
                BaseModifier base = (BaseModifier)baseModifs.get(attr);
                if (base != null && base.base != modif) {
                    base.children.add((class_1322)modif);
                }
            });
            for (Map.Entry entry : baseModifs.entrySet()) {
                double base;
                class_1320 attr2 = (class_1320)entry.getKey();
                BaseModifier baseModif = (BaseModifier)entry.getValue();
                double entityBase = player == null ? 0.0 : player.method_26826(attr2);
                double rawBase = base = baseModif.base.method_6186() + entityBase;
                double amt = base;
                double baseBonus = ((IFormattableAttribute)attr2).getBonusBaseValue(stack);
                for (class_1322 modif2 : baseModif.children) {
                    if (modif2.method_6182() == class_1322.class_1323.field_6328) {
                        base = amt += modif2.method_6186();
                        continue;
                    }
                    if (modif2.method_6182() == class_1322.class_1323.field_6330) {
                        amt += modif2.method_6186() * base;
                        continue;
                    }
                    amt *= 1.0 + modif2.method_6186();
                }
                boolean isMerged = !baseModif.children.isEmpty() || baseBonus != 0.0;
                class_5250 text = IFormattableAttribute.toBaseComponent(attr2, amt += baseBonus, entityBase, isMerged, flag);
                tooltip.accept((class_2561)AttributesLibClient.padded(" ", (class_2561)text).method_27692(isMerged ? class_124.field_1065 : class_124.field_1077));
                if (!class_437.method_25442() || !isMerged) continue;
                text = IFormattableAttribute.toBaseComponent(attr2, rawBase, entityBase, false, flag);
                tooltip.accept((class_2561)AttributesLibClient.list().method_10852((class_2561)text.method_27692(class_124.field_1077)));
                for (class_1322 modifier : baseModif.children) {
                    tooltip.accept((class_2561)AttributesLibClient.list().method_10852((class_2561)IFormattableAttribute.toComponent(attr2, modifier, flag)));
                }
                if (!(baseBonus > 0.0)) continue;
                ((IFormattableAttribute)attr2).addBonusTooltips(stack, tooltip, flag);
            }
            for (class_1320 attr3 : modifierMap.keySet()) {
                if (baseModifs.containsKey(attr3)) continue;
                Collection modifs = modifierMap.get((Object)attr3);
                if (modifs.size() > 1) {
                    double[] sums = new double[3];
                    boolean[] merged = new boolean[3];
                    HashMap<class_1322.class_1323, List> shiftExpands = new HashMap<class_1322.class_1323, List>();
                    for (class_1322 modifier : modifs) {
                        if (modifier.method_6186() == 0.0) continue;
                        if (sums[modifier.method_6182().ordinal()] != 0.0) {
                            merged[modifier.method_6182().ordinal()] = true;
                        }
                        int n = modifier.method_6182().ordinal();
                        sums[n] = sums[n] + modifier.method_6186();
                        shiftExpands.computeIfAbsent(modifier.method_6182(), k -> new LinkedList()).add(modifier);
                    }
                    for (class_1322.class_1323 op : class_1322.class_1323.values()) {
                        int i = op.ordinal();
                        if (sums[i] == 0.0) continue;
                        if (merged[i]) {
                            class_5251 color;
                            class_5251 class_52512 = color = sums[i] < 0.0 ? class_5251.method_27717((int)16331057) : class_5251.method_27717((int)8026873);
                            if (sums[i] < 0.0) {
                                int n = i;
                                sums[n] = sums[n] * -1.0;
                            }
                            class_1322 fakeModif = new class_1322(FAKE_MERGED_UUID, () -> "zenith_attributes:merged", sums[i], op);
                            class_5250 comp = IFormattableAttribute.toComponent(attr3, fakeModif, flag);
                            tooltip.accept((class_2561)comp.method_27696(comp.method_10866().method_27703(color)));
                            if (!merged[i] || !class_437.method_25442()) continue;
                            ((List)shiftExpands.get(class_1322.class_1323.method_6190((int)i))).forEach(modif -> tooltip.accept((class_2561)AttributesLibClient.list().method_10852((class_2561)IFormattableAttribute.toComponent(attr3, modif, flag))));
                            continue;
                        }
                        class_1322 fakeModif = new class_1322(FAKE_MERGED_UUID, () -> "zenith_attributes:merged", sums[i], op);
                        tooltip.accept((class_2561)IFormattableAttribute.toComponent(attr3, fakeModif, flag));
                    }
                    continue;
                }
                modifs.forEach(m -> {
                    if (m.method_6186() != 0.0) {
                        tooltip.accept((class_2561)IFormattableAttribute.toComponent(attr3, m, flag));
                    }
                });
            }
        }
    }

    private record BaseModifier(class_1322 base, List<class_1322> children) {
    }
}

