#include "/lib/colors/skyColors.glsl"

float GetStarNoise(vec2 pos) {
    return fract(sin(dot(pos, vec2(12.9898, 4.1414))) * 43758.54953);
}

vec2 GetStarCoord(vec3 viewPos, float sphereness) {
    vec3 wpos = normalize((gbufferModelViewInverse * vec4(viewPos * 1000.0, 1.0)).xyz);
    vec3 starCoord = wpos / (wpos.y + length(wpos.xz) * sphereness);
    starCoord.x += 0.006 * syncedTime;
    return starCoord.xz;
}

vec3 GetStars(vec2 starCoord, float VdotU, float VdotS) {
    if (VdotU < 0.0) return vec3(0.0);

    starCoord *= 0.15; // Reduced from 0.2 to make stars closer together
    float starFactor = 2048.0; // Increased from 1024.0 for more stars
    starCoord = floor(starCoord * starFactor) / starFactor;

    // Enhanced star system with multiple layers
    float star = 1.0;
    star *= GetStarNoise(starCoord.xy);
    star *= GetStarNoise(starCoord.xy+0.1);
    star *= GetStarNoise(starCoord.xy+0.23);

    #if NIGHT_STAR_AMOUNT == 2
        star -= 0.7;
    #else
        star -= 0.6;
        star *= 0.65;
    #endif
    star = max0(star);
    star *= star;
    
    // Añadir bloom selectivo a estrellas brillantes (más intenso)
    float starBrightness = star;
    if (star > 0.3) { // Solo a estrellas más brillantes
        float bloomFactor = (star - 0.3) / 0.7; // Factor de bloom gradual
        star += star * bloomFactor * 0.7; // Bloom más intenso
    }

    // Add twinkling effect
    float twinkle = sin(syncedTime * 2.0 + starCoord.x * 100.0) * 0.1 + 0.9;
    star *= twinkle;

    // All stars are now royal blue
    vec3 starColor = vec3(0.4, 0.6, 1.0); // Beautiful royal blue color for all stars

    star *= min1(VdotU * 3.0) * max0(1.0 - pow(abs(VdotS) * 1.002, 100.0));
    star *= invRainFactor * pow2(pow2(invNoonFactor2)) * (1.0 - 0.5 * sunVisibility);

    // Add second layer of stars for more density
    vec2 starCoord2 = starCoord * 1.5 + vec2(0.3, 0.7);
    float star2 = 1.0;
    star2 *= GetStarNoise(starCoord2.xy);
    star2 *= GetStarNoise(starCoord2.xy + 0.15);
    star2 *= GetStarNoise(starCoord2.xy + 0.33);
    
    #if NIGHT_STAR_AMOUNT == 2
        star2 -= 0.75;
    #else
        star2 -= 0.65;
        star2 *= 0.6;
    #endif
    star2 = max0(star2);
    star2 *= star2;
    
    // Añadir bloom selectivo a estrellas brillantes (segunda capa, más intenso)
    if (star2 > 0.25) { // Solo a estrellas más brillantes
        float bloomFactor2 = (star2 - 0.25) / 0.75; // Factor de bloom gradual
        star2 += star2 * bloomFactor2 * 0.6; // Bloom más intenso
    }
    
    // Add twinkling to second layer
    float twinkle2 = sin(syncedTime * 1.5 + starCoord2.x * 150.0) * 0.12 + 0.88;
    star2 *= twinkle2;
    
    star2 *= min1(VdotU * 2.5) * max0(1.0 - pow(abs(VdotS) * 1.002, 80.0));
    star2 *= invRainFactor * pow2(pow2(invNoonFactor2)) * (1.0 - 0.6 * sunVisibility);

    return 50.0 * star * starColor + 35.0 * star2 * starColor;
}

// Add constellation-like star clusters
vec3 GetStarClusters(vec2 starCoord, float VdotU, float VdotS) {
    if (VdotU < 0.0) return vec3(0.0);
    
    starCoord *= 0.12; // Reduced from 0.15 for more clusters
    float clusterFactor = 1024.0; // Increased from 512.0 for more clusters
    starCoord = floor(starCoord * clusterFactor) / clusterFactor;
    
    float cluster = GetStarNoise(starCoord.xy);
    cluster *= GetStarNoise(starCoord.xy + 0.3);
    cluster *= GetStarNoise(starCoord.xy + 0.7);
    
    cluster = max0(cluster - 0.75); // Reduced threshold for more visible clusters
    cluster *= cluster * 2.5; // Increased intensity
    
    // Añadir bloom selectivo a clusters brillantes (más intenso)
    if (cluster > 0.2) { // Solo a clusters más brillantes
        float clusterBloomFactor = (cluster - 0.2) / 0.8; // Factor de bloom gradual
        cluster += cluster * clusterBloomFactor * 0.5; // Bloom más intenso
    }
    
    // Add second layer of clusters
    vec2 clusterCoord2 = starCoord * 1.8 + vec2(0.4, 0.6);
    float cluster2 = GetStarNoise(clusterCoord2.xy);
    cluster2 *= GetStarNoise(clusterCoord2.xy + 0.25);
    cluster2 *= GetStarNoise(clusterCoord2.xy + 0.55);
    
    cluster2 = max0(cluster2 - 0.8);
    cluster2 *= cluster2 * 2.0;
    
    cluster *= min1(VdotU * 2.0) * max0(1.0 - pow(abs(VdotS) * 1.002, 80.0));
    cluster2 *= min1(VdotU * 1.8) * max0(1.0 - pow(abs(VdotS) * 1.002, 70.0));
    
    cluster *= invRainFactor * pow2(pow2(invNoonFactor2)) * (1.0 - 0.6 * sunVisibility);
    cluster2 *= invRainFactor * pow2(pow2(invNoonFactor2)) * (1.0 - 0.7 * sunVisibility);
    
    return 25.0 * cluster * vec3(0.4, 0.6, 1.0) + 18.0 * cluster2 * vec3(0.4, 0.6, 1.0);
}