#ifndef INCLUDE_SKY_COLORS
    #define INCLUDE_SKY_COLORS

    #ifdef OVERWORLD
        vec3 skyColorSqrt = sqrt(skyColor);
        // Doing these things because vanilla skyColor gets to 0 during a thunderstorm
        float invRainStrength2 = (1.0 - rainStrength) * (1.0 - rainStrength);
        vec3 skyColorM = mix(max(skyColorSqrt, vec3(0.63, 0.67, 0.73)), skyColorSqrt, invRainStrength2);
        vec3 skyColorM2 = mix(max(skyColor, sunFactor * vec3(0.265, 0.295, 0.35)), skyColor, invRainStrength2);

        #ifdef SPECIAL_BIOME_WEATHER
            vec3 nmscSnowM = inSnowy * vec3(-0.3, 0.05, 0.2);
            vec3 nmscDryM = inDry * vec3(-0.3);
            vec3 ndscSnowM = inSnowy * vec3(-0.25, -0.01, 0.25);
            vec3 ndscDryM = inDry * vec3(-0.05, -0.09, -0.1);
        #else
            vec3 nmscSnowM = vec3(0.0), nmscDryM = vec3(0.0), ndscSnowM = vec3(0.0), ndscDryM = vec3(0.0);
        #endif
        #if RAIN_STYLE == 2
            vec3 nmscRainMP = vec3(-0.25, -0.25, -0.25);
            vec3 ndscRainMP = vec3(-0.125, -0.005, -0.125);
            #ifdef SPECIAL_BIOME_WEATHER
                vec3 nmscRainM = inRainy * ndscRainMP;
                vec3 ndscRainM = inRainy * ndscRainMP;
            #else
                vec3 nmscRainM = ndscRainMP;
                vec3 ndscRainM = ndscRainMP;
            #endif
        #else
            vec3 nmscRainM = vec3(0.0), ndscRainM = vec3(0.0);
        #endif
        // Modified rain weather colors to create dark gray sky
        vec3 nmscWeatherM = vec3(-0.6, -0.6, -0.6) + vec3(0.0, 0.06, 0.12) * noonFactor;
        vec3 ndscWeatherM = vec3(-0.65, -0.65, -0.65) + vec3(0.0, 0.02, 0.08) * noonFactor;

        vec3 noonUpSkyColor     = vec3(0.0, 0.5, 2.0);
        vec3 noonMiddleSkyColor = vec3(1.2, 1.2, 1.2);
        vec3 noonDownSkyColor   = vec3(1.2, 1.2, 1.2);

        vec3 sunsetUpSkyColor     = vec3(0.4, 0.5, 0.9) + vec3(0.1, 0.05, 0.2) * rainFactor2; // Blue with Purple tint
        vec3 sunsetMiddleSkyColor = vec3(1.0, 0.3, 0.5) + vec3(0.2, 0.1, 0.15) * rainFactor2; // Pink/Coral
        vec3 sunsetDownSkyColorP  = vec3(1.8, 0.8, 0.2) - vec3(0.4, 0.2, 0.1) * rainFactor; // Orange/Yellow
        vec3 sunsetDownSkyColor   = sunsetDownSkyColorP * 0.8 + 0.2 * sunsetMiddleSkyColor;

        vec3 dayUpSkyColor     = mix(noonUpSkyColor, sunsetUpSkyColor, invNoonFactor2);
        vec3 dayMiddleSkyColor = mix(noonMiddleSkyColor, sunsetMiddleSkyColor, invNoonFactor2);
        vec3 dayDownSkyColor   = mix(noonDownSkyColor, sunsetDownSkyColor, invNoonFactor2);

        vec3 nightColFactor      = vec3(0.0,0.0,0.0) * (1.0 - 0.5 * rainFactor) + skyColor;
        vec3 nightUpSkyColor     = pow(nightColFactor, vec3(0.90)) * 0.4;
        vec3 nightMiddleSkyColor = vec3(0.0, 0.5, 0.9); // Royal blue horizon to match stars
        vec3 nightDownSkyColor   = vec3(0.0, 0.5, 0.9); // Royal blue horizon to match stars
    #endif


#endif //INCLUDE_SKY_COLORS