
///// FRAGMENT SHADER //////////////////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

const bool 		gcolorMipmapEnabled 	= true; //gcolor texture mipmapping
const bool 		gdepthMipmapEnabled 	= true; //gcolor texture mipmapping

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;
varying vec3 fcolor;

varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D gaux3;
uniform sampler2D gdepthtex;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2D gdepth;
uniform sampler2D noisetex;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform vec3 skyColor;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;

uniform int isEyeInWater;
uniform int worldTime;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
uniform ivec2 eyeBrightnessSmooth;
uniform ivec2 eyeBrightness;

//Calculate Time of Day

#include "/lib/timecalculation.glsl"

float transition_fading = 1.0-(clamp((timefract-12000.0)/300.0,0.0,1.0)-clamp((timefract-13000.0)/300.0,0.0,1.0) + clamp((timefract-22800.0)/200.0,0.0,1.0)-clamp((timefract-23400.0)/200.0,0.0,1.0));

vec2 wind[4] = vec2[4](vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5))+vec2(0.5),
					   vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5)),
					   vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5)),
					   vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5)));
				
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

float matflag = texture2D(gaux1,texcoord.xy).g;

vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

float sky_lightmap = texture2D(gaux1,texcoord.xy).r;
float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,upVec),0.0));

vec3 specular = pow(texture2D(gaux3,texcoord.xy).rgb,vec3(2.2));
float specmap = (specular.r+specular.g*(iswet));
	
vec4 color = texture2DLod(composite,texcoord.xy,0);


vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}


vec3 getSkyColor(vec3 fposition) {

vec3 skyFogColorSunrise = vec3(30,20,10);
vec3 skyFogColorNoon = vec3(20,20,20);
vec3 skyFogColorSunset = vec3(30,20,10);
vec3 skyFogColorNight = vec3(10,10,10);

vec3 skyFogColor = vec3((skyFogColorSunrise*TimeSunrise)+(skyFogColorNoon*TimeNoon)+(skyFogColorSunset*TimeSunset)+(skyFogColorNight*TimeMidnight));

#ifdef DYNAMIC_SKY_COLOR
vec3 skyColorSunrise = vec3(SR*2.5,SG,SB);
vec3 skyColorNoon = vec3(SR,SG,SB);
vec3 skyColorSunset = vec3(SR*1.7,SG,SB);
vec3 skyColorNight = vec3(SR,SG,SB)/3.0;
vec3 sky_color = vec3((skyColorSunrise*TimeSunrise)+(skyColorNoon*TimeNoon)+(skyColorSunset*TimeSunset)+(skyColorNight*TimeMidnight));
#endif
#ifndef DYNAMIC_SKY_COLOR
vec3 sky_color = vec3(SR,SG,SB);
#endif
vec3 nsunlight = normalize(pow(sunlight,vec3(2.2))*skyFogColor);
vec3 sVector = normalize(fposition);

sky_color = normalize(mix(sky_color,vec3(0.15,0.2,0.3)*length(ambient_color),rainStrength)); 						//normalize colors in order to don't change luminance

float Lz = 1.0;
float cosT = dot(sVector,upVec); 
float absCosT = max(cosT,0.0);
float cosS = dot(sunVec,upVec);
float S = acos(cosS);				
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);	

float stre = -1;
float a = (TimeNoon*stre*1.2)+(TimeSunrise*stre/2)+(TimeSunset*stre/2)+(TimeMidnight*stre/2);
//float a = stre;

float b = -0.24;
float c = 4.0;
float d = -0.7;
float e = 0.45;

//sun sky color
float L =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*Y)+e*cosY*cosY); 
L = pow(L,1.0-rainStrength*0.8)*(1.0-rainStrength*0.83); //modulate intensity when raining

vec3 skyColorSun = mix(sky_color, nsunlight,1-exp(-0.005*pow(L,4.)*(1-rainStrength*0.5)))*L*0.5*vec3(0.8,0.9,1.); 	//affect color based on luminance (0% physically accurate)
skyColorSun *= sunVisibility;

//moon sky color
float McosS = MdotU;
float MS = acos(McosS);
float McosY = dot(moonVec,sVector);
float MY = acos(McosY);

float L2 =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*MY)+e*McosY*McosY)+0.5;
L2 = pow(L2,1.0-rainStrength*0.8)*(1.0-rainStrength*0.15); //modulate intensity when raining

vec3 skyColormoon = mix(moonlight,normalize(vec3(0.25,0.3,0.4))*length(moonlight),rainStrength*0.8)*L2/3.0 ; //affect color based on luminance (0% physically accurate)
skyColormoon *= moonVisibility;
sky_color = skyColormoon+skyColorSun;

return sky_color/1.01;
}

#ifdef DRAWSUN
vec3 drawSun(vec3 fposition,vec3 color,int land) {
vec3 sVector = normalize(fposition);

float angle = (1-max(dot(sVector,sunVec),0.0))*700.0;
float sun = exp(-angle*angle);
sun *= land*(1-rainStrength*0.9925)*sunVisibility;
vec3 sunlight = mix(sunlight,vec3(0.25,0.3,0.4)*length(ambient_color),rainStrength*0.8);

return mix(color,sunlight*2.0,sun);

}
#endif

vec3 drawMoon(vec3 fposition,vec3 color,int land) {
vec3 sVector = normalize(fposition);

float angle = (1-max(dot(sVector,moonVec),0.0))*700.0;
float moon = exp(-angle*angle);
moon *= land*(1-rainStrength)*clamp(moonVisibility+transition_fading*(1-rainStrength)/2,0,1);
moon = clamp(moon*moon*moon*moon,0,1)+moon/10;
vec3 moonlight = vec3(0.3,0.4,0.5)*(2-transition_fading)/2;
return mix(color,moonlight*10.,moon);

}

#ifdef Stars
#include "/lib/effect/visual/stars.glsl"
#endif

vec3 skyGradient (vec3 fposition, vec3 color, vec3 fogclr) {
	return (fogclr*3.+color)/5.0;		
}

float getAirDensity (float h) {
return (max((h),60.0)-40.0)/2;
}

#ifdef FOG
#include "/lib/effect/atmospherics/netherfog.glsl"
#endif

#ifdef VOLUMETRIC_LIGHT

#endif

float subSurfaceScattering(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos)),0.0),N)*(N+1)/6.28;

}
float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos))*0.5+0.5,0.0),N)*(N+1)/6.28;

}

float pixeldepth = texture2D(gdepthtex,texcoord.xy).x;

vec3 simplifiedCloud(vec3 fposition,vec3 color) {

vec3 sVector = normalize(fposition);
float cosT = max(dot(normalize(sVector),upVec),0.0);
float McosY = MdotU;
float cosY = SdotU;
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);

vec4 totalcloud = vec4(.0);

vec3 intersection = wVector*((-400.0)/(wVector.y));
vec3 iSpos = (gbufferModelView*vec4(intersection,1.0)).rgb;
float cosT2 = pow(0.89,distance(vec2(0.0),intersection.xz)/100);
	
for (int i = 0;i<7;i++) {
	intersection = wVector*((-+500.0-i*3.*(1+cosT2*cosT2*3.5)+400*sqrt(cosT2))/(wVector.y)); 			//curved cloud plane
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord1 = (intersection.xz+cameraPosition.xz)/650.0/380.+wind[0]*0.07;
	vec2 coord = fract(coord1/2.0);
	
	float noise = texture2D(noisetex,coord	*	0.1125	+ 	vec2(frameTimeCounter / CLOUD_SPEED*0.1125)).x;
	noise += texture2D(noisetex, coord * 1 * 0.55).x;
	noise += texture2D(noisetex, coord * 0.5 * 0.45).x * -2.0;
	noise += texture2D(noisetex, coord * 0.25 * 0.35).x * 2.0;
	noise += texture2D(noisetex, coord * 0.125 * 0.25).x * 5.0;
	noise += texture2D(noisetex, coord * 0.0625 * 0.15).x * 9.0;
	noise += texture2D(noisetex, coord * 0.03125 * 0.05).x * 10.0;
	noise += texture2D(noisetex, coord * 0.015625 * 0.05).x * -12.0;
	noise /= 1.4472;
	
	float cl = max(noise-0.6  +rainStrength*0.4,0.0)*(1-rainStrength*0.4);
	float density = max(1-cl*2.5,0.)*max(1-cl*2.5,0.)*(i/7.)*(i/7.);
	  
	vec3 c =(ambient_color + mix(sunlight,length(sunlight)*vec3(0.25,0.32,0.4),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*vec3(0.25,0.32,0.4),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fposition,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fposition,0.1)*pow(density,2.))*mix(sunlight,length(sunlight)*vec3(0.25,0.32,0.4),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fposition,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fposition,0.1)*pow(density,2.))*mix(moonlight,length(moonlight)*vec3(0.25,0.32,0.4),rainStrength)*moonVisibility;
	#ifdef CLOUDS
        #ifdef CHOCAPIC_CLOUDS
	cl = max(cl-(abs(i-3.0)/3.)*0.15,0.)*0.146;
	#else
	cl = max(cl-(abs(i-3.0)/3.)*0.15,0.)*0;
	#endif
        #endif
	
	totalcloud += vec4(c.rgb*exp(-totalcloud.a),cl);
	totalcloud.a = min(totalcloud.a,1.0);
	
	if (totalcloud.a > 0.999) break;
}

return mix(color.rgb,totalcloud.rgb*(1 - rainStrength*0.87)*6.,totalcloud.a*pow(cosT2,1.2));

}

vec4 raytrace(vec3 fragpos, vec3 normal,vec3 fogclr,vec3 sky_int) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
	
	//far black dots fix
	vec4 wrv = (gbufferModelViewInverse*vec4(rvector,1.0));
	wrv.y *= sign(dot(upVec,rvector));
	rvector = normalize((gbufferModelView*wrv).rgb);
	
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
	
    for(int i=0;i<40;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(fragpos.z-spos.z);
		if(err < pow(length(vector)*1.0,1.15)){
                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2DLod(composite, pos.st,0);
					float land = texture2D(gaux1, pos.st).g;
					land = float(land < 0.03);
					
					spos.z = mix(spos.z,2000.0*(0.25+sunVisibility*0.75),land);
					if (land > 0.0) color.rgb = simplifiedCloud(sky_int,skyGradient(sky_int,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr));
					#ifdef FOG
					color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE/5.0,fogclr);
					#endif
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=ref;
				
        
}

        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;

    }
    return color;
}	

vec4 raytraceGround(vec3 fragpos, vec3 normal,vec3 fogclr) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
	
    vec3 vector = Gstp * rvector;
	
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
		if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
        if(err < pow(length(vector)*1.8,1.15)){

                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2DLod(composite, pos.st,0);
					float land = texture2D(gaux1, pos.st).g;
					land = float(land < 0.03);
					
					spos.z = mix(spos.z,2000.0*(0.25+sunVisibility*0.75),land);
					if (land > 0.0) color.rgb = skyGradient(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
					#ifdef FOG
					color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE/5.0,fogclr);
					#endif
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=Gref;
				
        
}
        vector *= Ginc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

vec3 underwaterFog (float depth,vec3 color) {
	const float density = 10.0;
	float fog = exp(-depth/density);
        vec3 sunlightUColor = vec3(0.5,4.0,2.5)/1.5;
	vec3 Ucolor = normalize(pow(vec3(0.1,0.3,0.45),vec3(2.2)))*(sqrt(3.0));
	
	vec3 c = mix(color*Ucolor*sunlight*5.0*sunlightUColor*2.0,color,fog);
	vec3 fc = Ucolor*length(ambient_color)*0.02;
	return mix(fc,c,fog);
}

	
#ifdef CLOUDS
vec3 drawCloud(vec3 fposition,vec3 color,vec4 worldPosition) {

vec3 sVector = normalize(fposition);
float cosT = max(dot(normalize(sVector),upVec),0.0);
float McosY = MdotU;
float cosY = SdotU;
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);

vec4 totalcloud = vec4(.0);

vec3 intersection = wVector*((+400+400*sqrt(cosT))/(wVector.y));
vec3 iSpos = (gbufferModelView*vec4(intersection,1.0)).rgb;
float cosT2 = max(dot(normalize(iSpos),upVec),0.0);

for (int i = 0;i<11;i++) {
	intersection = wVector*((+5.0-i*3.*(1+cosT2*cosT2*3.5)+500*sqrt(cosT2))/(wVector.y)); 			//curved cloud plane
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord1 = (intersection.xz+cameraPosition.xz)/400.0*0.90/140.+wind[0]*0.17;
	vec2 coord = fract(coord1/2.0);
	
	float noise = texture2D(noisetex,coord	*	0.4200405	+ 	vec2(frameTimeCounter / CLOUD_SPEED*0.1125)).x;
	noise += texture2D(noisetex,	coord	*	2.5		+ 	vec2(frameTimeCounter / CLOUD_SPEED)).x/2.5;
	noise += texture2D(noisetex,	coord	*	12.0	+ 	vec2(frameTimeCounter / CLOUD_SPEED)).x/12.0;
	noise += texture2D(noisetex,	coord	*	42.0	+ 	vec2(frameTimeCounter / CLOUD_SPEED)).x/42.0;
	noise /= 1.4472;
	
	float cl = max(noise-0.6  +rainStrength*0.4,0.0)*(1-rainStrength*0.4);
	float density = max(1-cl*0.5,0.)*max(1-cl*2.5,0.)*(i/11.)*(i/11.);
	
	vec3 c =(ambient_color + mix(sunlight,length(sunlight)*vec3(0.25,0.32,0.4),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*vec3(0.25,0.32,0.4),rainStrength) * moonVisibility) * 0.003 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,2.))*mix(sunlight,length(sunlight)*vec3(0.25,0.32,0.4),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,2.))*mix(moonlight,length(moonlight)*vec3(0.25,0.32,0.4),rainStrength)*moonVisibility;
	cl = max(cl-(abs(i-5.)/5.)*0.15,0.)*0.12;
	
	totalcloud += vec4(c.rgb*exp(-totalcloud.a),cl);
	totalcloud.a = min(totalcloud.a,10.0);
	
	if (totalcloud.a > 0.999) break;
}
return mix(color.rgb,totalcloud.rgb*(1 - rainStrength*0.87)*3.7,totalcloud.a*pow(cosT2,1.2));
}
#endif
#ifdef CHOCAPIC_CLOUDS
vec3 drawChocCloud(vec3 fposition,vec3 color) {

vec3 sVector = normalize(fposition);
float cosT = max(dot(normalize(sVector),upVec),0.0);
float McosY = MdotU;
float cosY = SdotU;
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec4 totalcloud = vec4(.0);
vec3 intersection = wVector*((-400.0)/(wVector.y));
vec3 iSpos = (gbufferModelView*vec4(intersection,1.0)).rgb;
float cosT2 = pow(0.89,distance(vec2(0.0),intersection.xz)/100);

for (int i = 0;i<9;i++) {
	intersection = wVector*((-cameraPosition.y+500.0-i*3.66*(1+cosT2*cosT2*3.5)+400*sqrt(cosT2))/(wVector.y)); 			//curved cloud plane
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord1 = (intersection.xz+cameraPosition.xz)/1000.0/180.+wind[0]*0.07;
	vec2 coord = fract(coord1/2.0);

	//float noise = texture2D(noisetex,coord).x;
	//noise += texture2D(noisetex,coord*3.5).x/3.5;
	//noise += texture2D(noisetex,coord*12.25).x/12.25;
	float noise = texture2D(noisetex,coord	*	0.4200405	+ 	vec2(frameTimeCounter / CLOUD_SPEED*0.1125)).x;
	noise += texture2D(noisetex,	coord	*	2.5		+ 	vec2(frameTimeCounter / CLOUD_SPEED)).x/2.5;
	noise += texture2D(noisetex,	coord	*	12.0	+ 	vec2(frameTimeCounter / CLOUD_SPEED)).x/12.0;
	noise += texture2D(noisetex,	coord	*	42.0	+ 	vec2(frameTimeCounter / CLOUD_SPEED)).x/42.0;	
	noise /= 1.4472;

	float cl = max(noise-0.6+rainStrength*0.4,0.0)*(1-rainStrength*0.4);
	float density = max(1-cl*2.5,0.)*max(1-cl*2.5,0.)*(i/9.)*(i/9.);

	vec3 c =(ambient_color + mix(sunlight,length(sunlight)/3.0*vec3(0.25,0.32,0.4),rainStrength)*sunVisibility + mix(moonlight,length(moonlight)*vec3(0.25,0.32,0.4),rainStrength) * moonVisibility) * 0.12 *density + (24.*subSurfaceScattering(sunVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(sunVec,fragpos,0.1)*pow(density,2.))*mix(sunlight,length(sunlight)*vec3(0.25,0.32,0.4),rainStrength)*sunVisibility +  (24.*subSurfaceScattering(moonVec,fragpos,10.0)*pow(density,3.) + 10.*subSurfaceScattering2(moonVec,fragpos,0.1)*pow(density,2.))*mix(moonlight,length(moonlight)*vec3(0.25,0.32,0.4),rainStrength)*moonVisibility;
	cl = max(cl-(abs(i-4.0)/4.)*0.15,0.)*0.12;

	totalcloud += vec4(c.rgb*exp(-totalcloud.a),cl);
	totalcloud.a = min(totalcloud.a,10.0);

	if (totalcloud.a > 0.999) break;
}

return mix(color.rgb,totalcloud.rgb*(1-rainStrength*0.87)*3.4,totalcloud.a*pow(cosT2,1.2));

}
#endif

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
color.rgb = pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE; 

int land = int(matflag < 0.03);
int iswater = int(matflag > 0.04 && matflag < 0.07);
int isice = int(matflag > 0.12 && matflag < 0.16);
int hand  = int(matflag > 0.75 && matflag < 0.85);

fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
vec3 tfpos = fragpos.xyz;
if (land > 0.9) fragpos = (gbufferModelView*(gbufferModelViewInverse*vec4(fragpos,1.0)+vec4(.0,max(-70.,.0),.0,.0))).rgb;
vec3 uPos  = nvec3(gbufferProjectionInverse * nvec4(vec3(texcoord.xy,texture2D(depthtex1,texcoord.xy).x) * 2.0 - 1.0));		//underwater position
float cosT = dot(normalize(fragpos),upVec);
vec3 fogclr = getSkyColor(fragpos.xyz);
uPos.z = mix(uPos.z,2000.0*(0.25+sunVisibility*0.75),land);

float normalDotEye = clamp((dot(normal, normalize(fragpos))),-1.0,0.0);
float fresnel = pow(1.0 + normalDotEye, mix(4.0+rainStrength,5.,iswater));
fresnel = mix(1.,fresnel,0.95)*0.5;
	

	vec3 lc = mix(vec3(0.0),sunlight,sunVisibility);
	vec4 reflection = vec4(0.0);
	vec3 npos = normalize(fragpos);
	vec3 reflectedVector = reflect(normalize(fragpos), normalize(normal));
	float RdotU = (dot(reflectedVector,upVec)+1.)/2.;
	vec3 skyc = mix(getSkyColor(reflectedVector),vec3(0.002,0.005,0.002)*ambient_color*15.0,1-RdotU);
	//vec3 sky_color = calcFog(reflectedVector,drawCloud(reflectedVector,vec3(0.0)),skyc)*clamp(sky_lightmap*2.0-2/16.0,0.0,1.0);
	vec3 sky_color = simplifiedCloud(reflectedVector,skyGradient(reflectedVector,vec3(0.0),skyc)*clamp(sky_lightmap*2.0-2/16.0,0.0,1.0));

#ifdef WATER_REFLECTIONS
if (iswater > 0.9 && isEyeInWater == 0) {

	
	reflection = raytrace(fragpos, normal,skyc,reflectedVector);
	reflection.rgb = mix(sky_color, reflection.rgb, reflection.a)+(color.a)*lc*(1.0-rainStrength)*(5.+SdotU*45.);			
	reflection.a = min(reflection.a,1.0);
	reflection.rgb = reflection.rgb*REFLECTION_STRENGTH;
	color.rgb = fresnel*reflection.rgb + (1-fresnel)*color.rgb;
	
}
#endif

#ifdef RAIN_REFLECTIONS
if (land < 0.1 && iswet > 0.5) {

	reflection = raytrace(fragpos, normal,skyc,reflectedVector);
	reflection.rgb = mix(sky_color, reflection.rgb, reflection.a)+(color.a)*lc*(1.0-rainStrength)*(5.+SdotU*5.);			
	//reflection.a = min(reflection.a,1.0);
	reflection.a = min(reflection.a + 1.0*sky_lightmap,0.01);
	reflection.rgb = reflection.rgb*REFLECTION_STRENGTH*1.1;
	color.rgb = fresnel*reflection.rgb + (1-fresnel)*color.rgb;
	
}
#endif

else if (land < 0.9 && hand < 0.1 && isEyeInWater == 0) {

	if (specmap*fresnel > 0.005) reflection = raytraceGround(fragpos, normal, sky_color);
	
	reflection.rgb = mix(sky_color, reflection.rgb, reflection.a)+(color.a)*lc*(1.0-rainStrength)*(5.+SdotU*5.);		
	reflection.rgb = mix(reflection.rgb,reflection.rgb*normalize(color.rgb),0.0);
	reflection.rgb = reflection.rgb*5.0;
	reflection.a = min(reflection.a + 1.0*sky_lightmap,0.01);
	color.rgb = specmap*fresnel*reflection.rgb + (1-fresnel*specmap)*color.rgb;;


	}
	

if (hand < 0.1) {
	if (land < 0.9) {
	#ifdef FOG
	if ((isEyeInWater == 1 && iswater > 0.9)|| (isEyeInWater == 0 && iswater < 0.9)) color.rgb = calcFog(uPos.xyz,color.rgb,(fogclr));
	else color.rgb = calcFog(fragpos.xyz,color.rgb,(fogclr));
	#endif
	}
	else  {
	
	color.rgb = skyGradient(uPos.xyz,color.rgb,fogclr)*1.5;
	#ifdef DRAWSUN
	color.rgb = drawSun(tfpos,color.rgb,land);
	#endif
	#ifdef DRAWMOON
	color.rgb = drawMoon(tfpos,color.rgb,land);
	#endif

	#ifdef CLOUDS
	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	vec4 worldposition = gbufferModelViewInverse * fragposition;
	if (cosT > 0.) color.rgb = drawCloud(tfpos.xyz,color.rgb,worldposition);
	#endif
	#ifdef CHOCAPIC_CLOUDS
	if (cosT > 0.) color.rgb = drawChocCloud(tfpos.xyz,color.rgb);
	#endif
	}
}
if (isEyeInWater == 1) color.rgb = underwaterFog(length(fragpos),color.rgb);

#ifdef Stars
	if (land > 0.9 && moonVisibility > 0.1) color.rgb = drawStar(fragpos.xyz,color.rgb);
#endif

vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
tpos = vec4(tpos.xyz/tpos.w,1.0);
vec2 pos1 = tpos.xy/tpos.z;
vec2 lightPos = pos1*0.5+0.5;
float gr = 0.0;

#ifdef GODRAYS
float truepos = sunPosition.z/abs(sunPosition.z);		//1 -> sun / -1 -> moon
vec3 rainc = mix(vec3(1.),fogclr*1.5,rainStrength);

vec3 rayColor = vec3((TimeSunrise*vec3(40.25,11.25,11.25))+(TimeNoon*vec3(11,11,11))+(TimeSunset*vec3(40.25,11.25,7.5))+(TimeMidnight*vec3(150,150,151)))/20;

vec3 lightColor = mix(sunlight * sunVisibility*rainc,moonlight * moonVisibility*rainc,(truepos+1.0)/2.)*rayColor;

const int nSteps = NUM_SAMPLES;
const float blurScale = 0.002/nSteps*9.0;
const int center = (nSteps-1)/2;
vec3 blur = vec3(0.0);
float tw = 0.0;
const float sigma = 0.5;

vec2 deltaTextCoord = normalize(texcoord.st - lightPos.xy)*blurScale;
vec2 textCoord = texcoord.st - deltaTextCoord*center;
float distx = texcoord.x*aspectRatio-lightPos.x*aspectRatio;
float disty = texcoord.y-lightPos.y;
float illuminationDecay = pow(max(1.0-sqrt(distx*distx+disty*disty),0.0),4.0);

	for(int i=0; i < nSteps ; i++) {
		textCoord += deltaTextCoord;
			
		float dist = (i-float(center))/center;
		float weight = exp(-(dist*dist)/(2.0*sigma));
			
		float sampl = texture2D(gdepth, textCoord).r*weight;
		tw += weight;
		gr += sampl;
	
	
	
}
vec3 grC = mix(lightColor,fogclr,rainStrength)*exposure*(gr/tw)*illuminationDecay * (1-isEyeInWater);

color.xyz = (1-(1-color.xyz/39.0)*(1-grC.xyz/128))*39.0;

#endif
	
float visiblesun = 0.0;
float temp;
float nb = 0;
	
//calculate sun occlusion (only on one pixel) 
if (texcoord.x < 3.0*pw && texcoord.x < 3.0*ph) {
	for (int i = 0; i < 10;i++) {
		for (int j = 0; j < 10 ;j++) {
		temp = texture2D(gaux1,lightPos + vec2(pw*(i-5.0)*10.0,ph*(j-5.0)*10.0)).g;
		visiblesun +=  1.0-float(temp > 0.04) ;
		nb += 1;
		}
	}
	visiblesun /= nb;

}


	color.rgb = clamp(pow(color.rgb/MAX_COLOR_RANGE,vec3(1.0/2.2)),0.0,1.0);

/* DRAWBUFFERS:5 */
	gl_FragData[0] = vec4(color.rgb,visiblesun);
}
#endif

///// VERTEX SHADER //////////////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH
varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec4 lightS;


varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying float handItemLight;
varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform vec3 skyColor;
uniform vec3 sunPosition;
uniform vec3 upPosition;
uniform int worldTime;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform float rainStrength;
uniform float wetness;
uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

attribute vec4 mc_Entity;

////////////////////sunlight color////////////////////
////////////////////sunlight color////////////////////
////////////////////sunlight color////////////////////
#include "/lib/color/sunlight.glsl"								
							

vec3 getSkyColor(vec3 fposition) {


	float SdotU = dot(sunVec,upVec);
	float MdotU = dot(moonVec,upVec);
	float sunVisibility = pow(clamp(SdotU+0.1,0.0,0.1)/0.1,2.0);
	float moonVisibility = pow(clamp(MdotU+0.1,0.0,0.1)/0.1,2.0);
	
vec3 sky_color = vec3(0.1, 0.35, 1.);
vec3 nsunlight = normalize(pow(sunlight,vec3(2.2))*vec3(1.,0.9,0.8));
vec3 sVector = normalize(fposition);

sky_color = normalize(mix(sky_color,vec3(0.25,0.3,0.4)*length(sunlight)*0.3,rainStrength)); //normalize colors in order to don't change luminance

float Lz = 1.0;
float cosT = dot(sVector,upVec); 
float absCosT = max(cosT,0.0);
float cosS = dot(sunVec,upVec);
float S = acos(cosS);				
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);	
	
float a = -1.;
float b = -0.24;
float c = 6.0;
float d = -0.8;
float e = 0.45;



//sun sky color
float L =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*Y)+e*cosY*cosY); 
L = pow(L,1.0-rainStrength*0.8)*(1.0-rainStrength*0.8); //modulate intensity when raining

vec3 skyColorSun = mix(sky_color, nsunlight,1-exp(-0.005*pow(L,4.)*(1-rainStrength*0.8)))*L*0.5; //affect color based on luminance (0% physically accurate)
skyColorSun *= sunVisibility;


//moon sky color
float McosS = MdotU;
float MS = acos(McosS);
float McosY = dot(moonVec,sVector);
float MY = acos(McosY);



float L2 =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*MY)+e*McosY*McosY)+0.2;
L2 = pow(L2,1.0-rainStrength*0.8)*(1.0-rainStrength*0.35); //modulate intensity when raining

vec3 skyColormoon = mix(pow(normalize(moonlight),vec3(2.2))*length(moonlight),normalize(vec3(0.25,0.3,0.4))*length(moonlight),rainStrength)*L2*0.8 ; //affect color based on luminance (0% physically accurate)
skyColormoon *= moonVisibility;
sky_color = skyColormoon*2.0+skyColorSun;

return sky_color;
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	moonlight = ivec3(3,4,8)/255.0/1.8;
	
	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0;
	
	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	else {
		lightVector = normalize(-sunPosition);
	}
	
	sunVec = normalize(sunPosition);
	moonVec = normalize(-sunPosition);
	upVec = normalize(upPosition);
	
	SdotU = dot(sunVec,upVec);
	MdotU = dot(moonVec,upVec);
	sunVisibility = pow(clamp(SdotU+0.1,0.0,0.1)/0.1,2.0);
	moonVisibility = pow(clamp(MdotU+0.1,0.0,0.1)/0.1,2.0);
	
	
	float hour = mod(worldTime/1000.0+6.0,24);
	
	ivec4 temp = ToD[int(mod(floor(hour),24))];
	ivec4 temp2 = ToD[int(mod(floor(hour) + 1,24))];
	
	sunlight = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;

	sunlight.b *= 0.95;
	
	
	//sample the skybox at different places to get an accurate average color from the sky
	vec3 wUp = (gbufferModelView * vec4(vec3(0.0,1.0,0.0),0.0)).rgb;
	vec3 wS1 = (gbufferModelView * vec4(normalize(vec3(3.5,1.0,3.5)),0.0)).rgb;
	vec3 wS2 = (gbufferModelView * vec4(normalize(vec3(-3.5,1.0,3.5)),0.0)).rgb;
	vec3 wS3 = (gbufferModelView * vec4(normalize(vec3(3.5,1.0,-3.5)),0.0)).rgb;
	vec3 wS4 = (gbufferModelView * vec4(normalize(vec3(-3.5,1.0,-3.5)),0.0)).rgb;

	ambient_color = (getSkyColor(wUp) + getSkyColor(wS1) + getSkyColor(wS2) + getSkyColor(wS3) + getSkyColor(wS4))*2.;
	ambient_color = pow(normalize(ambient_color),vec3(1./2.2))*length(ambient_color);
	eyeAdapt = (2.0-min(length((getSkyColor(wUp) + getSkyColor(wS1) + getSkyColor(wS2) + getSkyColor(wS3) + getSkyColor(wS4))*2.)/sqrt(3.)*2.,eyeBrightnessSmooth.y/255.0*1.6+0.3))*(1-rainStrength*0.2);
	

	handItemLight = 0.0;
	if (heldItemId == 50) {
		// torch
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 76 || heldItemId == 94) {
		// active redstone torch / redstone repeater
		handItemLight = 0.1;
	}
	
	else if (heldItemId == 89) {
		// lightstone
		handItemLight = 0.6;
	}
	
	else if (heldItemId == 10 || heldItemId == 11 || heldItemId == 51) {
		// lava / lava / fire
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 91) {
		// jack-o-lantern
		handItemLight = 0.6;
	}
	
	
	else if (heldItemId == 327) {
		handItemLight = 0.2;
	}
	
}
#endif