/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.harvest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import snownee.jade.addon.harvest.ToolHandler;

public class SimpleToolHandler
implements ToolHandler {
    public final Set<class_2248> blocks = Sets.newIdentityHashSet();
    public final List<class_6862<class_2248>> blockTags = Lists.newArrayList();
    protected final List<class_1799> tools = Lists.newArrayList();
    private final class_2960 uid;
    private final boolean testIsCorrectTool;

    public SimpleToolHandler(class_2960 uid, boolean testIsCorrectTool, List<class_1799> tools) {
        this.uid = uid;
        this.testIsCorrectTool = testIsCorrectTool;
        if (testIsCorrectTool) {
            Preconditions.checkArgument((!tools.isEmpty() ? 1 : 0) != 0, (Object)"tools cannot be empty");
        } else {
            Preconditions.checkArgument((tools.size() == 1 ? 1 : 0) != 0, (Object)"tools must have only one element");
        }
        this.tools.addAll(tools);
    }

    public static SimpleToolHandler create(class_2960 uid, boolean testIsCorrectTool, List<class_1792> tools) {
        return new SimpleToolHandler(uid, testIsCorrectTool, Lists.transform(tools, class_1792::method_7854));
    }

    public boolean matchesBlock(class_2680 state) {
        if (this.blocks.contains(state.method_26204())) {
            return true;
        }
        return this.blockTags.stream().anyMatch(arg_0 -> ((class_2680)state).method_26164(arg_0));
    }

    @Override
    public class_1799 test(class_2680 state, class_1937 world, class_2338 pos) {
        if (this.matchesBlock(state)) {
            if (this.testIsCorrectTool) {
                if (!state.method_29291() && state.method_26214((class_1922)world, pos) == 0.0f) {
                    return class_1799.field_8037;
                }
                for (class_1799 tool : this.tools) {
                    if (!tool.method_7951(state)) continue;
                    return tool;
                }
            } else {
                return this.tools.get(0);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public List<class_1799> getTools() {
        return this.tools;
    }

    @Override
    public class_2960 getUid() {
        return this.uid;
    }

    public SimpleToolHandler addBlock(class_2248 block) {
        this.blocks.add(block);
        return this;
    }

    public SimpleToolHandler addBlockTag(class_6862<class_2248> tag) {
        this.blockTags.add(tag);
        return this;
    }
}

