/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public abstract class EnergyStorageProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        List groups;
        if (!accessor.showDetails() && config.get(Identifiers.UNIVERSAL_ENERGY_STORAGE_DETAILED)) {
            return;
        }
        if (!accessor.getServerData().method_10545("JadeEnergyStorage")) {
            return;
        }
        IClientExtensionProvider provider = Optional.ofNullable(class_2960.method_12829((String)accessor.getServerData().method_10558("JadeEnergyStorageUid"))).map(WailaClientRegistration.instance().energyStorageProviders::get).orElse(null);
        if (provider == null) {
            return;
        }
        try {
            groups = provider.getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeEnergyStorage", Function.identity()));
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider, tooltip, provider.getUid().method_12836());
            return;
        }
        if (groups.isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            if (renderGroup) {
                group.renderHeader((ITooltip)theTooltip);
            }
            for (EnergyView view : group.views) {
                Object text = view.overrideText != null ? view.overrideText : class_2561.method_43469((String)"jade.fe", (Object[])new Object[]{String.valueOf(class_124.field_1068) + view.current, view.max}).method_27692(class_124.field_1080);
                ProgressStyle progressStyle = helper.progressStyle().color(-5636096, -10092544);
                theTooltip.add(helper.progress(view.ratio, (class_2561)text, progressStyle, BoxStyle.getNestedBox(), true));
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        class_2487 tag = accessor.getServerData();
        Object target = accessor.getTarget();
        for (IServerExtensionProvider provider : WailaCommonRegistration.instance().energyStorageProviders.get(target)) {
            List groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null, provider.getUid().method_12836());
                continue;
            }
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeEnergyStorage", groups, Function.identity())) {
                tag.method_10582("JadeEnergyStorageUid", provider.getUid().toString());
            }
            return;
        }
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.UNIVERSAL_ENERGY_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        EnergyStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(class_2487 data, T accessor) {
        EnergyStorageProvider.putData(accessor);
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        if (!accessor.showDetails() && IWailaConfig.get().getPlugin().get(Identifiers.UNIVERSAL_ENERGY_STORAGE_DETAILED)) {
            return false;
        }
        for (IServerExtensionProvider<class_2487> provider : WailaCommonRegistration.instance().energyStorageProviders.get((Accessor<?>)accessor)) {
            if (!provider.shouldRequestData((Accessor<?>)accessor)) continue;
            return true;
        }
        return false;
    }

    public static class ForBlock
    extends EnergyStorageProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends EnergyStorageProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }

    public static enum Extension implements IServerExtensionProvider<class_2487>,
    IClientExtensionProvider<class_2487, EnergyView>
    {
        INSTANCE;


        @Override
        public class_2960 getUid() {
            return Identifiers.UNIVERSAL_ENERGY_STORAGE_DEFAULT;
        }

        @Override
        public List<ClientViewGroup<EnergyView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_2487>> groups) {
            return groups.stream().map($ -> {
                String unit = $.getExtraData().method_10558("Unit");
                return new ClientViewGroup<EnergyView>($.views.stream().map(tag -> EnergyView.read(tag, unit)).filter(Objects::nonNull).toList());
            }).toList();
        }

        @Override
        @Nullable
        public List<ViewGroup<class_2487>> getGroups(Accessor<?> accessor) {
            return CommonProxy.wrapEnergyStorage(accessor);
        }

        @Override
        public boolean shouldRequestData(Accessor<?> accessor) {
            return CommonProxy.hasDefaultEnergyStorage(accessor);
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }
}

