/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import net.minecraft.class_4081;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.util.ServerDataUtil;

public enum StatusEffectsProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final MapCodec<List<class_1293>> EFFECTS_CODEC;

    public static class_2561 getEffectName(class_1293 mobEffectInstance) {
        class_5250 mutableComponent = ((class_1291)mobEffectInstance.method_5579().comp_349()).method_5560().method_27661();
        if (mobEffectInstance.method_5578() >= 1 && mobEffectInstance.method_5578() <= 9) {
            mutableComponent.method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + (mobEffectInstance.method_5578() + 1))));
        }
        return mutableComponent;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Optional<List<class_1293>> result = ServerDataUtil.read(accessor.getServerData(), EFFECTS_CODEC);
        if (result.isEmpty() || result.get().isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        ITooltip box = helper.tooltip();
        for (class_1293 effect : result.get()) {
            class_2561 name = StatusEffectsProvider.getEffectName(effect);
            String duration = effect.method_48559() ? class_1074.method_4662((String)"effect.duration.infinite", (Object[])new Object[0]) : class_3544.method_15439((int)effect.method_5584(), (float)accessor.tickRate());
            class_5250 s = class_2561.method_43469((String)"jade.potion", (Object[])new Object[]{name, duration});
            IThemeHelper t = IThemeHelper.get();
            box.add((class_2561)(((class_1291)effect.method_5579().comp_349()).method_18792() == class_4081.field_18272 ? t.danger(s) : t.success(s)));
        }
        tooltip.add(helper.box(box, BoxStyle.getNestedBox()));
    }

    @Override
    public void appendServerData(class_2487 tag, EntityAccessor accessor) {
        class_1309 living = (class_1309)accessor.getEntity();
        Collection effects = living.method_6026();
        if (effects.isEmpty()) {
            return;
        }
        List<class_1293> effectList = effects.stream().filter(class_1293::method_5581).toList();
        if (effectList.isEmpty()) {
            return;
        }
        ServerDataUtil.write(accessor.getServerData(), EFFECTS_CODEC, effectList);
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.MC_POTION_EFFECTS;
    }

    static {
        EFFECTS_CODEC = class_1293.field_48821.listOf().fieldOf("mob_effects");
    }
}

