/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.util.CommonProxy;

public class RayTracing {
    public static final RayTracing INSTANCE = new RayTracing();
    public static Predicate<class_1297> ENTITY_FILTER = entity -> true;
    private final class_310 mc = class_310.method_1551();
    private class_239 target = null;

    private RayTracing() {
    }

    public static class_2680 wrapBlock(class_1922 level, class_3965 hit, class_3726 context) {
        if (hit.method_17783() != class_239.class_240.field_1332) {
            return class_2246.field_10124.method_9564();
        }
        class_2680 blockState = level.method_8320(hit.method_17777());
        class_3610 fluidState = blockState.method_26227();
        if (!fluidState.method_15769()) {
            if (blockState.method_27852(class_2246.field_10499) && WailaClientRegistration.instance().shouldHide(blockState)) {
                return fluidState.method_15759();
            }
            if (blockState.method_26172(level, hit.method_17777(), context).method_1110()) {
                return fluidState.method_15759();
            }
        }
        return blockState;
    }

    @Nullable
    public static class_3966 getEntityHitResult(class_1937 worldIn, class_1297 projectile, class_243 startVec, class_243 endVec, class_238 boundingBox, Predicate<class_1297> filter) {
        double d0 = Double.MAX_VALUE;
        class_1297 entity = null;
        for (class_1297 entity1 : worldIn.method_8333(projectile, boundingBox, filter)) {
            double d1;
            class_238 axisalignedbb = entity1.method_5829();
            if (axisalignedbb.method_995() < 0.3) {
                axisalignedbb = axisalignedbb.method_1014(0.3);
            }
            if (axisalignedbb.method_1006(startVec)) {
                entity = entity1;
                d0 = 0.0;
                break;
            }
            Optional optional = axisalignedbb.method_992(startVec, endVec);
            if (!optional.isPresent() || !((d1 = startVec.method_1025((class_243)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new class_3966(entity);
    }

    public static boolean isEmptyElement(IElement element) {
        return element == null || element == ItemStackElement.EMPTY;
    }

    public void fire() {
        class_1297 targetEntity;
        class_1657 viewPlayer;
        class_1297 viewEntity = this.mc.method_1560();
        Object object = viewPlayer = viewEntity instanceof class_1657 ? (class_1657)viewEntity : this.mc.field_1724;
        if (viewEntity == null || viewPlayer == null) {
            return;
        }
        if (this.mc.field_1765 != null && this.mc.field_1765.method_17783() == class_239.class_240.field_1331 && this.canBeTarget(targetEntity = ((class_3966)this.mc.field_1765).method_17782(), viewEntity)) {
            this.target = this.mc.field_1765;
            return;
        }
        float extendedReach = Jade.CONFIG.get().getGeneral().getExtendedReach();
        double blockReach = viewPlayer.method_55754() + (double)extendedReach;
        double entityReach = viewPlayer.method_55755() + (double)extendedReach;
        this.target = this.rayTrace(viewEntity, blockReach, entityReach, this.mc.method_1488());
    }

    public class_239 getTarget() {
        return this.target;
    }

    public class_239 rayTrace(class_1297 entity, double blockReach, double entityReach, float partialTicks) {
        class_243 eyePosition = entity.method_5836(partialTicks);
        class_243 lookVector = entity.method_5828(partialTicks);
        if (this.mc.field_1765 != null && this.mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            blockReach = entityReach = this.mc.field_1765.method_17784().method_1022(eyePosition) + 0.1;
        }
        class_243 traceEnd = eyePosition.method_1019(lookVector.method_1021(entityReach));
        class_1937 world = entity.method_37908();
        class_238 bound = new class_238(eyePosition, traceEnd);
        Predicate<class_1297> predicate = e -> this.canBeTarget((class_1297)e, entity);
        class_3966 entityResult = RayTracing.getEntityHitResult(world, entity, eyePosition, traceEnd, bound, predicate);
        if (blockReach != entityReach) {
            traceEnd = eyePosition.method_1019(lookVector.method_1021(blockReach));
        }
        class_2680 eyeBlock = world.method_8320(class_2338.method_49638((class_2374)eyePosition));
        class_3959.class_242 fluidView = class_3959.class_242.field_1348;
        if (eyeBlock.method_26227().method_15769()) {
            fluidView = Jade.CONFIG.get().getGeneral().getDisplayFluids().ctx;
        }
        class_3726 collisionContext = class_3726.method_16195((class_1297)entity);
        class_3959 context = new class_3959(eyePosition, traceEnd, class_3959.class_3960.field_17559, fluidView, collisionContext);
        class_3965 blockResult = world.method_17742(context);
        if (entityResult != null) {
            if (blockResult.method_17783() == class_239.class_240.field_1332) {
                double blockDist;
                double entityDist = entityResult.method_17784().method_1025(eyePosition);
                if (entityDist < (blockDist = blockResult.method_17784().method_1025(eyePosition))) {
                    return entityResult;
                }
            } else {
                return entityResult;
            }
        }
        if (blockResult.method_17783() == class_239.class_240.field_1332) {
            class_2680 state = RayTracing.wrapBlock((class_1922)world, blockResult, collisionContext);
            if (WailaClientRegistration.instance().shouldHide(state)) {
                return null;
            }
        }
        return blockResult;
    }

    private boolean canBeTarget(class_1297 target, class_1297 viewEntity) {
        if (target.method_31481()) {
            return false;
        }
        if (target.method_7325()) {
            return false;
        }
        if (target == viewEntity.method_5854()) {
            return false;
        }
        if (target instanceof class_1676) {
            class_1676 projectile = (class_1676)target;
            if (projectile.field_6012 <= 10 && !target.method_37908().method_54719().method_54746(target)) {
                return false;
            }
        }
        if (CommonProxy.isMultipartEntity(target) && !target.method_5863()) {
            return false;
        }
        if (viewEntity instanceof class_1657) {
            class_1657 player = (class_1657)viewEntity;
            if (target.method_5756(player)) {
                return false;
            }
            if (this.mc.field_1761.method_2923() && target.method_5864() == class_1299.field_6052) {
                return false;
            }
        } else if (target.method_5767()) {
            return false;
        }
        return !WailaClientRegistration.instance().shouldHide(target) && ENTITY_FILTER.test(target);
    }

    public IElement getIcon() {
        Accessor<?> accessor = ObjectDataCenter.get();
        if (accessor == null) {
            return null;
        }
        IElement icon = ObjectDataCenter.getIcon();
        if (RayTracing.isEmptyElement(icon)) {
            return null;
        }
        return icon;
    }
}

