/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.restrictions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.restrictions.Restriction;
import jeresources.api.util.BiomeHelper;
import net.minecraft.class_1074;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public class BiomeRestriction {
    public static final BiomeRestriction NO_RESTRICTION = new BiomeRestriction();
    public static final BiomeRestriction TAIGA = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9420);
    public static final BiomeRestriction JUNGLE = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9417);
    public static final BiomeRestriction PLAINS = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9451);
    public static final BiomeRestriction SAVANNA = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9449);
    public static final BiomeRestriction ICE_SPIKES = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9453);
    public static final BiomeRestriction THE_END = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9411);
    public static final BiomeRestriction BEACH = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9434);
    public static final BiomeRestriction FOREST = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9409);
    public static final BiomeRestriction OCEAN = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9423);
    public static final BiomeRestriction DESERT = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9424);
    public static final BiomeRestriction RIVER = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9438);
    public static final BiomeRestriction SWAMP = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9471);
    public static final BiomeRestriction MUSHROOM_FIELDS = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9462);
    public static final BiomeRestriction NETHER_WASTES = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9461);
    public static final BiomeRestriction DRIPSTONE_CAVES = new BiomeRestriction((class_5321<class_1959>)class_1972.field_28107);
    public static final BiomeRestriction BADLANDS = new BiomeRestriction((class_5321<class_1959>)class_1972.field_9415);
    private List<class_1959> biomes = new ArrayList<class_1959>();
    private Restriction.Type restrictionType;

    public BiomeRestriction() {
        this.restrictionType = Restriction.Type.NONE;
    }

    public BiomeRestriction(class_5321<class_1959> biome) {
        this(BiomeHelper.getBiome(biome));
    }

    public BiomeRestriction(class_1959 biome) {
        this(Restriction.Type.WHITELIST, biome);
    }

    public BiomeRestriction(Restriction.Type restrictionType, class_1959 biome) {
        this(restrictionType, biome, new class_1959[0]);
    }

    public BiomeRestriction(class_1959 biome, class_1959 ... moreBiomes) {
        this(Restriction.Type.WHITELIST, biome, moreBiomes);
    }

    public BiomeRestriction(Restriction.Type restrictionType, class_1959 biome, class_1959 ... moreBiomes) {
        this.restrictionType = restrictionType;
        switch (restrictionType) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes.add(biome);
                this.biomes.addAll(Arrays.asList(moreBiomes));
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.remove(biome);
                this.biomes.removeAll(Arrays.asList(moreBiomes));
            }
        }
    }

    public BiomeRestriction(class_5321<class_1959> biomeCategory, class_5321<class_1959> ... biomeCategories) {
        this(Restriction.Type.WHITELIST, biomeCategory, biomeCategories);
    }

    public BiomeRestriction(Restriction.Type restrictionType, class_5321<class_1959> biomeCategory, class_5321<class_1959> ... biomeCategories) {
        this.restrictionType = restrictionType;
        switch (restrictionType) {
            case NONE: {
                break;
            }
            case WHITELIST: {
                this.biomes = this.getBiomes(biomeCategory, biomeCategories);
                break;
            }
            default: {
                this.biomes = BiomeHelper.getAllBiomes();
                this.biomes.removeAll(this.getBiomes(biomeCategory, biomeCategories));
            }
        }
    }

    private ArrayList<class_1959> getBiomes(class_5321<class_1959> biomeCategory, class_5321<class_1959> ... biomeCategories) {
        ArrayList<Object> biomes = new ArrayList<class_1959>();
        biomes.addAll(BiomeHelper.getBiomes(biomeCategory));
        for (int i = 1; i < biomeCategories.length; ++i) {
            ArrayList<class_1959> newBiomes = new ArrayList<class_1959>();
            for (class_1959 biome : BiomeHelper.getBiomes(biomeCategories[i])) {
                if (!biomes.remove(biome)) continue;
                newBiomes.add(biome);
            }
            biomes = newBiomes;
        }
        return biomes;
    }

    public List<String> toStringList() {
        return this.biomes.stream().filter(biome -> !biome.toString().equals("")).map(biome -> "  " + class_1074.method_4662((String)("biome." + biome.toString().replace(":", ".")), (Object[])new Object[0])).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeRestriction) {
            BiomeRestriction other = (BiomeRestriction)obj;
            return other.biomes.size() == this.biomes.size() && other.biomes.containsAll(this.biomes);
        }
        return false;
    }

    public boolean isMergeAble(BiomeRestriction other) {
        return other.restrictionType == Restriction.Type.NONE || this.restrictionType != Restriction.Type.NONE && !this.biomes.isEmpty() && other.biomes.containsAll(this.biomes);
    }

    public String toString() {
        return "Biomes: " + String.valueOf((Object)this.restrictionType) + (String)(this.restrictionType != Restriction.Type.NONE ? " - " + this.biomes.size() : "");
    }

    public int hashCode() {
        return this.restrictionType.hashCode() ^ this.biomes.hashCode();
    }
}

