/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.minecraft;

import java.util.function.Supplier;
import jeresources.api.conditionals.Conditional;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.distributions.DistributionTriangular;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.api.restrictions.BiomeRestriction;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.CompatBase;
import jeresources.compatibility.minecraft.RenderHooks;
import jeresources.entry.DungeonEntry;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import jeresources.entry.WorldGenEntry;
import jeresources.util.LootTableFetcher;
import jeresources.util.LootTableHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1425;
import net.minecraft.class_1477;
import net.minecraft.class_1510;
import net.minecraft.class_1550;
import net.minecraft.class_1570;
import net.minecraft.class_1606;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2242;
import net.minecraft.class_2246;
import net.minecraft.class_2271;
import net.minecraft.class_2302;
import net.minecraft.class_2421;
import net.minecraft.class_2439;
import net.minecraft.class_2513;
import net.minecraft.class_3830;
import net.minecraft.class_52;
import net.minecraft.class_5321;

public class MinecraftCompat
extends CompatBase {
    @Override
    public void init(boolean worldGen) {
        this.registerVanillaMobs();
        this.registerDungeonLoot();
        if (worldGen) {
            this.registerOres();
        }
        this.registerVanillaPlants();
    }

    private void registerVanillaMobs() {
        LootTableFetcher lootTableFetcher = LootTableHelper.getLootTableFetcher();
        LootTableHelper.getAllMobLootTables().entrySet().stream().map(entry -> MobEntry.create((Supplier<class_1309>)((Supplier)entry.getValue()), lootTableFetcher.getLootTable((class_5321<class_52>)((class_5321)entry.getKey())))).forEach(x$0 -> this.registerMob((MobEntry)x$0));
        this.registerMobRenderHook(class_1420.class, RenderHooks.BAT);
        this.registerMobRenderHook(class_1510.class, RenderHooks.ENDER_DRAGON);
        this.registerMobRenderHook(class_1550.class, RenderHooks.ELDER_GUARDIAN);
        this.registerMobRenderHook(class_1477.class, RenderHooks.SQUID);
        this.registerMobRenderHook(class_1570.class, RenderHooks.GIANT);
        this.registerMobRenderHook(class_1606.class, RenderHooks.SHULKER);
        this.registerMobRenderHook(class_1425.class, RenderHooks.GROUP_FISH);
    }

    private void registerDungeonLoot() {
        LootTableFetcher lootTableFetcher = LootTableHelper.getLootTableFetcher();
        LootTableHelper.getAllChestLootTablesResourceKeys().stream().map(resourceKey -> new DungeonEntry(resourceKey.method_29177().method_12832(), lootTableFetcher.getLootTable((class_5321<class_52>)resourceKey))).forEach(x$0 -> this.registerDungeonEntry((DungeonEntry)x$0));
    }

    private void registerOres() {
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10418), new class_1799((class_1935)class_2246.field_29219), (DistributionBase)new DistributionSquare(30, 16, 136, 256), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_8713), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10418), new class_1799((class_1935)class_2246.field_29219), (DistributionBase)new DistributionTriangular(20, 16, 96, 96), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_8713), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_27120), new class_1799((class_1935)class_2246.field_29221), (DistributionBase)new DistributionTriangular(16, 8, 46, 66), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_33401), 2, 20, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_27120), new class_1799((class_1935)class_2246.field_29221), (DistributionBase)new DistributionTriangular(16, 16, 46, 66), new Restriction(BiomeRestriction.DRIPSTONE_CAVES, DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_33401), 2, 20, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10090), new class_1799((class_1935)class_2246.field_29028), (DistributionBase)new DistributionSquare(4, 8, -64, 64), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_8759), 4, 36, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10090), new class_1799((class_1935)class_2246.field_29028), (DistributionBase)new DistributionTriangular(2, 8, 0, 32), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_8759), 4, 36, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10212), new class_1799((class_1935)class_2246.field_29027), (DistributionBase)new DistributionTriangular(90, 8, 232, 152), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_33400), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10212), new class_1799((class_1935)class_2246.field_29027), (DistributionBase)new DistributionTriangular(10, 8, 16, 40), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_33400), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10212), new class_1799((class_1935)class_2246.field_29027), (DistributionBase)new DistributionSquare(10, 8, -64, 72), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_33400), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10571), new class_1799((class_1935)class_2246.field_29026), (DistributionBase)new DistributionSquare(1, 8, -64, -48), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_33402), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10571), new class_1799((class_1935)class_2246.field_29026), (DistributionBase)new DistributionTriangular(4, 8, -16, 48), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_33402), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10571), new class_1799((class_1935)class_2246.field_29026), (DistributionBase)new DistributionTriangular(50, 8, -16, 48), new Restriction(BiomeRestriction.BADLANDS, DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_33402), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10080), new class_1799((class_1935)class_2246.field_29030), (DistributionBase)new DistributionTriangular(8, 8, -64, 32), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_8725), 1, 32, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10080), new class_1799((class_1935)class_2246.field_29030), (DistributionBase)new DistributionSquare(4, 8, -64, 15), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_8725), 1, 32, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10442), new class_1799((class_1935)class_2246.field_29029), (DistributionBase)new DistributionTriangular(6, 6, -64, 64), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_8477), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10013), new class_1799((class_1935)class_2246.field_29220), (DistributionBase)new DistributionTriangular(100, 4, 202, 218), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new class_1799((class_1935)class_1802.field_8687), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_10213), (DistributionBase)new DistributionSquare(16, 16, 10, 128), new Restriction(DimensionRestriction.NETHER), true, new LootDrop(new class_1799((class_1935)class_1802.field_8155), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_23077), (DistributionBase)new DistributionSquare(8, 16, 15, 117), new Restriction(DimensionRestriction.NETHER), true, new LootDrop(new class_1799((class_1935)class_1802.field_8397), 2, 24, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new class_1799((class_1935)class_2246.field_22109), (DistributionBase)new DistributionTriangular(14, 9, 1.6E-4f), new Restriction(DimensionRestriction.NETHER), new LootDrop[0]));
    }

    private void registerVanillaPlants() {
        PlantDrop potato = new PlantDrop(new class_1799((class_1935)class_1802.field_8567), 1, 4);
        PlantDrop poisonous = new PlantDrop(new class_1799((class_1935)class_1802.field_8635), 0.02f);
        this.registerPlant(new PlantEntry((class_2439)class_2246.field_10247, potato, poisonous));
        PlantDrop carrot = new PlantDrop(new class_1799((class_1935)class_1802.field_8179), 1, 4);
        this.registerPlant(new PlantEntry((class_2271)class_2246.field_10609, carrot));
        PlantDrop wheat = new PlantDrop(new class_1799((class_1935)class_1802.field_8861), 1, 1);
        PlantDrop seeds = new PlantDrop(new class_1799((class_1935)class_1802.field_8317), 0, 3);
        this.registerPlant(new PlantEntry((class_2302)class_2246.field_10293, wheat, seeds));
        PlantDrop melonSlice = new PlantDrop(new class_1799((class_1935)class_1802.field_8497), 3, 7);
        this.registerPlant(new PlantEntry((class_2513)class_2246.field_46287, melonSlice));
        PlantDrop pumpkin = new PlantDrop(new class_1799((class_1935)class_2246.field_46282), 1, 1);
        this.registerPlant(new PlantEntry((class_2513)class_2246.field_46286, pumpkin));
        PlantDrop beetroot = new PlantDrop(new class_1799((class_1935)class_1802.field_8186), 1, 1);
        PlantDrop beetrootSeeds = new PlantDrop(new class_1799((class_1935)class_1802.field_8309), 0, 3);
        this.registerPlant(new PlantEntry((class_2242)class_2246.field_10341, beetroot, beetrootSeeds));
        PlantDrop netherWartDrop = new PlantDrop(new class_1799((class_1935)class_1802.field_8790), 2, 4);
        PlantEntry netherWartEntry = new PlantEntry((class_2421)class_2246.field_9974, netherWartDrop);
        netherWartEntry.setSoil(class_2246.field_10114.method_9564());
        this.registerPlant(netherWartEntry);
        PlantDrop sweetBerriesDrop = new PlantDrop(new class_1799((class_1935)class_1802.field_16998), 1, 3);
        PlantEntry sweetBerriesEntry = new PlantEntry((class_3830)class_2246.field_16999, sweetBerriesDrop);
        sweetBerriesEntry.setSoil(class_2246.field_10219.method_9564());
        this.registerPlant(sweetBerriesEntry);
    }
}

