/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jeresources.api.drop.LootDrop;
import jeresources.api.util.ItemHelper;
import jeresources.api.util.LootFunctionHelper;
import jeresources.platform.ILootTableHelper;
import jeresources.platform.Services;
import jeresources.registry.DungeonRegistry;
import jeresources.util.LootTableFetcher;
import jeresources.util.LootTableHelper;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_67;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import net.minecraft.class_85;

public class DungeonEntry {
    private Set<LootDrop> drops = new TreeSet<LootDrop>();
    private String name;
    private int maxStacks;
    private int minStacks;

    public DungeonEntry(String name, class_52 lootTable) {
        this.name = name;
        float[] tmpMinStacks = new float[]{0.0f};
        float[] tmpMaxStacks = new float[]{0.0f};
        LootTableFetcher lootTables = LootTableHelper.getLootTableFetcher();
        this.handleTable(lootTable, lootTables, tmpMinStacks, tmpMaxStacks);
        this.minStacks = class_3532.method_15375((float)tmpMinStacks[0]);
        this.maxStacks = class_3532.method_15375((float)tmpMaxStacks[0]);
    }

    private void handleTable(class_52 lootTable, LootTableFetcher lootTables, float[] tmpMinStacks, float[] tmpMaxStacks) {
        ILootTableHelper lootTableHelper = Services.PLATFORM.getLootTableHelper();
        LootTableHelper.getPools(lootTable).forEach(pool -> {
            tmpMinStacks[0] = tmpMinStacks[0] + (float)LootFunctionHelper.getMin(lootTableHelper.getRolls((class_55)pool));
            tmpMaxStacks[0] = tmpMaxStacks[0] + (float)(LootFunctionHelper.getMax(lootTableHelper.getRolls((class_55)pool)) + LootFunctionHelper.getMax(lootTableHelper.getBonusRolls((class_55)pool)));
            float totalWeight = LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof class_85).map(entry -> (class_85)entry).mapToInt(entry -> entry.field_995).sum();
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof class_77).map(entry -> (class_77)entry).map(entry -> new LootDrop((class_1792)entry.field_987.comp_349(), (float)entry.field_995 / totalWeight, entry.field_996)).forEach(this.drops::add);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof class_67).map(entry -> (class_67)entry).map(entry -> lootTables.getLootTable((class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)entry.field_980))).forEach(table -> this.handleTable((class_52)table, lootTables, tmpMinStacks, tmpMaxStacks));
        });
    }

    public boolean containsItem(class_1799 itemStack) {
        return this.drops.stream().anyMatch(drop -> drop.item.method_31574(itemStack.method_7909()));
    }

    public String getName() {
        String name = DungeonRegistry.categoryToLocalKeyMap.get(this.name);
        return name == null ? this.name : name;
    }

    public List<class_1799> getItemStacks(IFocus<class_1799> focus) {
        return this.drops.stream().map(drop -> drop.item).filter(stack -> focus == null || class_1799.method_7984((class_1799)ItemHelper.copyStackWithSize(stack, ((class_1799)focus.getTypedValue().getIngredient()).method_7947()), (class_1799)((class_1799)focus.getTypedValue().getIngredient()))).collect(Collectors.toList());
    }

    public List<class_1799> getItemStacks(Stream<IFocus<class_1799>> focuses) {
        return this.getItemStacks((IFocus<class_1799>)((IFocus)focuses.findFirst().orElse(null)));
    }

    public int getMaxStacks() {
        return this.maxStacks;
    }

    public int getMinStacks() {
        return this.minStacks;
    }

    public LootDrop getChestDrop(class_1799 ingredient) {
        return this.drops.stream().filter(drop -> class_1799.method_7984((class_1799)drop.item, (class_1799)ingredient)).findFirst().orElse(null);
    }
}

