/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.dungeon;

import java.util.List;
import java.util.Objects;
import jeresources.entry.DungeonEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class DungeonWrapper
implements IRecipeCategoryExtension<DungeonWrapper>,
IRecipeSlotTooltipCallback {
    public final DungeonEntry chest;
    private boolean done;
    private int lidStart;

    public DungeonWrapper(DungeonEntry chest) {
        this.chest = chest;
    }

    public int amountOfItems(IFocus<class_1799> focus) {
        return this.chest.getItemStacks(focus).size();
    }

    public List<class_1799> getItems(IFocus<class_1799> focus, int slot, int slots) {
        List<class_1799> list = this.chest.getItemStacks(focus).subList(slot, slot + 1);
        for (int n = 1; n < this.amountOfItems(focus) / slots + 1; ++n) {
            list.add(this.amountOfItems(focus) <= slot + slots * n ? null : this.chest.getItemStacks(focus).get(slot + slots * n));
        }
        list.removeIf(Objects::isNull);
        return list;
    }

    public void drawInfo(DungeonWrapper entry, int recipeWidth, int recipeHeight, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
        RenderHelper.renderChest(guiGraphics, 15.0f, 20.0f, -40.0f, 20.0f, this.getLidAngle());
        Font.normal.print(guiGraphics, TranslationHelper.translateAndFormat(this.chest.getName(), new Object[0]), 60, 7);
        Font.small.print(guiGraphics, DungeonRegistry.getInstance().getNumStacks(this.chest), 60, 20);
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, List<class_2561> tooltip) {
        tooltip.add(this.chest.getChestDrop((class_1799)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient()).toStringTextComponent());
    }

    private float getLidAngle() {
        float angle = ((int)System.currentTimeMillis() / 100 - this.lidStart) % 80;
        if (angle > 50.0f || this.done) {
            this.done = true;
            angle = 50.0f;
        }
        return angle;
    }

    public void resetLid() {
        this.lidStart = (int)System.currentTimeMillis() / 100;
    }
}

