/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.mob;

import java.util.Collections;
import java.util.List;
import jeresources.api.drop.LootDrop;
import jeresources.config.Settings;
import jeresources.entry.MobEntry;
import jeresources.util.CollectionHelper;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.class_1309;
import net.minecraft.class_1427;
import net.minecraft.class_1429;
import net.minecraft.class_1477;
import net.minecraft.class_1481;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1543;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1560;
import net.minecraft.class_1571;
import net.minecraft.class_1576;
import net.minecraft.class_1640;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3989;
import net.minecraft.class_5418;
import org.jetbrains.annotations.NotNull;

public class MobWrapper
implements IRecipeCategoryExtension<MobWrapper>,
IRecipeSlotTooltipCallback {
    private final MobEntry mob;

    public MobWrapper(MobEntry mob) {
        this.mob = mob;
    }

    public List<LootDrop> getDrops() {
        return this.mob.getDrops();
    }

    public void drawInfo(MobWrapper recipe, int recipeWidth, int recipeHeight, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
        String entityString;
        class_1309 livingEntity = this.mob.getEntity();
        float scale = this.getScale(livingEntity);
        int offsetY = this.getOffsetY(livingEntity);
        RenderHelper.renderEntity(guiGraphics, 37, 105 - offsetY, scale, 38.0 - mouseX, (double)(70 - offsetY) - mouseY, livingEntity);
        Object mobName = this.mob.getMobName();
        if (Settings.showDevData && (entityString = livingEntity.method_5845()) != null) {
            mobName = (String)mobName + " (" + entityString + ")";
        }
        Font.normal.print(guiGraphics, (String)mobName, 7, 2);
        String biomesLine = this.mob.hasMultipleBiomes() ? TranslationHelper.translateAndFormat("jer.mob.biome", new Object[0]) : this.mob.getTranslatedBiomes().findFirst().map(firstBiome -> TranslationHelper.translateAndFormat("jer.mob.spawn", new Object[0]) + " " + firstBiome).orElse("");
        Font.normal.print(guiGraphics, biomesLine, 7, 12);
        Font.normal.print(guiGraphics, this.mob.getLightLevel().toString(), 7, 22);
        Font.normal.print(guiGraphics, TranslationHelper.translateAndFormat("jer.mob.exp", new Object[0]) + ": " + this.mob.getExp(), 7, 32);
    }

    @NotNull
    public List<class_2561> getTooltipStrings(MobWrapper recipe, double mouseX, double mouseY) {
        if (this.mob.hasMultipleBiomes() && this.isOnBiome(mouseX, mouseY)) {
            return CollectionHelper.create(class_2561::method_43470, this.mob.getTranslatedBiomes());
        }
        return Collections.emptyList();
    }

    public void onTooltip(@NotNull IRecipeSlotView recipeSlotView, @NotNull List<class_2561> tooltip) {
        LootDrop lootDrop = this.mob.getDrops().get(Integer.parseInt(recipeSlotView.getSlotName().orElse("0")));
        tooltip.add(lootDrop.toStringTextComponent());
        List<class_2561> list = this.getToolTip((class_1799)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient());
        if (list != null) {
            tooltip.addAll(list);
        }
    }

    public List<class_2561> getToolTip(class_1799 stack) {
        for (LootDrop item : this.mob.getDrops()) {
            if (stack.method_31574(item.item.method_7909())) {
                return item.getTooltipText();
            }
            if (!item.canBeCooked() || !stack.method_31574(item.smeltedItem.method_7909())) continue;
            return item.getTooltipText(true);
        }
        return null;
    }

    private boolean isOnBiome(double mouseX, double mouseY) {
        return 2.0 <= mouseX && mouseX < 165.0 && 12.0 <= mouseY && mouseY < 22.0;
    }

    private float getScale(class_1309 livingEntity) {
        float height;
        float width = livingEntity.method_17681();
        if (width <= (height = livingEntity.method_17682())) {
            if ((double)height < 0.9) {
                return 50.0f;
            }
            if (height < 1.0f) {
                return 35.0f;
            }
            if ((double)height < 1.8) {
                return 33.0f;
            }
            if (height < 2.0f) {
                return 32.0f;
            }
            if (height < 3.0f) {
                return 24.0f;
            }
            if (height < 4.0f) {
                return 20.0f;
            }
            return 10.0f;
        }
        if (width < 1.0f) {
            return 38.0f;
        }
        if (width < 2.0f) {
            return 27.0f;
        }
        if (width < 3.0f) {
            return 13.0f;
        }
        return 9.0f;
    }

    private int getOffsetY(class_1309 livingEntity) {
        int offsetY = 0;
        if (livingEntity instanceof class_1477) {
            offsetY = 20;
        } else if (livingEntity instanceof class_1481) {
            offsetY = 10;
        } else if (livingEntity instanceof class_1640) {
            offsetY = -5;
        } else if (livingEntity instanceof class_1571) {
            offsetY = 15;
        } else if (livingEntity instanceof class_1528) {
            offsetY = -15;
        } else if (livingEntity instanceof class_1510) {
            offsetY = 15;
        } else if (livingEntity instanceof class_1560) {
            offsetY = -10;
        } else if (livingEntity instanceof class_1427) {
            offsetY = -10;
        } else if (livingEntity instanceof class_1429) {
            offsetY = -20;
        } else if (livingEntity instanceof class_1646) {
            offsetY = -15;
        } else if (livingEntity instanceof class_1576) {
            offsetY = -15;
        } else if (livingEntity instanceof class_1543) {
            offsetY = -15;
        } else if (livingEntity instanceof class_3989) {
            offsetY = -15;
        } else if (livingEntity instanceof class_1545) {
            offsetY = -10;
        } else if (livingEntity instanceof class_1548) {
            offsetY = -15;
        } else if (livingEntity instanceof class_5418) {
            offsetY = -15;
        }
        return offsetY;
    }

    public boolean hasSpawnEgg() {
        return this.getSpawnEgg() != null;
    }

    public class_1799 getSpawnEgg() {
        return this.mob.getEntity().method_31480();
    }
}

