/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.plant;

import java.util.List;
import jeresources.api.drop.PlantDrop;
import jeresources.compatibility.CompatBase;
import jeresources.entry.PlantEntry;
import jeresources.util.PlantHelper;
import jeresources.util.RenderHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class PlantWrapper
implements IRecipeCategoryExtension<PlantWrapper>,
IRecipeSlotTooltipCallback {
    protected final PlantEntry plantEntry;
    private class_2680 state;
    private class_2769<?> ageProperty;
    private long timer = -1L;
    private static final int TICKS = 500;

    public PlantWrapper(PlantEntry entry) {
        this.plantEntry = entry;
    }

    public void drawInfo(PlantWrapper recipe, int recipeWidth, int recipeHeight, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
        RenderHelper.renderBlock(guiGraphics, this.getFarmland(), 30.0f, 30.0f, -10.0f, 20.0f, 20.0f);
        RenderHelper.renderBlock(guiGraphics, this.getBlockState(), 30.0f, 12.0f, 10.0f, 20.0f, 20.0f);
    }

    public void onTooltip(IRecipeSlotView recipeSlotView, @NotNull List<class_2561> tooltip) {
        if (recipeSlotView.getRole() != RecipeIngredientRole.INPUT) {
            tooltip.add(this.getChanceString((class_1799)((ITypedIngredient)recipeSlotView.getDisplayedIngredient().get()).getIngredient()));
        }
    }

    public float getChance(class_1799 itemStack) {
        PlantDrop drop = this.plantEntry.getDrop(itemStack);
        return switch (drop.getDropKind()) {
            case PlantDrop.DropKind.chance -> drop.getChance();
            case PlantDrop.DropKind.weight -> (float)drop.getWeight() / (float)this.plantEntry.getTotalWeight();
            case PlantDrop.DropKind.minMax -> Float.NaN;
            default -> 0.0f;
        };
    }

    public int[] getMinMax(class_1799 itemStack) {
        PlantDrop drop = this.plantEntry.getDrop(itemStack);
        return new int[]{drop.getMinDrop(), drop.getMaxDrop()};
    }

    private class_2561 getChanceString(class_1799 itemStack) {
        String toPrint;
        float chance = this.getChance(itemStack);
        if (Float.isNaN(chance)) {
            int[] minMax = this.getMinMax(itemStack);
            toPrint = minMax[0] + (String)(minMax[0] == minMax[1] ? "" : " - " + minMax[1]);
        } else {
            toPrint = String.format("%2.2f", Float.valueOf(chance * 100.0f)).replace(",", ".") + "%";
        }
        return class_2561.method_43470((String)toPrint);
    }

    private class_2680 getBlockState() {
        if (this.state == null) {
            this.state = this.plantEntry.getPlantState() != null ? this.plantEntry.getPlantState() : (this.plantEntry.getPlant() != null ? PlantHelper.getPlant(this.plantEntry.getPlant(), (class_1922)CompatBase.getLevel(), class_2338.field_10980) : class_2248.method_9503((class_1792)this.plantEntry.getPlantItemStack().method_7909()).method_9564());
            if (this.plantEntry.getAgeProperty() != null) {
                this.ageProperty = this.plantEntry.getAgeProperty();
            } else {
                this.state.method_28501().stream().filter(p -> p.method_11899().equals("age")).findAny().ifPresent(property -> {
                    this.ageProperty = property;
                });
            }
        }
        if (this.ageProperty != null) {
            if (this.timer == -1L) {
                this.timer = System.currentTimeMillis() + 500L;
            } else if (System.currentTimeMillis() > this.timer) {
                this.state = (class_2680)this.state.method_28493(this.ageProperty);
                this.timer = System.currentTimeMillis() + 500L;
            }
        }
        return this.state;
    }

    private class_2680 getFarmland() {
        if (this.plantEntry.getSoil() != null) {
            return this.plantEntry.getSoil();
        }
        return class_2246.field_10362.method_9564();
    }
}

