/*
 * Decompiled with CFR 0.152.
 */
package jeresources.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionCustom;
import jeresources.api.distributions.DistributionHelpers;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.entry.WorldGenEntry;
import jeresources.platform.Services;
import jeresources.registry.WorldGenRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class WorldGenAdapter {
    private static final String worldGenFileName = "world-gen.json";
    private static Map<class_5321<class_1937>, Restriction> map = new HashMap<class_5321<class_1937>, Restriction>();

    public static File getWorldGenFile() {
        return Services.PLATFORM.getConfigDir().resolve(worldGenFileName).toFile();
    }

    public static boolean hasWorldGenDIYData() {
        return WorldGenAdapter.getWorldGenFile().exists();
    }

    public static boolean readDIYData() {
        try {
            JsonElement base = JsonParser.parseReader((Reader)new FileReader(WorldGenAdapter.getWorldGenFile()));
            if (!base.isJsonArray() || base.getAsJsonArray().size() == 0) {
                return false;
            }
            JsonArray array = base.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                JsonElement element = obj.get("mod");
                if (element != null && !Services.PLATFORM.getModsList().isLoaded(element.getAsString())) continue;
                String block = obj.get("block").getAsString();
                JsonElement distribElement = obj.get("distrib");
                if (distribElement == null) continue;
                String distrib = distribElement.getAsString();
                JsonElement silk = obj.get("silktouch");
                boolean silktouch = silk != null && silk.getAsBoolean();
                JsonElement dimElement = obj.get("dim");
                String dim = dimElement != null ? dimElement.getAsString() : "";
                String[] blockParts = block.split(":");
                class_1792 itemBlock = (class_1792)class_7923.field_41178.method_10223(new class_2960(blockParts[0], blockParts[1]));
                if (itemBlock == class_1802.field_8162) {
                    itemBlock = ((class_2248)class_7923.field_41175.method_10223(new class_2960(blockParts[0], blockParts[1]))).method_8389();
                }
                if (itemBlock == class_1802.field_8162) continue;
                class_1799 blockStack = itemBlock.method_7854();
                ArrayList<DistributionHelpers.OrePoint> points = new ArrayList<DistributionHelpers.OrePoint>();
                for (String point : distrib.split(";")) {
                    String[] split = point.split(",");
                    if (split.length != 2) continue;
                    points.add(new DistributionHelpers.OrePoint(Integer.parseInt(split[0]), Float.parseFloat(split[1])));
                }
                DistributionCustom distribution = new DistributionCustom(DistributionHelpers.getDistributionFromPoints(points.toArray(new DistributionHelpers.OrePoint[points.size()])));
                JsonElement dropsListElement = obj.get("dropsList");
                LinkedList<LootDrop> dropList = new LinkedList<LootDrop>();
                if (dropsListElement != null) {
                    JsonArray drops = dropsListElement.getAsJsonArray();
                    for (JsonElement dropElement : drops) {
                        JsonElement fortuneElement;
                        String itemStackString;
                        String[] stackStrings;
                        class_1792 item;
                        JsonObject drop = dropElement.getAsJsonObject();
                        JsonElement itemStackElement = drop.get("itemStack");
                        if (itemStackElement.isJsonNull() || (item = (class_1792)class_7923.field_41178.method_10223(new class_2960((stackStrings = (itemStackString = itemStackElement.getAsString()).split(":", 4))[0], stackStrings[1]))) == class_1802.field_8162) continue;
                        class_1799 itemStack = new class_1799((class_1935)item);
                        if (stackStrings.length >= 3) {
                            itemStack.method_7974(Integer.valueOf(stackStrings[2]).intValue());
                        }
                        if (stackStrings.length == 4) {
                            // empty if block
                        }
                        if ((fortuneElement = drop.get("fortunes")) == null) continue;
                        JsonObject fortunes = fortuneElement.getAsJsonObject();
                        for (Map.Entry fortuneValue : fortunes.entrySet()) {
                            int fortuneLevel = Integer.parseInt((String)fortuneValue.getKey());
                            float dropAmount = ((JsonElement)fortuneValue.getValue()).getAsFloat();
                            dropList.add(new LootDrop(itemStack, dropAmount, fortuneLevel));
                        }
                    }
                }
                if ((blockStack.method_7960() || blockStack.method_7909() == class_1802.field_8162) && dropList.size() > 0) {
                    blockStack = ((LootDrop)dropList.get((int)0)).item.method_7972();
                    blockStack.method_7939(1);
                }
                WorldGenRegistry.getInstance().registerEntry(new WorldGenEntry(blockStack, (DistributionBase)distribution, WorldGenAdapter.getRestriction(dim), silktouch, dropList.toArray(new LootDrop[dropList.size()])));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        map.clear();
        return true;
    }

    private static Restriction getRestriction(String dim) {
        class_5321 worldRegistryKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dim));
        return map.computeIfAbsent((class_5321<class_1937>)worldRegistryKey, k -> new Restriction(new DimensionRestriction((class_5321<class_1937>)worldRegistryKey)));
    }
}

