/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import jeresources.api.drop.LootDrop;
import jeresources.compatibility.CompatBase;
import jeresources.config.Settings;
import jeresources.platform.Services;
import jeresources.util.LootTableFetcher;
import jeresources.util.MobTableBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_67;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;

public class LootTableHelper {
    private static final Map<class_1767, class_5321<class_52>> sheepColors = new HashMap<class_1767, class_5321<class_52>>();
    private static LootTableFetcher lootTableFetcher;

    public static List<class_55> getPools(class_52 table) {
        return Services.PLATFORM.getLootTableHelper().getPools(table);
    }

    public static List<class_79> getLootEntries(class_55 pool) {
        return Services.PLATFORM.getLootTableHelper().getLootEntries(pool);
    }

    public static List<class_5341> getLootConditions(class_55 pool) {
        return Services.PLATFORM.getLootTableHelper().getLootConditions(pool);
    }

    public static List<LootDrop> toDrops(class_52 table) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        LootTableFetcher lootTableFetcher = LootTableHelper.getLootTableFetcher();
        LootTableHelper.getPools(table).forEach(pool -> {
            float totalWeight = LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof class_85).map(entry -> (class_85)entry).mapToInt(entry -> entry.field_995).sum();
            List<class_5341> poolConditions = LootTableHelper.getLootConditions(pool);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof class_77).map(entry -> (class_77)entry).map(entry -> new LootDrop((class_1792)entry.field_987.comp_349(), (float)entry.field_995 / totalWeight, (Collection<class_5341>)entry.field_988, entry.field_996)).map(drop -> drop.addLootConditions(poolConditions)).forEach(drops::add);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof class_67).map(entry -> (class_67)entry).map(entry -> LootTableHelper.toDrops(lootTableFetcher.getLootTable((class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)entry.field_980)))).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static List<LootDrop> toDrops(class_5321<class_52> lootTableKey) {
        return LootTableHelper.toDrops(LootTableHelper.getLootTableFetcher().getLootTable(lootTableKey));
    }

    public static List<class_5321<class_52>> getAllChestLootTablesResourceKeys() {
        ArrayList<class_5321<class_52>> chestTables = new ArrayList<class_5321<class_52>>();
        chestTables.add(class_39.field_274);
        chestTables.add(class_39.field_356);
        chestTables.add(class_39.field_434);
        chestTables.add(class_39.field_17107);
        chestTables.add(class_39.field_17009);
        chestTables.add(class_39.field_16751);
        chestTables.add(class_39.field_17010);
        chestTables.add(class_39.field_17011);
        chestTables.add(class_39.field_17012);
        chestTables.add(class_39.field_17108);
        chestTables.add(class_39.field_18007);
        chestTables.add(class_39.field_16750);
        chestTables.add(class_39.field_17109);
        chestTables.add(class_39.field_16752);
        chestTables.add(class_39.field_16748);
        chestTables.add(class_39.field_16749);
        chestTables.add(class_39.field_16754);
        chestTables.add(class_39.field_16753);
        chestTables.add(class_39.field_472);
        chestTables.add(class_39.field_615);
        chestTables.add(class_39.field_683);
        chestTables.add(class_39.field_800);
        chestTables.add(class_39.field_842);
        chestTables.add(class_39.field_885);
        chestTables.add(class_39.field_803);
        chestTables.add(class_39.field_662);
        chestTables.add(class_39.field_484);
        chestTables.add(class_39.field_397);
        chestTables.add(class_39.field_300);
        chestTables.add(class_39.field_251);
        chestTables.add(class_39.field_841);
        chestTables.add(class_39.field_880);
        chestTables.add(class_39.field_665);
        chestTables.add(class_39.field_16593);
        chestTables.add(class_39.field_24046);
        chestTables.add(class_39.field_24047);
        chestTables.add(class_39.field_24048);
        chestTables.add(class_39.field_24049);
        chestTables.add(class_39.field_24050);
        chestTables.add(class_39.field_38438);
        chestTables.add(class_39.field_38439);
        return chestTables;
    }

    public static Map<class_5321<class_52>, Supplier<class_1309>> getAllMobLootTables() {
        MobTableBuilder mobTableBuilder = new MobTableBuilder();
        for (Map.Entry<class_1767, class_5321<class_52>> entry : sheepColors.entrySet()) {
            class_5321<class_52> lootTableList = entry.getValue();
            class_1767 dyeColor = entry.getKey();
            mobTableBuilder.addSheep(lootTableList, (class_1299<class_1472>)class_1299.field_6115, dyeColor);
        }
        for (class_1299 entityType : class_7923.field_41177) {
            if (entityType.method_5891() == class_1311.field_17715 || entityType == class_1299.field_6115) continue;
            mobTableBuilder.add((class_5321<class_52>)entityType.method_16351(), entityType);
        }
        return mobTableBuilder.getMobTables();
    }

    public static LootTableFetcher getLootTableFetcher() {
        class_1937 level = CompatBase.getServerLevel().orElseGet(CompatBase::getLevel);
        if (level.method_8503() == null) {
            if (lootTableFetcher == null) {
                lootTableFetcher = new LootTableFetcher();
                if (Settings.disableLootManagerReloading) {
                    return lootTableFetcher;
                }
            }
            return lootTableFetcher;
        }
        return new LootTableFetcher(level.method_8503().method_58576());
    }

    static {
        sheepColors.put(class_1767.field_7952, (class_5321<class_52>)class_39.field_869);
        sheepColors.put(class_1767.field_7946, (class_5321<class_52>)class_39.field_814);
        sheepColors.put(class_1767.field_7958, (class_5321<class_52>)class_39.field_224);
        sheepColors.put(class_1767.field_7951, (class_5321<class_52>)class_39.field_461);
        sheepColors.put(class_1767.field_7947, (class_5321<class_52>)class_39.field_385);
        sheepColors.put(class_1767.field_7961, (class_5321<class_52>)class_39.field_702);
        sheepColors.put(class_1767.field_7954, (class_5321<class_52>)class_39.field_629);
        sheepColors.put(class_1767.field_7944, (class_5321<class_52>)class_39.field_878);
        sheepColors.put(class_1767.field_7967, (class_5321<class_52>)class_39.field_806);
        sheepColors.put(class_1767.field_7955, (class_5321<class_52>)class_39.field_365);
        sheepColors.put(class_1767.field_7945, (class_5321<class_52>)class_39.field_285);
        sheepColors.put(class_1767.field_7966, (class_5321<class_52>)class_39.field_394);
        sheepColors.put(class_1767.field_7957, (class_5321<class_52>)class_39.field_489);
        sheepColors.put(class_1767.field_7942, (class_5321<class_52>)class_39.field_607);
        sheepColors.put(class_1767.field_7964, (class_5321<class_52>)class_39.field_716);
        sheepColors.put(class_1767.field_7963, (class_5321<class_52>)class_39.field_778);
    }
}

