/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.api.MobRegistryImpl;
import jeresources.reference.Resources;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.lwjgl.BufferUtils;

public class RenderHelper {
    public static void drawLine(class_332 guiGraphics, int xBegin, int yBegin, int xEnd, int yEnd, int color) {
        guiGraphics.method_25294(xBegin, yBegin, xEnd += xBegin == xEnd ? 1 : 0, yEnd += yBegin == yEnd ? 1 : 0, color);
    }

    public static void renderEntity(class_332 guiGraphics, int x, int y, double scale, double yaw, double pitch, class_1309 livingEntity) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.mul((Matrix4fc)guiGraphics.method_51448().method_23760().method_23761());
        modelViewStack.translate((float)x, (float)y, 50.0f);
        modelViewStack.scale((float)(-scale), (float)scale, (float)scale);
        class_4587 mobPoseStack = new class_4587();
        mobPoseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(livingEntity, new IMobRenderHook.RenderInfo(x, y, scale, yaw, pitch));
        x = renderInfo.x;
        y = renderInfo.y;
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        mobPoseStack.method_22907(class_7833.field_40713.rotationDegrees((float)Math.atan(pitch / 40.0) * 20.0f));
        livingEntity.field_6036 = (float)Math.atan(yaw / 40.0) * 20.0f;
        float yRot = (float)Math.atan(yaw / 40.0) * 40.0f;
        float xRot = -((float)Math.atan(pitch / 40.0)) * 20.0f;
        livingEntity.method_36456(yRot);
        livingEntity.method_36456(yRot);
        livingEntity.method_36457(xRot);
        livingEntity.field_6241 = yRot;
        livingEntity.field_6259 = yRot;
        mobPoseStack.method_22904(0.0, livingEntity.method_23318(), 0.0);
        RenderSystem.applyModelViewMatrix();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, mobPoseStack, (class_4597)bufferSource, 0xF000F0));
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderChest(class_332 guiGraphics, float x, float y, float rotate, float scale, float lidAngle) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)Resources.Vanilla.CHEST);
        guiGraphics.method_51448().method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_46416(x, y, 50.0f);
        guiGraphics.method_51448().method_22907(new Quaternionf(-160.0f, 1.0f, 0.0f, 0.0f));
        guiGraphics.method_51448().method_22905(scale, -scale, -scale);
        guiGraphics.method_51448().method_46416(0.5f, 0.5f, 0.5f);
        guiGraphics.method_51448().method_22907(new Quaternionf(rotate, 0.0f, 1.0f, 0.0f));
        guiGraphics.method_51448().method_46416(-0.5f, -0.5f, -0.5f);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
        guiGraphics.method_51448().method_22909();
    }

    public static void renderBlock(class_332 guiGraphics, class_2680 block, float x, float y, float z, float rotate, float scale) {
        class_310 mc = class_310.method_1551();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x, y, z);
        guiGraphics.method_51448().method_22905(-scale, -scale, -scale);
        guiGraphics.method_51448().method_46416(-0.5f, -0.5f, 0.0f);
        guiGraphics.method_51448().method_22907(class_7833.field_40714.rotationDegrees(-30.0f));
        guiGraphics.method_51448().method_46416(0.5f, 0.0f, -0.5f);
        guiGraphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(rotate));
        guiGraphics.method_51448().method_46416(-0.5f, 0.0f, 0.5f);
        guiGraphics.method_51448().method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, -1.0f);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        mc.method_1541().method_3353(block, guiGraphics.method_51448(), (class_4597)bufferSource, 0xF000F0, class_4608.field_21444);
        bufferSource.method_22993();
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22909();
    }

    public static void scissor(class_332 guiGraphics, int x, int y, int w, int h) {
        double scale = class_310.method_1551().method_22683().method_4495();
        double[] xyzTranslation = RenderHelper.getGLTranslation(guiGraphics, scale);
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        w = (int)((double)w * scale);
        h = (int)((double)h * scale);
        int scissorX = Math.round(Math.round(xyzTranslation[0] + (double)x));
        int scissorY = Math.round(Math.round((double)(class_310.method_1551().method_22683().method_4506() - y) - xyzTranslation[1]));
        int scissorW = Math.round(w - x);
        int scissorH = Math.round(h - y);
        IScissorHook.ScissorInfo scissorInfo = MobRegistryImpl.applyScissorHooks(new IScissorHook.ScissorInfo(scissorX, scissorY, scissorW, scissorH));
        RenderSystem.enableScissor((int)scissorInfo.x, (int)scissorInfo.y, (int)Math.max(0, scissorInfo.width), (int)Math.max(0, scissorInfo.height));
    }

    public static void stopScissor() {
        RenderSystem.disableScissor();
    }

    public static void drawTexture(class_332 guiGraphics, int x, int y, int u, int v, int width, int height, class_2960 resource) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)resource);
        RenderHelper.drawTexturedModalRect(guiGraphics, x, y, u, v, width, height, 0.0f);
    }

    public static double[] getGLTranslation(class_332 guiGraphics, double scale) {
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        matrix.set(buf);
        return new double[]{(double)buf.get(RenderHelper.getIndexFloatBuffer(0, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(1, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(2, 3)) * scale};
    }

    private static int getIndexFloatBuffer(int x, int y) {
        return y * 4 + x;
    }

    public static double getGuiScaleFactor() {
        return class_310.method_1551().method_22683().method_4495();
    }

    public static void drawTexturedModalRect(class_332 guiGraphics, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        class_289 tesselator = class_289.method_1348();
        class_287 wr = tesselator.method_1349();
        wr.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        wr.method_22918(matrix, (float)x, (float)(y + height), zLevel).method_22913((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)x, (float)y, zLevel).method_22913((float)u * 0.00390625f, (float)v * 0.00390625f).method_1344();
        tesselator.method_1350();
    }
}

