/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.mobeffect.MobEffectAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import artifacts.util.DamageSourceHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record AttacksInflictMobEffectAbility(class_6880<class_1291> mobEffect, Value<Integer> level, Value<Integer> duration, Value<Integer> cooldown, Value<Double> chance) implements MobEffectAbility
{
    private static final Set<class_6880<class_1291>> CUSTOM_TOOLTIP_MOB_EFFECTS = Set.of(class_1294.field_5920);
    public static final MapCodec<AttacksInflictMobEffectAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> MobEffectAbility.codecStartWithDuration(instance).and((App)ValueTypes.cooldownField().forGetter(AttacksInflictMobEffectAbility::cooldown)).and((App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(AttacksInflictMobEffectAbility::chance)).apply((Applicative)instance, AttacksInflictMobEffectAbility::new));
    public static final class_9139<class_9129, AttacksInflictMobEffectAbility> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.method_56383((class_5321)class_7924.field_41208), AttacksInflictMobEffectAbility::mobEffect, ValueTypes.MOB_EFFECT_LEVEL.streamCodec(), AttacksInflictMobEffectAbility::level, ValueTypes.DURATION.streamCodec(), AttacksInflictMobEffectAbility::duration, ValueTypes.DURATION.streamCodec(), AttacksInflictMobEffectAbility::cooldown, ValueTypes.FRACTION.streamCodec(), AttacksInflictMobEffectAbility::chance, AttacksInflictMobEffectAbility::new);

    public static EventResult onLivingHurt(class_1309 entity, class_1282 damageSource, float amount) {
        class_1309 attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && DamageSourceHelper.isMeleeAttack(damageSource) && !entity.method_37908().method_8608()) {
            AbilityHelper.forEach((ArtifactAbility.Type)ModAbilities.ATTACKS_INFLICT_MOB_EFFECT.comp_349(), attacker, (ability, stack) -> {
                if (entity.method_6051().method_43058() < (Double)ability.chance().get()) {
                    entity.method_37222(ability.createEffect(attacker), (class_1297)attacker);
                    if (attacker instanceof class_1657) {
                        class_1657 player = (class_1657)attacker;
                        player.method_7357().method_7906(stack.method_7909(), (Integer)ability.cooldown().get() * 20);
                    }
                }
            }, true);
        }
        return EventResult.pass();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.ATTACKS_INFLICT_MOB_EFFECT.comp_349();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Integer)this.duration().get() > 0 && (Integer)this.level().get() > 0 && (Double)this.chance().get() > 0.0;
    }

    @Override
    public void addAbilityTooltip(List<class_5250> tooltip) {
        for (class_6880<class_1291> mobEffect : CUSTOM_TOOLTIP_MOB_EFFECTS) {
            if (!mobEffect.method_40227() || mobEffect.comp_349() != this.mobEffect().comp_349()) continue;
            String name = class_7923.field_41174.method_10221((Object)((class_1291)mobEffect.comp_349())).method_12832();
            if (class_3532.method_20390((double)((Double)this.chance().get()), (double)1.0)) {
                tooltip.add(this.tooltipLine(name + ".constant", new Object[0]));
            } else {
                tooltip.add(this.tooltipLine(name + ".chance", new Object[0]));
            }
            return;
        }
    }
}

