/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.mobeffect.ConstantMobEffectAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_3486;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9139;

public class LimitedWaterBreathingAbility
extends ConstantMobEffectAbility {
    public static final MapCodec<LimitedWaterBreathingAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(LimitedWaterBreathingAbility::duration), (App)ValueTypes.BOOLEAN.codec().optionalFieldOf("infinite", Value.of(false)).forGetter(ability -> ability.isInfinite)).apply((Applicative)instance, LimitedWaterBreathingAbility::new));
    public static final class_9139<ByteBuf, LimitedWaterBreathingAbility> STREAM_CODEC = class_9139.method_56435(ValueTypes.DURATION.streamCodec(), LimitedWaterBreathingAbility::duration, ValueTypes.BOOLEAN.streamCodec(), ability -> ability.isInfinite, LimitedWaterBreathingAbility::new);
    private final Value<Integer> duration;
    private final Value<Boolean> isInfinite;

    public LimitedWaterBreathingAbility(Value<Integer> duration, Value<Boolean> isInfinite) {
        super((class_6880<class_1291>)class_1294.field_5923);
        this.duration = duration;
        this.isInfinite = isInfinite;
    }

    @Override
    public boolean isInfinite() {
        return (Boolean)this.isInfinite.get();
    }

    @Override
    public Value<Integer> duration() {
        return this.duration;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.LIMITED_WATER_BREATHING.comp_349();
    }

    @Override
    public void addAbilityTooltip(List<class_5250> tooltip) {
        if (this.isInfinite()) {
            tooltip.add(this.tooltipLine("infinite", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("limited", new Object[0]));
        }
    }

    @Override
    protected int getAdditionalDuration(class_1309 target) {
        if (!this.isInfinite() && target instanceof class_1657 && target.method_6118(class_1304.field_6169).method_31574(class_1802.field_8090) && !target.method_5777(class_3486.field_15517)) {
            return 200;
        }
        return 0;
    }

    @Override
    public boolean shouldShowIcon() {
        return !this.isInfinite();
    }

    @Override
    public boolean shouldApplyMobEffect(class_1309 entity) {
        return this.isInfinite() || !entity.method_5777(class_3486.field_15517);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitedWaterBreathingAbility that = (LimitedWaterBreathingAbility)o;
        return this.duration.equals(that.duration) && this.isInfinite.equals(that.isInfinite);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.duration, this.isInfinite);
    }
}

