/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.retaliation;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.util.AbilityHelper;
import artifacts.util.DamageSourceHelper;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public abstract class RetaliationAbility
implements ArtifactAbility {
    private final Value<Double> strikeChance;
    private final Value<Integer> cooldown;

    protected static <T extends RetaliationAbility> Products.P2<RecordCodecBuilder.Mu<T>, Value<Double>, Value<Integer>> codecStart(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)ValueTypes.FRACTION.codec().fieldOf("chance").forGetter(RetaliationAbility::strikeChance), (App)ValueTypes.cooldownField().forGetter(RetaliationAbility::cooldown));
    }

    public RetaliationAbility(Value<Double> strikeChance, Value<Integer> cooldown) {
        this.strikeChance = strikeChance;
        this.cooldown = cooldown;
    }

    public Value<Double> strikeChance() {
        return this.strikeChance;
    }

    public Value<Integer> cooldown() {
        return this.cooldown;
    }

    public void onLivingHurt(class_1309 entity, class_1799 stack, class_1282 damageSource, float amount) {
        class_1309 attacker = DamageSourceHelper.getAttacker(damageSource);
        if (amount >= 1.0f && attacker != null && AbilityHelper.hasAbilityActive(this.getType(), entity) && entity.method_6051().method_43058() < (Double)this.strikeChance().get()) {
            this.applyEffect(entity, attacker);
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if ((Integer)this.cooldown().get() > 0) {
                    player.method_7357().method_7906(stack.method_7909(), (Integer)this.cooldown().get() * 20);
                }
            }
        }
    }

    protected abstract void applyEffect(class_1309 var1, class_1309 var2);

    @Override
    public boolean isNonCosmetic() {
        return !class_3532.method_20390((double)((Double)this.strikeChance().get()), (double)0.0);
    }

    @Override
    public void addAbilityTooltip(List<class_5250> tooltip) {
        if (class_3532.method_20390((double)((Double)this.strikeChance().get()), (double)1.0)) {
            tooltip.add(this.tooltipLine("constant", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("chance", new Object[0]));
        }
    }
}

