/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.retaliation;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.retaliation.RetaliationAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_5250;
import net.minecraft.class_9139;

public class SetAttackersOnFireAbility
extends RetaliationAbility {
    public static final MapCodec<SetAttackersOnFireAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> SetAttackersOnFireAbility.codecStart(instance).and((App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(SetAttackersOnFireAbility::fireDuration)).and((App)ValueTypes.BOOLEAN.codec().optionalFieldOf("grant_fire_resistance", Value.of(true)).forGetter(SetAttackersOnFireAbility::grantsFireResistance)).apply((Applicative)instance, SetAttackersOnFireAbility::new));
    public static final class_9139<ByteBuf, SetAttackersOnFireAbility> STREAM_CODEC = class_9139.method_56905(ValueTypes.FRACTION.streamCodec(), RetaliationAbility::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationAbility::cooldown, ValueTypes.DURATION.streamCodec(), SetAttackersOnFireAbility::fireDuration, ValueTypes.BOOLEAN.streamCodec(), SetAttackersOnFireAbility::grantsFireResistance, SetAttackersOnFireAbility::new);
    private final Value<Integer> fireDuration;
    private final Value<Boolean> grantsFireResistance;

    public SetAttackersOnFireAbility(Value<Double> strikeChance, Value<Integer> cooldown, Value<Integer> fireDuration, Value<Boolean> grantsFireResistance) {
        super(strikeChance, cooldown);
        this.fireDuration = fireDuration;
        this.grantsFireResistance = grantsFireResistance;
    }

    public Value<Integer> fireDuration() {
        return this.fireDuration;
    }

    public Value<Boolean> grantsFireResistance() {
        return this.grantsFireResistance;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.SET_ATTACKERS_ON_FIRE.comp_349();
    }

    @Override
    public boolean isNonCosmetic() {
        return super.isNonCosmetic() && (Integer)this.fireDuration().get() > 0;
    }

    @Override
    protected void applyEffect(class_1309 target, class_1309 attacker) {
        if (!attacker.method_5753() && attacker.method_6102() && (Integer)this.fireDuration().get() > 0) {
            if (((Boolean)this.grantsFireResistance().get()).booleanValue()) {
                target.method_6092(new class_1293(class_1294.field_5918, (Integer)this.fireDuration().get() * 20, 0, false, false, true));
            }
            attacker.method_5639(((Integer)this.fireDuration().get()).intValue());
        }
    }

    @Override
    public void addAbilityTooltip(List<class_5250> tooltip) {
        super.addAbilityTooltip(tooltip);
        if (((Boolean)this.grantsFireResistance().get()).booleanValue()) {
            tooltip.add(this.tooltipLine("fire_resistance", new Object[0]));
        }
    }
}

