/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.retaliation;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.retaliation.RetaliationAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_9139;

public class ThornsAbility
extends RetaliationAbility {
    public static final MapCodec<ThornsAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> ThornsAbility.codecStart(instance).and((App)ValueTypes.NON_NEGATIVE_INT.codec().fieldOf("min_damage").forGetter(ThornsAbility::minDamage)).and((App)ValueTypes.NON_NEGATIVE_INT.codec().fieldOf("max_damage").forGetter(ThornsAbility::maxDamage)).apply((Applicative)instance, ThornsAbility::new));
    public static final class_9139<ByteBuf, ThornsAbility> STREAM_CODEC = class_9139.method_56905(ValueTypes.FRACTION.streamCodec(), RetaliationAbility::strikeChance, ValueTypes.DURATION.streamCodec(), RetaliationAbility::cooldown, ValueTypes.NON_NEGATIVE_INT.streamCodec(), ThornsAbility::minDamage, ValueTypes.NON_NEGATIVE_INT.streamCodec(), ThornsAbility::maxDamage, ThornsAbility::new);
    private final Value<Integer> minDamage;
    private final Value<Integer> maxDamage;

    public ThornsAbility(Value<Double> strikeChance, Value<Integer> cooldown, Value<Integer> minDamage, Value<Integer> maxDamage) {
        super(strikeChance, cooldown);
        this.minDamage = minDamage;
        this.maxDamage = maxDamage;
    }

    public Value<Integer> minDamage() {
        return this.minDamage;
    }

    public Value<Integer> maxDamage() {
        return this.maxDamage;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.THORNS.comp_349();
    }

    @Override
    public boolean isNonCosmetic() {
        return super.isNonCosmetic() && (Integer)this.maxDamage().get() > 0;
    }

    @Override
    protected void applyEffect(class_1309 target, class_1309 attacker) {
        if (attacker.method_6102()) {
            int damage;
            int minDamage = (Integer)this.minDamage().get();
            int maxDamage = (Integer)this.maxDamage().get();
            if (maxDamage < minDamage) {
                minDamage = maxDamage;
            }
            if ((damage = minDamage + target.method_6051().method_43048(maxDamage - minDamage + 1)) > 0) {
                attacker.method_5643(target.method_48923().method_48818((class_1297)target), (float)damage);
            }
        }
    }
}

