/*
 * Decompiled with CFR 0.152.
 */
package artifacts.attribute;

import artifacts.item.UmbrellaItem;
import artifacts.mixin.accessors.EntityAccessor;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModTags;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_3481;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class DynamicAttributeModifier {
    private static final List<DynamicAttributeModifier> MODIFIERS = List.of(new DynamicAttributeModifier("artifacts:mount_speed", (class_6880<class_1320>)class_5134.field_23719, class_1322.class_1323.field_6330, entity -> entity.method_5642() != null, entity -> Objects.requireNonNull(entity.method_5642()).method_45325(ModAttributes.MOUNT_SPEED)), new DynamicAttributeModifier("artifacts:sprinting_speed", (class_6880<class_1320>)class_5134.field_23719, class_1322.class_1323.field_6330, class_1297::method_5624, entity -> entity.method_45325(ModAttributes.SPRINTING_SPEED) - 1.0), new DynamicAttributeModifier("artifacts:sprinting_step_height", (class_6880<class_1320>)class_5134.field_47761, class_1322.class_1323.field_6328, class_1297::method_5624, entity -> entity.method_45325(ModAttributes.SPRINTING_STEP_HEIGHT)), new DynamicAttributeModifier("artifacts:umbrella_gravity", (class_6880<class_1320>)class_5134.field_49078, class_1322.class_1323.field_6331, UmbrellaItem::shouldGlide, entity -> -0.875), new DynamicAttributeModifier("artifacts:movement_speed_on_snow", (class_6880<class_1320>)class_5134.field_23719, class_1322.class_1323.field_6330, entity -> {
        if (entity.method_45325(ModAttributes.MOVEMENT_SPEED_ON_SNOW) == 1.0) return false;
        if (!entity.method_24828()) return false;
        if (!(entity instanceof EntityAccessor)) return false;
        EntityAccessor entityAccessor = (EntityAccessor)entity;
        if (entity.method_37908().method_8320(entityAccessor.callGetBlockPosBelowThatAffectsMyMovement()).method_26164(class_3481.field_29823)) return true;
        if (!entity.method_37908().method_8320(entityAccessor.callGetBlockPosBelowThatAffectsMyMovement().method_10084()).method_26164(ModTags.SNOW_LAYERS)) return false;
        return true;
    }, entity -> {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31549().field_7479) {
                return true;
            }
        }
        return entity.method_24828() || entity.method_6128();
    }, entity -> entity.method_45325(ModAttributes.MOVEMENT_SPEED_ON_SNOW) - 1.0));
    private final class_6880<class_1320> attribute;
    private final class_1322.class_1323 operation;
    private final UUID modifierId;
    private final String name;
    private final Predicate<class_1309> shouldApply;
    private final Predicate<class_1309> shouldUpdate;
    private final Function<class_1309, Double> amount;

    public DynamicAttributeModifier(String name, class_6880<class_1320> attribute, class_1322.class_1323 operation, Predicate<class_1309> shouldApply, Function<class_1309, Double> amount) {
        this(name, attribute, operation, shouldApply, entity -> true, amount);
    }

    public DynamicAttributeModifier(String name, class_6880<class_1320> attribute, class_1322.class_1323 operation, Predicate<class_1309> shouldApply, Predicate<class_1309> shouldUpdate, Function<class_1309, Double> amount) {
        this.attribute = attribute;
        this.operation = operation;
        this.modifierId = UUID.nameUUIDFromBytes(name.getBytes());
        this.name = name;
        this.shouldApply = shouldApply;
        this.shouldUpdate = shouldUpdate;
        this.amount = amount;
    }

    public static void tickModifiers(class_1309 entity) {
        for (DynamicAttributeModifier modifier : MODIFIERS) {
            modifier.tick(entity);
        }
    }

    private void tick(class_1309 entity) {
        class_1324 attributeInstance = entity.method_5996(this.attribute);
        if (attributeInstance == null || !this.shouldUpdate.test(entity)) {
            return;
        }
        if (this.shouldApply.test(entity)) {
            double amount = this.amount.apply(entity);
            class_1322 modifier = attributeInstance.method_6199(this.modifierId);
            if (modifier == null || modifier.comp_2449() != amount) {
                attributeInstance.method_55696(new class_1322(this.modifierId, this.name, amount, this.operation));
            }
        } else {
            attributeInstance.method_6200(this.modifierId);
        }
    }
}

