/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.item.renderer;

import artifacts.client.item.model.ArmsModel;
import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.platform.PlatformServices;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class GloveArtifactRenderer
implements ArtifactRenderer {
    private final class_2960 wideTexture;
    private final class_2960 slimTexture;
    private final ArmsModel wideModel;
    private final ArmsModel slimModel;

    public GloveArtifactRenderer(String name, Function<Boolean, ArmsModel> model) {
        this(ArtifactRenderer.getTexturePath(name, "%s_wide".formatted(name)), ArtifactRenderer.getTexturePath(name, "%s_slim".formatted(name)), model);
    }

    public GloveArtifactRenderer(String wideTexture, String slimTexture, Function<Boolean, ArmsModel> model) {
        this(ArtifactRenderer.getTexturePath(wideTexture), ArtifactRenderer.getTexturePath(slimTexture), model);
    }

    public GloveArtifactRenderer(class_2960 wideTexture, class_2960 slimTexture, Function<Boolean, ArmsModel> model) {
        this.wideTexture = wideTexture;
        this.slimTexture = slimTexture;
        this.wideModel = model.apply(false);
        this.slimModel = model.apply(true);
    }

    @Nullable
    public static GloveArtifactRenderer getGloveRenderer(class_1799 stack) {
        ArtifactRenderer artifactRenderer;
        if (!stack.method_7960() && (artifactRenderer = PlatformServices.platformHelper.getArtifactRenderer(stack.method_7909())) instanceof GloveArtifactRenderer) {
            GloveArtifactRenderer gloveRenderer = (GloveArtifactRenderer)artifactRenderer;
            return gloveRenderer;
        }
        return null;
    }

    protected class_2960 getTexture(boolean hasSlimArms) {
        return hasSlimArms ? this.slimTexture : this.wideTexture;
    }

    protected ArmsModel getModel(boolean hasSlimArms) {
        return hasSlimArms ? this.slimModel : this.wideModel;
    }

    protected static boolean hasSlimArms(class_1297 entity) {
        class_742 player;
        return entity instanceof class_742 && (player = (class_742)entity).method_52814().comp_1629() == class_8685.class_7920.field_41122;
    }

    @Override
    public void render(class_1799 stack, class_1309 entity, int slotIndex, class_4587 poseStack, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasSlimArms = GloveArtifactRenderer.hasSlimArms((class_1297)entity);
        ArmsModel model = this.getModel(hasSlimArms);
        class_1268 hand = slotIndex % 2 == 0 ? class_1268.field_5808 : class_1268.field_5810;
        class_1306 handSide = hand == class_1268.field_5808 ? entity.method_6068() : entity.method_6068().method_5928();
        model.method_17087(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.method_17086(entity, limbSwing, limbSwingAmount, partialTicks);
        ArtifactRenderer.followBodyRotations(entity, model);
        this.renderArm(model, poseStack, multiBufferSource, handSide, light, hasSlimArms, stack.method_7958());
    }

    protected void renderArm(ArmsModel model, class_4587 matrixStack, class_4597 buffer, class_1306 handSide, int light, boolean hasSlimArms, boolean hasFoil) {
        class_1921 renderType = model.method_23500(this.getTexture(hasSlimArms));
        class_4588 vertexBuilder = class_918.method_23181((class_4597)buffer, (class_1921)renderType, (boolean)false, (boolean)hasFoil);
        model.renderArm(handSide, matrixStack, vertexBuilder, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public final void renderFirstPersonArm(class_4587 matrixStack, class_4597 buffer, int light, class_742 player, class_1306 side, boolean hasFoil) {
        if (!player.method_7325()) {
            boolean hasSlimArms = GloveArtifactRenderer.hasSlimArms((class_1297)player);
            ArmsModel model = this.getModel(hasSlimArms);
            class_630 arm = side == class_1306.field_6182 ? model.field_27433 : model.field_3401;
            model.method_2805(false);
            arm.field_3665 = true;
            model.field_3400 = false;
            model.field_3396 = 0.0f;
            model.field_3447 = 0.0f;
            model.method_17087((class_1309)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.field_3654 = 0.0f;
            this.renderFirstPersonArm(model, arm, matrixStack, buffer, light, hasSlimArms, hasFoil);
        }
    }

    protected void renderFirstPersonArm(ArmsModel model, class_630 arm, class_4587 matrixStack, class_4597 buffer, int light, boolean hasSlimArms, boolean hasFoil) {
        class_1921 renderType = model.method_23500(this.getTexture(hasSlimArms));
        class_4588 builder = class_918.method_23181((class_4597)buffer, (class_1921)renderType, (boolean)false, (boolean)hasFoil);
        arm.method_22698(matrixStack, builder, light, class_4608.field_21444);
    }
}

