/*
 * Decompiled with CFR 0.152.
 */
package artifacts.fabric.platform;

import artifacts.Artifacts;
import artifacts.client.item.renderer.ArtifactRenderer;
import artifacts.component.AbilityToggles;
import artifacts.component.SwimData;
import artifacts.fabric.client.CosmeticsHelper;
import artifacts.fabric.mixin.accessors.AttributesAccessor;
import artifacts.fabric.registry.ModAttributesFabric;
import artifacts.fabric.registry.ModComponents;
import artifacts.fabric.registry.ModDataComponentsFabric;
import artifacts.fabric.trinket.TrinketsHelper;
import artifacts.item.WearableArtifactItem;
import artifacts.platform.PlatformHelper;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3486;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_583;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class FabricPlatformHelper
implements PlatformHelper {
    @Override
    public Stream<class_1799> findAllEquippedBy(class_1309 entity, Predicate<class_1799> predicate) {
        ArrayList<class_1799> armor = new ArrayList<class_1799>(4);
        for (class_1799 stack : entity.method_56674()) {
            if (!predicate.test(stack)) continue;
            armor.add(stack);
        }
        return Stream.concat(TrinketsHelper.findAllEquippedBy(entity).filter(predicate), armor.stream());
    }

    @Override
    public <T> T reduceItems(class_1309 entity, T init, BiFunction<class_1799, T, T> f) {
        Optional component = TrinketsApi.getTrinketComponent((class_1309)entity);
        if (component.isPresent()) {
            for (Map map : ((TrinketComponent)component.get()).getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        class_1799 item = inventory.method_5438(i);
                        if (item.method_7960()) continue;
                        init = f.apply(item, (class_1799)init);
                    }
                }
            }
        }
        for (class_1799 item : entity.method_56674()) {
            if (item.method_7960()) continue;
            init = f.apply(item, (class_1799)init);
        }
        return init;
    }

    @Override
    public boolean tryEquipInFirstSlot(class_1309 entity, class_1799 item) {
        if (TrinketsApi.getTrinketComponent((class_1309)entity).isPresent()) {
            TrinketComponent component = (TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)entity).get();
            for (Map map : component.getInventory().values()) {
                for (TrinketInventory inventory : map.values()) {
                    if (!TrinketSlot.canInsert((class_1799)item, (SlotReference)new SlotReference(inventory, 0), (class_1309)entity) || !inventory.method_5438(0).method_7960()) continue;
                    inventory.method_5447(0, item);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public AbilityToggles getAbilityToggles(class_1309 entity) {
        return (AbilityToggles)ModComponents.ABILITY_TOGGLES.getNullable((Object)entity);
    }

    @Override
    @Nullable
    public SwimData getSwimData(class_1309 entity) {
        return (SwimData)ModComponents.SWIM_DATA.getNullable((Object)entity);
    }

    @Override
    public class_6880<class_1320> getSwimSpeedAttribute() {
        return ModAttributesFabric.SWIM_SPEED;
    }

    @Override
    public class_6880<class_1320> registerAttribute(String name, class_1320 attribute) {
        return AttributesAccessor.invokeRegister(Artifacts.id(name).toString(), attribute);
    }

    @Override
    public void processWearableArtifactBuilder(WearableArtifactItem.Builder builder) {
        builder.properties(properties -> properties.method_57349(ModDataComponentsFabric.COSMETICS_ENABLED.get(), (Object)true));
    }

    @Override
    public void registerAdditionalDataComponents() {
        ModDataComponentsFabric.register();
    }

    @Override
    public void addCosmeticToggleTooltip(List<class_5250> tooltip, class_1799 stack) {
        if (CosmeticsHelper.areCosmeticsToggledOffByPlayer(stack)) {
            tooltip.add(class_2561.method_43471((String)"%s.tooltip.cosmetics_disabled".formatted("artifacts")).method_27692(class_124.field_1056));
        } else {
            tooltip.add(class_2561.method_43471((String)"%s.tooltip.cosmetics_enabled".formatted("artifacts")).method_27692(class_124.field_1056));
        }
    }

    @Override
    public boolean isEyeInWater(class_1657 player) {
        return player.method_5777(class_3486.field_15517);
    }

    @Override
    public boolean isVisibleOnHand(class_1309 entity, class_1268 hand, class_1792 item) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).stream().flatMap(component -> component.getAllEquipped().stream()).filter(tuple -> ((SlotReference)tuple.method_15442()).inventory().getSlotType().getGroup().equals(hand == class_1268.field_5808 ? "hand" : "offhand")).map(class_3545::method_15441).filter(stack -> stack.method_31574(item)).filter(stack -> !CosmeticsHelper.areCosmeticsToggledOffByPlayer(stack)).anyMatch(tuple -> true);
    }

    @Override
    public boolean areBootsHidden(class_1309 entity) {
        return false;
    }

    @Override
    public void registerArtifactRenderer(class_1792 item, Supplier<ArtifactRenderer> rendererSupplier) {
        TrinketRendererRegistry.registerRenderer((class_1792)item, (TrinketRenderer)new ArtifactTrinketRenderer(rendererSupplier.get()));
    }

    @Override
    @Nullable
    public ArtifactRenderer getArtifactRenderer(class_1792 item) {
        Object t;
        Optional renderer = TrinketRendererRegistry.getRenderer((class_1792)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof ArtifactTrinketRenderer) {
            ArtifactTrinketRenderer artifactTrinketRenderer = (ArtifactTrinketRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    @Override
    public Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    private record ArtifactTrinketRenderer(ArtifactRenderer renderer) implements TrinketRenderer
    {
        public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> entityModel, class_4587 poseStack, class_4597 multiBufferSource, int light, class_1309 entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (CosmeticsHelper.areCosmeticsToggledOffByPlayer(stack)) {
                return;
            }
            int index = slotReference.index() + (slotReference.inventory().getSlotType().getGroup().equals("hand") ? 0 : 1);
            this.renderer.render(stack, entity, index, poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

