/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.neoforge.services;

import com.natamus.collective_common_neoforge.services.helpers.TeleportHelper;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;

public class NeoForgeTeleportHelper
implements TeleportHelper {
    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ServerLevel serverLevel, PortalInfo portalInfo) {
        return entity.changeDimension(serverLevel, (ITeleporter)new SimpleTeleporter(portalInfo));
    }

    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ServerLevel serverLevel, Vec3 vec3) {
        return this.teleportEntity(entity, serverLevel, new PortalInfo(vec3, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot()));
    }

    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ServerLevel serverLevel, BlockPos blockPos) {
        return this.teleportEntity(entity, serverLevel, new Vec3((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5));
    }

    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ResourceKey<Level> targetDimension, Vec3 vec3) {
        if (entity.level().isClientSide) {
            return entity;
        }
        return this.teleportEntity(entity, entity.getServer().getLevel(targetDimension), new PortalInfo(vec3, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot()));
    }

    @Override
    public <T extends Entity> Entity teleportEntity(T entity, ResourceKey<Level> targetDimension, BlockPos blockPos) {
        return this.teleportEntity(entity, targetDimension, new Vec3((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5));
    }

    public record SimpleTeleporter(PortalInfo portalInfo) implements ITeleporter
    {
        public PortalInfo getPortalInfo(@NotNull Entity entity, @NotNull ServerLevel destinationServerLevel, @NotNull Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return this.portalInfo;
        }
    }
}

