/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.data.Constants;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GearFunctions {
    public static void setPlayerGearFromGearString(Player player, String gearString) {
        GearFunctions.setPlayerGearFromGearString(player, gearString, false);
    }

    public static void setPlayerGearFromGearString(Player player, String gearString, boolean parseActiveEffects) {
        Level level = player.level();
        Registry mobEffectRegistry = null;
        if (parseActiveEffects) {
            mobEffectRegistry = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT);
            player.removeAllEffects();
        }
        boolean emptiedInventory = false;
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            String slotString = GearFunctions.getSlotStringFromLine(line);
            if (slotString.equalsIgnoreCase("effects") && parseActiveEffects) {
                if (mobEffectRegistry == null) continue;
                List<MobEffectInstance> mobEffectInstanceList = GearFunctions.getEffectsFromLine((Registry<MobEffect>)mobEffectRegistry, line);
                for (MobEffectInstance mobEffectInstance : mobEffectInstanceList) {
                    player.addEffect(mobEffectInstance);
                }
                continue;
            }
            ItemStack itemStack = GearFunctions.getItemStackFromGearStringLine(level, line);
            if (itemStack == null || itemStack.isEmpty()) continue;
            if (!emptiedInventory) {
                player.getInventory().clearContent();
                emptiedInventory = true;
            }
            if (NumberFunctions.isNumeric(slotString)) {
                player.getInventory().setItem(Integer.parseInt(slotString), itemStack);
                continue;
            }
            EquipmentSlot equipmentSlot = GearFunctions.getEquipmentSlotFromSlotString(slotString);
            if (equipmentSlot == null) continue;
            player.setItemSlot(equipmentSlot, itemStack);
        }
    }

    public static void setInventoryFromGearString(Level level, Inventory inventory, String gearString) {
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            ItemStack itemStack = GearFunctions.getItemStackFromGearStringLine(level, line);
            if (itemStack == null || itemStack.isEmpty()) continue;
            String slotString = GearFunctions.getSlotStringFromLine(line);
            if (NumberFunctions.isNumeric(slotString)) {
                inventory.setItem(Integer.parseInt(slotString), itemStack);
                continue;
            }
            EquipmentSlot equipmentSlot = GearFunctions.getEquipmentSlotFromSlotString(slotString);
            if (equipmentSlot.equals((Object)EquipmentSlot.HEAD)) {
                inventory.armor.set(3, (Object)itemStack);
            }
            if (equipmentSlot.equals((Object)EquipmentSlot.CHEST)) {
                inventory.armor.set(2, (Object)itemStack);
            }
            if (equipmentSlot.equals((Object)EquipmentSlot.LEGS)) {
                inventory.armor.set(1, (Object)itemStack);
            }
            if (equipmentSlot.equals((Object)EquipmentSlot.FEET)) {
                inventory.armor.set(0, (Object)itemStack);
            }
            if (!equipmentSlot.equals((Object)EquipmentSlot.OFFHAND)) continue;
            inventory.offhand.set(0, (Object)itemStack);
        }
    }

    public static String getGearStringFromPlayer(Player player) {
        return GearFunctions.getGearStringFromPlayer(player, false);
    }

    public static String getGearStringFromPlayer(Player player, boolean parseActiveEffects) {
        Level level = player.level();
        StringBuilder gearStringBuilder = new StringBuilder();
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            if (!gearStringBuilder.isEmpty()) {
                gearStringBuilder.append("\n");
            }
            String equipmentSlotString = equipmentSlot.getName();
            ItemStack equipmentSlotStack = player.getItemBySlot(equipmentSlot);
            if (!equipmentSlotStack.isEmpty()) {
                String nbtString = GearFunctions.getFormattedNBTStringFromItemStack(level, equipmentSlotStack);
                gearStringBuilder.append("'").append(equipmentSlotString).append("'").append(" : ").append("'").append(nbtString).append("',");
                continue;
            }
            gearStringBuilder.append("'").append(equipmentSlotString).append("'").append(" : ").append("'',");
        }
        Inventory playerInventory = player.getInventory();
        for (int i = 0; i < 36; ++i) {
            ItemStack slotStack = playerInventory.getItem(i);
            if (!slotStack.isEmpty()) {
                String nbtString = GearFunctions.getFormattedNBTStringFromItemStack(level, slotStack);
                gearStringBuilder.append("\n").append(i).append(" : ").append("'").append(nbtString).append("',");
                continue;
            }
            gearStringBuilder.append("\n").append(i).append(" : '',");
        }
        if (parseActiveEffects) {
            StringBuilder effectsStringBuilder = new StringBuilder();
            Map activeEffectsMap = player.getActiveEffectsMap();
            if (activeEffectsMap.size() > 0) {
                Registry mobEffectRegistry = player.level().registryAccess().registryOrThrow(Registries.MOB_EFFECT);
                ArrayList<String> effectResourceLocationList = new ArrayList<String>();
                HashMap<String, CallSite> effectLineData = new HashMap<String, CallSite>();
                for (Holder mobEffectHolder : activeEffectsMap.keySet()) {
                    MobEffectInstance mobEffectInstance = (MobEffectInstance)activeEffectsMap.get(mobEffectHolder);
                    ResourceLocation resourceLocation = mobEffectRegistry.getKey((Object)((MobEffect)mobEffectHolder.value()));
                    if (resourceLocation == null) continue;
                    String rlString = resourceLocation.toString();
                    int amplifier = mobEffectInstance.getAmplifier() + 1;
                    int duration = mobEffectInstance.getDuration();
                    effectResourceLocationList.add(rlString);
                    effectLineData.put(rlString, (CallSite)((Object)(rlString + ";lvl:" + amplifier + ";duration:" + duration)));
                }
                Collections.sort(effectResourceLocationList);
                for (String rlString : effectResourceLocationList) {
                    String lineData = (String)effectLineData.get(rlString);
                    if (!effectsStringBuilder.toString().equals("")) {
                        effectsStringBuilder.append("|");
                    }
                    effectsStringBuilder.append(lineData);
                }
            }
            gearStringBuilder.append("\n'effects' : '").append((CharSequence)effectsStringBuilder).append("',");
        }
        return gearStringBuilder.toString();
    }

    public static String getPlayerGearStringFromHashMap(Level level, HashMap<String, ItemStack> gearStringHashMap) {
        StringBuilder gearStringBuilder = new StringBuilder();
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            if (!gearStringBuilder.isEmpty()) {
                gearStringBuilder.append("\n");
            }
            String equipmentSlotString = equipmentSlot.getName();
            String nbtString = "";
            if (gearStringHashMap.containsKey(equipmentSlotString)) {
                nbtString = GearFunctions.getFormattedNBTStringFromItemStack(level, gearStringHashMap.get(equipmentSlotString));
            }
            gearStringBuilder.append("'").append(equipmentSlotString).append("'").append(" : ").append("'").append(nbtString).append("',");
        }
        NonNullList emptyInventoryList = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        for (int i = 0; i < emptyInventoryList.size(); ++i) {
            String nbtString = "";
            if (gearStringHashMap.containsKey("" + i)) {
                nbtString = GearFunctions.getFormattedNBTStringFromItemStack(level, gearStringHashMap.get("" + i));
            }
            gearStringBuilder.append("\n").append(i).append(" : '").append(nbtString).append("',");
        }
        return gearStringBuilder.toString();
    }

    public static HashMap<String, ItemStack> getHashMapFromGearString(Level level, String gearString) {
        HashMap<String, ItemStack> gearHashMap = new HashMap<String, ItemStack>();
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            String slotString = GearFunctions.getSlotStringFromLine(line);
            ItemStack itemStack = GearFunctions.getItemStackFromGearStringLine(level, line);
            if (itemStack == null) {
                itemStack = ItemStack.EMPTY.copy();
            }
            gearHashMap.put(slotString, itemStack);
        }
        return gearHashMap;
    }

    public static List<ItemStack> getItemStackListFromGearString(Level level, String gearString) {
        ArrayList<ItemStack> gearList = new ArrayList<ItemStack>();
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            ItemStack itemStack = GearFunctions.getItemStackFromGearStringLine(level, line);
            if (itemStack == null) continue;
            gearList.add(itemStack);
        }
        return gearList;
    }

    public static List<MobEffectInstance> getEffectsFromGearString(Player player, String gearString) {
        return GearFunctions.getEffectsFromGearString(player.level(), gearString);
    }

    public static List<MobEffectInstance> getEffectsFromGearString(Level level, String gearString) {
        return GearFunctions.getEffectsFromGearString((Registry<MobEffect>)level.registryAccess().registryOrThrow(Registries.MOB_EFFECT), gearString);
    }

    public static List<MobEffectInstance> getEffectsFromGearString(Registry<MobEffect> mobEffectRegistry, String gearString) {
        for (String line : GearFunctions.getGearStringSplit(gearString)) {
            String slotString = GearFunctions.getSlotStringFromLine(line);
            if (!slotString.equalsIgnoreCase("effects")) continue;
            return GearFunctions.getEffectsFromLine(mobEffectRegistry, line);
        }
        return new ArrayList<MobEffectInstance>();
    }

    public static boolean areTwoGearStringsEqual(Level level, String gearStringOne, String gearStringTwo) {
        List<ItemStack> itemStackListOne = GearFunctions.getItemStackListFromGearString(level, gearStringOne);
        List<ItemStack> itemStackListTwo = GearFunctions.getItemStackListFromGearString(level, gearStringTwo);
        for (ItemStack itemStackOne : itemStackListOne) {
            Item itemOne = itemStackOne.getItem();
            boolean foundMatch = false;
            for (ItemStack itemStackTwo : itemStackListTwo) {
                Item itemTwo = itemStackTwo.getItem();
                if (!itemOne.equals(itemTwo) || itemStackOne.getCount() != itemStackTwo.getCount()) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    public static String sortGearString(String gearString) {
        String data;
        String slotString;
        StringBuilder sortedGearString = new StringBuilder();
        HashMap<String, String> gearHashMap = new HashMap<String, String>();
        for (String string : GearFunctions.getGearStringSplit(gearString)) {
            slotString = GearFunctions.getSlotStringFromLine(string);
            data = GearFunctions.getDataFromLine(string);
            gearHashMap.put(slotString, data);
        }
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            String equipmentSlotName = equipmentSlot.getName();
            if (!gearHashMap.containsKey(equipmentSlotName)) continue;
            sortedGearString.append("'").append(equipmentSlotName).append("' : '").append((String)gearHashMap.get(equipmentSlotName)).append("',").append(System.lineSeparator());
        }
        for (String string : GearFunctions.getGearStringSplit(gearString)) {
            slotString = GearFunctions.getSlotStringFromLine(string);
            data = GearFunctions.getDataFromLine(string);
            if (!NumberFunctions.isNumeric(slotString)) continue;
            sortedGearString.append("'").append(slotString).append("' : '").append(data).append("',").append(System.lineSeparator());
        }
        if (gearHashMap.containsKey("effects")) {
            sortedGearString.append("'effects' : '").append((String)gearHashMap.get("effects")).append("',").append(System.lineSeparator());
        }
        return sortedGearString.toString().strip();
    }

    private static ItemStack getItemStackFromGearStringLine(Level level, String line) {
        Optional optionalItemStack;
        CompoundTag compoundTag2;
        ItemStack itemStack = ItemStack.EMPTY;
        String[] stringArray = GearFunctions.getStringArrayFromLine(line);
        if (stringArray.length != 2) {
            return null;
        }
        String data = GearFunctions.getDataFromStringArray(stringArray);
        try {
            compoundTag2 = GearFunctions.parseFormattedTag(data);
            optionalItemStack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)compoundTag2);
            if (optionalItemStack.isPresent()) {
                itemStack = (ItemStack)optionalItemStack.get();
            }
        }
        catch (CommandSyntaxException compoundTag2) {
            // empty catch block
        }
        if (itemStack.isEmpty()) {
            try {
                data = GearFunctions.extendedFormatDataString(data);
                compoundTag2 = GearFunctions.parseFormattedTag(data);
                optionalItemStack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)compoundTag2);
                if (optionalItemStack.isPresent()) {
                    itemStack = (ItemStack)optionalItemStack.get();
                }
            }
            catch (CommandSyntaxException ex1) {
                return null;
            }
        }
        return itemStack.copy();
    }

    private static List<MobEffectInstance> getEffectsFromLine(Player player, String line) {
        return GearFunctions.getEffectsFromLine(player.level(), line);
    }

    private static List<MobEffectInstance> getEffectsFromLine(Level level, String line) {
        return GearFunctions.getEffectsFromLine((Registry<MobEffect>)level.registryAccess().registryOrThrow(Registries.MOB_EFFECT), line);
    }

    private static List<MobEffectInstance> getEffectsFromLine(Registry<MobEffect> mobEffectRegistry, String line) {
        ArrayList<MobEffectInstance> mobEffectInstanceList = new ArrayList<MobEffectInstance>();
        String effectData = GearFunctions.getDataFromLine(line);
        for (String effectRaw : effectData.split("\\|")) {
            int lvl;
            String[] effectSpl = effectRaw.split(";");
            if (effectSpl.length != 3) continue;
            String rlString = effectSpl[0];
            String lvlRaw = effectSpl[1];
            String durationRaw = effectSpl[2];
            if (!lvlRaw.contains(":") || !durationRaw.contains(":")) continue;
            String lvlString = lvlRaw.split(":")[1].strip();
            String durationString = durationRaw.split(":")[1].strip();
            if (!NumberFunctions.isNumeric(lvlString) || !NumberFunctions.isNumeric(durationString) || (lvl = Integer.parseInt(lvlString)) == 0) continue;
            int duration = Integer.parseInt(durationString);
            MobEffect mobEffect = (MobEffect)mobEffectRegistry.get(new ResourceLocation(rlString));
            if (mobEffect == null) continue;
            MobEffectInstance mobEffectInstance = new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)mobEffect), duration, lvl - 1);
            mobEffectInstanceList.add(mobEffectInstance);
        }
        return mobEffectInstanceList;
    }

    private static String[] getGearStringSplit(String gearString) {
        return gearString.split("',[\\r\\n]+");
    }

    private static String getSlotStringFromLine(String line) {
        return GearFunctions.getStringArrayFromLine(line)[0].replace("'", "").strip();
    }

    private static String getDataFromStringArray(String[] stringArray) {
        if (stringArray.length < 2) {
            return "";
        }
        String rawData = stringArray[1];
        if (rawData.startsWith("'")) {
            rawData = rawData.substring(1);
        }
        if (rawData.endsWith("'")) {
            rawData = rawData.substring(0, rawData.length() - 1);
        }
        return rawData.replaceAll("\r", "");
    }

    private static String[] getStringArrayFromLine(String line) {
        if (((String)(line = ((String)line).trim())).endsWith(",")) {
            line = ((String)line).substring(0, ((String)line).length() - 1);
        }
        if (!((String)line).endsWith("'")) {
            line = (String)line + "'";
        }
        return ((String)line).split(" : ", 2);
    }

    private static String getDataFromLine(String line) {
        return GearFunctions.getDataFromStringArray(GearFunctions.getStringArrayFromLine(line));
    }

    private static EquipmentSlot getEquipmentSlotFromSlotString(String slotString) {
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            if (!equipmentSlot.getName().equalsIgnoreCase(slotString.strip())) continue;
            return equipmentSlot;
        }
        return null;
    }

    private static String getFormattedNBTStringFromItemStack(Level level, ItemStack itemStack) {
        String nbtString = ItemFunctions.getNBTStringFromItemStack(level, itemStack);
        nbtString = nbtString.replaceAll("[\\r\\n]", "|n").replace("'", "\u2035");
        return nbtString;
    }

    private static CompoundTag parseFormattedTag(String data) throws CommandSyntaxException {
        data = data.replace("|n", "\n").replace("\u2035", "'");
        return TagParser.parseTag((String)data);
    }

    private static String extendedFormatDataString(String rawData) {
        return rawData.replace("\",\"", "|||,|||").replace(" \"", " '").replace("\" ", "' ").replace("|||,|||", "\",\"");
    }
}

