/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryWrapper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class StackHelper
implements IStackHelper {
    private final ISubtypeManager subtypeManager;

    public StackHelper(ISubtypeManager subtypeManager) {
        this.subtypeManager = subtypeManager;
    }

    @Override
    public boolean isEquivalent(@Nullable class_1799 lhs, @Nullable class_1799 rhs, UidContext context) {
        ErrorUtil.checkNotNull(context, "context");
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.method_7909() != rhs.method_7909()) {
            return false;
        }
        String keyLhs = this.getUniqueIdentifierForStack(lhs, context);
        String keyRhs = this.getUniqueIdentifierForStack(rhs, context);
        return keyLhs.equals(keyRhs);
    }

    @Override
    public String getUniqueIdentifierForStack(class_1799 stack, UidContext context) {
        Object result = StackHelper.getRegistryNameForStack(stack);
        String subtypeInfo = this.subtypeManager.getSubtypeInfo(stack, context);
        if (!subtypeInfo.isEmpty()) {
            result = (String)result + ":" + subtypeInfo;
        }
        return result;
    }

    public static String getRegistryNameForStack(class_1799 stack) {
        ErrorUtil.checkNotEmpty(stack, "stack");
        class_1792 item = stack.method_7909();
        return RegistryWrapper.getRegistry(class_7924.field_41197).getRegistryName(item).map(class_2960::toString).orElseThrow(() -> {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            return new IllegalStateException("Item has no registry name: " + stackInfo);
        });
    }
}

