/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.llamalad7.mixinextras.sugar.Local;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;appendAttributeModifiersTooltip(Ljava/util/function/Consumer;Lnet/minecraft/entity/player/PlayerEntity;)V", shift=At.Shift.BEFORE)}, method={"getTooltip"})
    private void getTooltip(class_1792.class_9635 context, class_1657 player, class_1836 tooltipType, CallbackInfoReturnable<List<class_2561>> info, @Local(ordinal=0) List<class_2561> list) {
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(comp -> {
            class_1799 self = (class_1799)this;
            boolean canEquipAnywhere = true;
            HashSet slots = Sets.newHashSet();
            HashMap modifiers = Maps.newHashMap();
            Multimap<class_6880<class_1320>, class_1322> defaultModifier = null;
            boolean allModifiersSame = true;
            int slotCount = 0;
            for (Map.Entry<String, Map<String, TrinketInventory>> group : comp.getInventory().entrySet()) {
                block1: for (Map.Entry<String, TrinketInventory> inventory : group.getValue().entrySet()) {
                    TrinketInventory trinketInventory = inventory.getValue();
                    SlotType slotType = trinketInventory.getSlotType();
                    ++slotCount;
                    boolean anywhereButHidden = false;
                    for (int i = 0; i < trinketInventory.method_5439(); ++i) {
                        SlotReference ref = new SlotReference(trinketInventory, i);
                        boolean res = TrinketsApi.evaluatePredicateSet(slotType.getTooltipPredicates(), self, ref, (class_1309)player);
                        boolean canInsert = TrinketSlot.canInsert(self, ref, (class_1309)player);
                        if (res && canInsert) {
                            boolean sameTranslationExists = false;
                            for (SlotType t : slots) {
                                if (!t.getTranslation().getString().equals(slotType.getTranslation().getString())) continue;
                                sameTranslationExists = true;
                                break;
                            }
                            if (!sameTranslationExists) {
                                slots.add(slotType);
                            }
                            Trinket trinket = TrinketsApi.getTrinket(self.method_7909());
                            Multimap<class_6880<class_1320>, class_1322> map = trinket.getModifiers(self, ref, (class_1309)player, SlotAttributes.getUuid(ref));
                            if (defaultModifier == null) {
                                defaultModifier = map;
                            } else if (allModifiersSame) {
                                allModifiersSame = this.areMapsEqual(defaultModifier, map);
                            }
                            boolean duplicate = false;
                            for (Map.Entry entry : modifiers.entrySet()) {
                                if (!((SlotType)entry.getKey()).getTranslation().getString().equals(slotType.getTranslation().getString()) || !this.areMapsEqual((Multimap<class_6880<class_1320>, class_1322>)((Multimap)entry.getValue()), map)) continue;
                                duplicate = true;
                                break;
                            }
                            if (duplicate) continue block1;
                            modifiers.put(slotType, map);
                            continue block1;
                        }
                        if (!canInsert) continue;
                        anywhereButHidden = true;
                    }
                    if (anywhereButHidden) continue;
                    canEquipAnywhere = false;
                }
            }
            if (!self.method_57826(class_9334.field_49638)) {
                if (canEquipAnywhere && slotCount > 1) {
                    list.add((class_2561)class_2561.method_43471((String)"trinkets.tooltip.slots.any").method_27692(class_124.field_1080));
                } else if (slots.size() > 1) {
                    list.add((class_2561)class_2561.method_43471((String)"trinkets.tooltip.slots.list").method_27692(class_124.field_1080));
                    for (SlotType type : slots) {
                        list.add((class_2561)type.getTranslation().method_27692(class_124.field_1078));
                    }
                } else if (slots.size() == 1) {
                    for (SlotType type : slots) {
                        list.add((class_2561)class_2561.method_43469((String)"trinkets.tooltip.slots.single", (Object[])new Object[]{type.getTranslation().method_27692(class_124.field_1078)}).method_27692(class_124.field_1080));
                    }
                }
            }
            if (!modifiers.isEmpty() && ((class_9285)self.method_57825(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2394()) {
                if (allModifiersSame) {
                    if (defaultModifier != null && !defaultModifier.isEmpty()) {
                        list.add((class_2561)class_2561.method_43471((String)"trinkets.tooltip.attributes.all").method_27692(class_124.field_1080));
                        this.addAttributes(list, defaultModifier);
                    }
                } else {
                    for (SlotType type : modifiers.keySet()) {
                        list.add((class_2561)class_2561.method_43469((String)"trinkets.tooltip.attributes.single", (Object[])new Object[]{type.getTranslation().method_27692(class_124.field_1078)}).method_27692(class_124.field_1080));
                        this.addAttributes(list, (Multimap<class_6880<class_1320>, class_1322>)((Multimap)modifiers.get(type)));
                    }
                }
            }
        });
    }

    @Unique
    private void addAttributes(List<class_2561> list, Multimap<class_6880<class_1320>, class_1322> map) {
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entries()) {
                class_6880 attribute = (class_6880)entry.getKey();
                class_1322 modifier = (class_1322)entry.getValue();
                double g = modifier.comp_2449();
                if (modifier.comp_2450() != class_1322.class_1323.field_6330 && modifier.comp_2450() != class_1322.class_1323.field_6331) {
                    if (((class_6880)entry.getKey()).equals((Object)class_5134.field_23718)) {
                        g *= 10.0;
                    }
                } else {
                    g *= 100.0;
                }
                class_5250 text = class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830());
                if (attribute.method_40227() && attribute.comp_349() instanceof SlotAttributes.SlotEntityAttribute) {
                    text = class_2561.method_43469((String)"trinkets.tooltip.attributes.slots", (Object[])new Object[]{text});
                }
                if (g > 0.0) {
                    list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(g), text}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(g < 0.0)) continue;
                list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(g *= -1.0), text}).method_27692(class_124.field_1061));
            }
        }
    }

    @Unique
    private boolean areMapsEqual(Multimap<class_6880<class_1320>, class_1322> map1, Multimap<class_6880<class_1320>, class_1322> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (class_6880 attribute : map1.keySet()) {
            if (!map2.containsKey((Object)attribute)) {
                return false;
            }
            Collection col1 = map1.get((Object)attribute);
            Collection col2 = map2.get((Object)attribute);
            if (col1.size() != col2.size()) {
                return false;
            }
            Iterator iter = col2.iterator();
            for (class_1322 modifier : col1) {
                class_1322 eam = (class_1322)iter.next();
                if (modifier.method_26860().equals((Object)eam.method_26860())) continue;
                return false;
            }
        }
        return true;
    }
}

