/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.gui;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.client.gui.widget.WCardButton;
import com.b1n_ry.yigd.client.gui.widget.WFilterableListPanel;
import com.b1n_ry.yigd.client.gui.widget.WHoverToggleButton;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.networking.ClientPacketHandler;
import com.b1n_ry.yigd.networking.LightGraveData;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.ItemIcon;
import io.github.cottonmc.cotton.gui.widget.icon.TextureIcon;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_9296;

public class GraveSelectionGui
extends LightweightGuiDescription {
    private final List<LightGraveData> data;
    private final class_437 previousScreen;

    public GraveSelectionGui(List<LightGraveData> data, class_9296 profile, class_437 previousScreen) {
        this.data = data;
        this.previousScreen = previousScreen;
        WGridPanel root = new WGridPanel();
        this.setRootPanel((WPanel)root);
        root.setInsets(Insets.ROOT_PANEL);
        root.setGaps(2, 5);
        WLabel title = new WLabel((class_2561)class_2561.method_43469((String)"text.yigd.gui.graves_of", (Object[])new Object[]{profile.comp_2410().orElse("PLAYER_NOT_FOUND")}));
        root.add((WWidget)title, 0, 0);
        WFilterableListPanel<LightGraveData, WCardButton> listPanel = this.addGraveList(root);
        this.addFilterButtons(root, listPanel);
        root.validate((GuiDescription)this);
    }

    private WFilterableListPanel<LightGraveData, WCardButton> addGraveList(WGridPanel root) {
        ItemIcon icon = new ItemIcon(Yigd.GRAVE_BLOCK.method_8389());
        WFilterableListPanel<LightGraveData, WCardButton> listPanel = new WFilterableListPanel<LightGraveData, WCardButton>(this.data, () -> new WCardButton((Icon)icon), (lightGraveData, wCardButton) -> {
            wCardButton.setCardText(lightGraveData.deathMessage());
            wCardButton.setOverlayColor(lightGraveData.status().getTransparentColor());
            class_2338 gravePos = lightGraveData.pos();
            String dimensionName = lightGraveData.registryKey().method_29177().toString();
            wCardButton.setTooltipText(List.of(class_2561.method_43469((String)"text.yigd.gui.grave_location", (Object[])new Object[]{gravePos.method_10263(), gravePos.method_10264(), gravePos.method_10260()}), class_2561.method_48321((String)("text.yigd.dimension.name." + dimensionName), (String)dimensionName), class_2561.method_43469((String)"text.yigd.gui.item_count", (Object[])new Object[]{lightGraveData.itemCount()}), class_2561.method_43469((String)"text.yigd.gui.level_count", (Object[])new Object[]{lightGraveData.xpPoints()})));
            wCardButton.setOnClick(() -> ClientPacketHandler.sendGraveOverviewRequest(lightGraveData.id()));
        });
        root.add(listPanel, 0, 1, 12, 6);
        return listPanel;
    }

    private void addFilterButtons(WGridPanel root, WFilterableListPanel<LightGraveData, WCardButton> filterableList) {
        WHoverToggleButton viewClaimed = this.addToggleButton(new class_2960("yigd", "textures/gui/claimed_grave.png"), "button.yigd.gui.viewing_claimed", new class_2960("yigd", "textures/gui/claimed_grave_cross.png"), "button.yigd.gui.hiding_claimed");
        WHoverToggleButton viewUnclaimed = this.addToggleButton(new class_2960("yigd", "textures/gui/unclaimed_grave.png"), "button.yigd.gui.viewing_unclaimed", new class_2960("yigd", "textures/gui/unclaimed_grave_cross.png"), "button.yigd.gui.hiding_unclaimed");
        WHoverToggleButton viewDestroyed = this.addToggleButton(new class_2960("yigd", "textures/gui/destroyed_grave.png"), "button.yigd.gui.viewing_destroyed", new class_2960("yigd", "textures/gui/destroyed_grave_cross.png"), "button.yigd.gui.hiding_destroyed");
        WHoverToggleButton showStatus = this.addToggleButton(new class_2960("yigd", "textures/gui/show_status.png"), "button.yigd.gui.showing_status", new class_2960("yigd", "textures/gui/hide_status.png"), "button.yigd.gui.hiding_status");
        viewClaimed.setOnToggle(aBoolean -> filterableList.setFilter("claimed", graveData -> graveData.status() == GraveStatus.CLAIMED && aBoolean != false));
        viewUnclaimed.setOnToggle(aBoolean -> filterableList.setFilter("unclaimed", graveData -> graveData.status() == GraveStatus.UNCLAIMED && aBoolean != false));
        viewDestroyed.setOnToggle(aBoolean -> filterableList.setFilter("destroyed", graveData -> graveData.status() == GraveStatus.DESTROYED && aBoolean != false));
        showStatus.setOnToggle(aBoolean -> {
            for (WCardButton card : filterableList.getWidgets()) {
                card.setColoredRendering((boolean)aBoolean);
            }
        });
        viewClaimed.setToggle(false);
        viewUnclaimed.setToggle(true);
        viewDestroyed.setToggle(false);
        showStatus.setToggle(false);
        root.add((WWidget)viewClaimed, 12, 1);
        root.add((WWidget)viewUnclaimed, 12, 2);
        root.add((WWidget)viewDestroyed, 12, 3);
        root.add((WWidget)showStatus, 12, 4);
    }

    private WHoverToggleButton addToggleButton(class_2960 stateOnImg, String stateOnTranslationKey, class_2960 stateOffImg, String stateOffTranslationKey) {
        TextureIcon onIcon = new TextureIcon(stateOnImg);
        TextureIcon offIcon = new TextureIcon(stateOffImg);
        class_5250 stateOnText = class_2561.method_43471((String)stateOnTranslationKey);
        class_5250 stateOffText = class_2561.method_43471((String)stateOffTranslationKey);
        return new WHoverToggleButton((Icon)onIcon, (class_2561)stateOnText, (Icon)offIcon, (class_2561)stateOffText);
    }

    public class_437 getPreviousScreen() {
        return this.previousScreen;
    }
}

