/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.events;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.components.RespawnComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.events.BeforeSoulboundEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_9296;

public class ServerEventHandler {
    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            DeathInfoManager.INSTANCE.clear();
            class_3218 overworld = server.method_30002();
            DeathInfoManager.INSTANCE = (DeathInfoManager)overworld.method_17983().method_17924(DeathInfoManager.getPersistentStateType(server), "yigd_data");
            DeathInfoManager.INSTANCE.method_80();
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (alive) {
                return;
            }
            ((BeforeSoulboundEvent)BeforeSoulboundEvent.EVENT.invoker()).beforeSoulbound(oldPlayer, newPlayer);
            class_9296 newProfile = new class_9296(newPlayer.method_7334());
            Optional<RespawnComponent> respawnComponent = DeathInfoManager.INSTANCE.getRespawnComponent(newProfile);
            respawnComponent.ifPresent(component -> component.apply(newPlayer));
            if (YigdConfig.getConfig().graveConfig.informGraveLocation && respawnComponent.isPresent() && respawnComponent.get().wasGraveGenerated()) {
                ArrayList<GraveComponent> graves = new ArrayList<GraveComponent>(DeathInfoManager.INSTANCE.getBackupData(newProfile));
                graves.removeIf(grave -> grave.getStatus() != GraveStatus.UNCLAIMED);
                if (!graves.isEmpty()) {
                    GraveComponent latest = (GraveComponent)graves.getLast();
                    class_2338 gravePos = latest.getPos();
                    newPlayer.method_43496((class_2561)class_2561.method_43469((String)"text.yigd.message.grave_location", (Object[])new Object[]{gravePos.method_10263(), gravePos.method_10264(), gravePos.method_10260(), latest.getWorldRegistryKey().method_29177().toString()}));
                }
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList<Runnable> tickFunctions = new ArrayList<Runnable>(Yigd.END_OF_TICK);
            Yigd.END_OF_TICK.clear();
            for (Runnable function : tickFunctions) {
                function.run();
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            YigdConfig config = YigdConfig.getConfig();
            if (!config.graveConfig.sellOutOfflinePeople) {
                return;
            }
            class_9296 loggedOffProfile = new class_9296(handler.field_14140.method_7334());
            List<GraveComponent> loggedOffGraves = DeathInfoManager.INSTANCE.getBackupData(loggedOffProfile);
            ArrayList<GraveComponent> loggedOffUnclaimed = new ArrayList<GraveComponent>(loggedOffGraves);
            loggedOffGraves.removeIf(c -> c.getStatus() == GraveStatus.UNCLAIMED);
            if (!loggedOffUnclaimed.isEmpty()) {
                GraveComponent component = (GraveComponent)loggedOffUnclaimed.getFirst();
                class_2338 lastGravePos = component.getPos();
                server.method_43496((class_2561)class_2561.method_43469((String)"text.yigd.message.sellout_player", (Object[])new Object[]{loggedOffProfile.comp_2410().orElse("PLAYER_NOT_FOUND"), lastGravePos.method_10263(), lastGravePos.method_10264(), lastGravePos.method_10260(), component.getWorldRegistryKey().method_29177().toString()}));
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            YigdConfig.GraveConfig.GraveRobbing robConfig = YigdConfig.getConfig().graveConfig.graveRobbing;
            UUID joiningId = handler.field_14140.method_5667();
            if (!Yigd.NOT_NOTIFIED_ROBBERIES.containsKey(joiningId)) {
                return;
            }
            if (robConfig.tellWhoRobbed) {
                List<String> robbedBy = Yigd.NOT_NOTIFIED_ROBBERIES.remove(joiningId);
                for (String robber : robbedBy) {
                    handler.field_14140.method_43496((class_2561)class_2561.method_43469((String)"text.yigd.message.inform_robbery.with_details", (Object[])new Object[]{robber}));
                }
            } else {
                Yigd.NOT_NOTIFIED_ROBBERIES.remove(joiningId);
                handler.field_14140.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.message.inform_robbery"));
            }
        });
    }
}

