/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.block.JNEBlockEntityType;
import net.jadenxgamer.netherexp.registry.block.custom.TreacherousCandleBlock;
import net.jadenxgamer.netherexp.registry.effect.JNEMobEffects;
import net.jadenxgamer.netherexp.registry.entity.ai.AttackTreacherousCandleGoal;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.class_1259;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class TreacherousCandleBlockEntity
extends class_2586 {
    private int fireRewarded = 1;
    private int maximumWaves = 5;
    private int currentWave = 1;
    private int maximumWaveDelay = 650;
    private int currentWaveDelay = 80;
    private int spawnRadius = 8;
    private int mobsPerWave = 4;
    private int resetMobsPerWave = 4;
    private int increaseInMobsPerWave = 2;
    private int health = 20;
    private int maximumHealth = 20;
    private int completionCooldown = JNEConfigs.TREACHEROUS_CANDLE_COMPLETION_COOLDOWN.get() * 20;
    private int playersNearby = 1;
    private List<class_1299<?>> spawnableMobs = new ArrayList();
    private final class_3213 bossEvent = (class_3213)new class_3213((class_2561)class_2561.method_43471((String)"treacherous_candle.health"), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795).method_5406(false);

    public TreacherousCandleBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)JNEBlockEntityType.TREACHEROUS_CANDLE.get(), pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.fireRewarded = nbt.method_10550("FireRewarded");
        this.maximumWaves = nbt.method_10550("MaximumWaves");
        this.currentWave = nbt.method_10550("CurrentWave");
        this.maximumWaveDelay = nbt.method_10550("MaximumWaveDelay");
        this.currentWaveDelay = nbt.method_10550("CurrentWaveDelay");
        this.spawnRadius = nbt.method_10550("SpawnRadius");
        this.mobsPerWave = nbt.method_10550("MobsPerWave");
        this.resetMobsPerWave = nbt.method_10550("ResetMobsPerWave");
        this.increaseInMobsPerWave = nbt.method_10550("IncreaseInMobsPerWave");
        this.health = nbt.method_10550("Health");
        this.maximumHealth = nbt.method_10550("MaximumHealth");
        this.completionCooldown = nbt.method_10550("CompletionCooldown");
        this.playersNearby = nbt.method_10550("PlayersNearby");
        this.spawnableMobs.clear();
        class_2499 mobsListTag = nbt.method_10554("SpawnableMobs", 8);
        for (int i = 0; i < mobsListTag.size(); ++i) {
            String mobTypeString = mobsListTag.method_10608(i);
            class_1299.method_5898((String)mobTypeString).ifPresent(entityType -> this.spawnableMobs.add((class_1299<?>)entityType));
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("FireRewarded", this.fireRewarded);
        nbt.method_10569("MaximumWaves", this.maximumWaves);
        nbt.method_10569("CurrentWave", this.currentWave);
        nbt.method_10569("MaximumWaveDelay", this.maximumWaveDelay);
        nbt.method_10569("CurrentWaveDelay", this.currentWaveDelay);
        nbt.method_10569("MobsPerWave", this.mobsPerWave);
        nbt.method_10569("ResetMobsPerWave", this.resetMobsPerWave);
        nbt.method_10569("IncreaseInMobsPerWave", this.increaseInMobsPerWave);
        nbt.method_10569("SpawnRadius", this.spawnRadius);
        nbt.method_10569("Health", this.health);
        nbt.method_10569("MaximumHealth", this.maximumHealth);
        nbt.method_10569("CompletionCooldown", this.completionCooldown);
        nbt.method_10569("PlayersNearby", this.playersNearby);
        class_2499 mobsListTag = new class_2499();
        for (class_1299<?> entityType : this.spawnableMobs) {
            mobsListTag.add((Object)class_2519.method_23256((String)class_1299.method_5890(entityType).toString()));
        }
        nbt.method_10566("SpawnableMobs", (class_2520)mobsListTag);
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TreacherousCandleBlockEntity blockEntity) {
        boolean isCompleted = (Boolean)state.method_11654((class_2769)TreacherousCandleBlock.COMPLETED);
        boolean isLit = (Boolean)state.method_11654((class_2769)TreacherousCandleBlock.LIT);
        if (isCompleted) {
            --blockEntity.completionCooldown;
            TreacherousCandleBlockEntity.clearBossBarPlayers(blockEntity);
            if (blockEntity.completionCooldown <= 0) {
                TreacherousCandleBlockEntity.resetValues(blockEntity);
                level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)TreacherousCandleBlock.COMPLETED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TreacherousCandleBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
                level.method_8396(null, pos, class_3417.field_15102, class_3419.field_15248, 0.5f, 1.0f);
            }
            return;
        }
        if (isLit) {
            TreacherousCandleBlockEntity.updateHealth(blockEntity);
            List<class_3222> playersInRadius = TreacherousCandleBlockEntity.getPlayersInRadius(level, pos);
            TreacherousCandleBlockEntity.updateBossBarPlayers(blockEntity, playersInRadius, level);
            --blockEntity.currentWaveDelay;
            if (blockEntity.currentWave <= blockEntity.maximumWaves) {
                TreacherousCandleBlockEntity.prepareWaves(level, pos, blockEntity);
            } else if (blockEntity.currentWaveDelay <= 0) {
                TreacherousCandleBlockEntity.dropFire(level, pos.method_10084(), blockEntity);
                level.method_8396(null, pos, (class_3414)JNESoundEvents.TREACHEROUS_CANDLE_VICTORY.get(), class_3419.field_15248, 1.0f, 1.0f);
                level.method_8652(pos, (class_2680)state.method_28493((class_2769)TreacherousCandleBlock.COMPLETED), 2);
            }
            return;
        }
        TreacherousCandleBlockEntity.clearBossBarPlayers(blockEntity);
    }

    private static void clearBossBarPlayers(TreacherousCandleBlockEntity blockEntity) {
        ArrayList playersToRemove = new ArrayList(blockEntity.bossEvent.method_14092());
        for (class_3222 player : playersToRemove) {
            blockEntity.bossEvent.method_14089(player);
        }
    }

    private static void updateHealth(TreacherousCandleBlockEntity blockEntity) {
        blockEntity.bossEvent.method_5408((float)blockEntity.health / (float)blockEntity.maximumHealth);
    }

    private static List<class_3222> getPlayersInRadius(class_1937 level, class_2338 pos) {
        return level.method_18467(class_3222.class, new class_238(pos).method_1009(16.0, 16.0, 16.0));
    }

    private static void updateBossBarPlayers(TreacherousCandleBlockEntity blockEntity, List<class_3222> playersInRadius, class_1937 level) {
        for (class_3222 player : playersInRadius) {
            if (!player.method_5805() || player.method_37908() != level) continue;
            player.method_6092(new class_1293((class_1291)JNEMobEffects.BETRAYED.get(), 200, 0));
            if (blockEntity.bossEvent.method_14092().contains(player)) continue;
            blockEntity.bossEvent.method_14088(player);
        }
        ArrayList playersToRemove = new ArrayList(blockEntity.bossEvent.method_14092());
        for (class_3222 player : playersToRemove) {
            if (playersInRadius.contains(player) && player.method_5805() && player.method_37908() == level) continue;
            blockEntity.bossEvent.method_14089(player);
        }
    }

    private static void prepareWaves(class_1937 level, class_2338 pos, TreacherousCandleBlockEntity blockEntity) {
        if (blockEntity.currentWaveDelay == 40) {
            level.method_8396(null, pos, class_3417.field_15203, class_3419.field_15245, 0.5f, 0.6f);
        }
        if (blockEntity.currentWaveDelay == 1) {
            level.method_8406((class_2394)JNEParticleTypes.CANDLE_BURST.get(), (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 0.0, 0.0, 0.0);
        }
        if (blockEntity.currentWaveDelay <= 0) {
            ++blockEntity.currentWave;
            blockEntity.spawnWave(level, pos);
            blockEntity.mobsPerWave += blockEntity.increaseInMobsPerWave;
            blockEntity.currentWaveDelay = blockEntity.maximumWaveDelay;
        }
    }

    private static void dropFire(class_1937 level, class_2338 pos, TreacherousCandleBlockEntity blockEntity) {
        class_1542 item = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, new class_1799((class_1935)JNEItems.TREACHEROUS_FLAME.get(), blockEntity.fireRewarded * blockEntity.playersNearby));
        item.method_18800(0.0, 0.2, 0.0);
        item.method_5834(true);
        level.method_8649((class_1297)item);
        level.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15013, class_3419.field_15245, 1.0f, 1.0f);
    }

    public static void resetValues(TreacherousCandleBlockEntity blockEntity) {
        blockEntity.completionCooldown = JNEConfigs.TREACHEROUS_CANDLE_COMPLETION_COOLDOWN.get() * 20;
        blockEntity.currentWave = 1;
        blockEntity.health = blockEntity.maximumHealth;
        blockEntity.mobsPerWave = blockEntity.resetMobsPerWave;
        blockEntity.currentWaveDelay = 80;
        blockEntity.playersNearby = 1;
    }

    public static void findAllNearbyPlayers(TreacherousCandleBlockEntity blockEntity, class_2338 pos, class_1937 level) {
        if (level != null) {
            List nearbyPlayers = level.method_18467(class_1657.class, new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1009(16.0, 16.0, 16.0));
            blockEntity.playersNearby = nearbyPlayers.size();
        }
    }

    private void spawnWave(class_1937 level, class_2338 pos) {
        class_5819 random = level.field_9229;
        if (!this.spawnableMobs.isEmpty()) {
            int bonusSpawns = this.playersNearby > 1 ? this.playersNearby : 0;
            for (int i = 0; i < this.mobsPerWave + bonusSpawns; ++i) {
                class_1314 pathfinder;
                class_2338 spawnPos = this.findValidSpawnPosition(level, pos, random);
                class_1299<?> entityType = this.spawnableMobs.get(random.method_43048(this.spawnableMobs.size()));
                class_1308 mob = (class_1308)entityType.method_5883(level);
                if (mob == null) continue;
                level.method_43128(null, (double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260(), class_3417.field_15013, class_3419.field_15248, 0.3f, 1.0f);
                if (!(level instanceof class_3218)) continue;
                class_3218 serverLevel = (class_3218)level;
                mob.method_5814((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260());
                mob.method_5943((class_5425)serverLevel, level.method_8404(pos), class_3730.field_16471, null, null);
                if (mob instanceof class_1621) {
                    class_1621 slime = (class_1621)mob;
                    slime.method_7161(2, true);
                }
                if (mob instanceof class_1314 && !(pathfinder = (class_1314)mob).method_5864().method_20210(JNETags.EntityTypes.IGNORES_TREACHEROUS_CANDLE)) {
                    mob.field_6185.method_6277(2, (class_1352)new AttackTreacherousCandleGoal(pathfinder, 32));
                }
                level.method_8649((class_1297)mob);
            }
        }
    }

    private class_2338 findValidSpawnPosition(class_1937 level, class_2338 pos, class_5819 random) {
        double x = pos.method_10263() + random.method_43048(this.spawnRadius);
        double y = pos.method_10264();
        double z = pos.method_10260() + random.method_43048(this.spawnRadius);
        class_2338 currentPos = new class_2338((int)x, (int)y, (int)z);
        for (int retries = 0; retries < 10; ++retries) {
            if (level.method_8320(currentPos).method_26215()) {
                return currentPos;
            }
            currentPos = new class_2338((int)x, (int)(y += 1.0), (int)z);
        }
        return currentPos;
    }

    public void method_11012() {
        super.method_11012();
        assert (this.field_11863 != null);
        if (!this.field_11863.method_8608() && this.bossEvent != null) {
            ArrayList playersToRemove = new ArrayList(this.bossEvent.method_14092());
            for (class_3222 player : playersToRemove) {
                this.bossEvent.method_14089(player);
            }
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }
}

