/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.Objects;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.GrenadeEffectCloud;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3856;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ThrownAntidote
extends class_3857
implements class_3856 {
    private static final class_2940<Boolean> IS_STUCK = class_2945.method_12791(ThrownAntidote.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> TICK_COUNTER = class_2945.method_12791(ThrownAntidote.class, (class_2941)class_2943.field_13327);

    public ThrownAntidote(class_1299<? extends class_3857> entityType, class_1937 level) {
        super(entityType, level);
    }

    public ThrownAntidote(class_1937 level, class_1309 livingEntity) {
        super((class_1299)JNEEntityType.ANTIDOTE.get(), livingEntity, level);
    }

    public void method_5773() {
        super.method_5773();
        if (this.getIsStuck()) {
            int tick = this.getTickCounter();
            this.setTickCounter(tick + 1);
            class_1799 stack = this.method_7495();
            class_1291 mobEffect = ThrownAntidote.getAntidoteEffect(stack);
            if (tick % 10 == 0) {
                if (this.method_37908().field_9236) {
                    if (mobEffect != null) {
                        this.playPotionParticles(mobEffect);
                    } else {
                        this.method_37908().method_8406((class_2394)class_2398.field_11241, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, (double)0.2f, 0.0);
                    }
                }
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)JNESoundEvents.GRENADE_ANTIDOTE_TICK.get(), class_3419.field_15254, 1.0f, 0.75f + (float)tick / 20.0f);
            } else if (tick > 40) {
                assert (stack.method_7969() != null);
                if (stack.method_7969().method_10545("Antidote")) {
                    this.applyGrenade(stack);
                }
                this.method_31472();
                if (mobEffect != null) {
                    this.playPotionParticles(mobEffect);
                } else {
                    this.method_37908().method_8406((class_2394)class_2398.field_11241, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, (double)0.2f, 0.0);
                }
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_3414)JNESoundEvents.GRENADE_ANTIDOTE_EXPLODE.get(), class_3419.field_15254, 1.0f, 1.0f);
            }
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.method_37908().field_9236) {
            this.method_18800(0.0, 0.0, 0.0);
            this.method_5875(true);
            this.method_5841().method_12778(IS_STUCK, (Object)true);
        }
    }

    private void applyGrenade(class_1799 stack) {
        GrenadeEffectCloud grenadeEffectCloud = new GrenadeEffectCloud(this.method_37908(), this.method_23317() - 2.0, this.method_23318(), this.method_23321());
        class_1297 entity = this.method_24921();
        class_2487 nbt = stack.method_7969();
        if (entity instanceof class_1309) {
            grenadeEffectCloud.setOwnerUUID((class_1309)entity);
        }
        grenadeEffectCloud.setMobEffect(ThrownAntidote.getAntidoteEffect(stack));
        grenadeEffectCloud.setEffectDuration(ThrownAntidote.getDuration(stack));
        if (nbt != null) {
            if (nbt.method_10545("Inactive")) {
                grenadeEffectCloud.setInactive(nbt.method_10577("Inactive"));
            } else {
                grenadeEffectCloud.setInactive(false);
            }
            if (nbt.method_10573("CustomAntidoteColor", 99)) {
                grenadeEffectCloud.setColor(nbt.method_10550("CustomPotionColor"));
            } else {
                grenadeEffectCloud.setColor(Objects.requireNonNull(ThrownAntidote.getAntidoteEffect(stack)).method_5556());
            }
        }
        this.method_37908().method_8649((class_1297)grenadeEffectCloud);
    }

    private void playPotionParticles(class_1291 mobEffect) {
        int c = mobEffect.method_5556();
        if (c > 0) {
            double d0 = (double)(c >> 16 & 0xFF) / 255.0;
            double d1 = (double)(c >> 8 & 0xFF) / 255.0;
            double d2 = (double)(c & 0xFF) / 255.0;
            for (int i = 0; i < 3; ++i) {
                this.method_37908().method_8406((class_2394)JNEParticleTypes.IMMUNITY_EFFECT.get(), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d0, d1, d2);
            }
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(IS_STUCK, (Object)false);
        this.method_5841().method_12784(TICK_COUNTER, (Object)0);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("isStuck")) {
            this.setIsStuck(nbt.method_10577("isStuck"));
        }
        if (nbt.method_10545("TickCounter")) {
            this.setTickCounter(nbt.method_10550("TickCounter"));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("isStuck", this.getIsStuck());
        nbt.method_10569("TickCounter", this.getTickCounter());
    }

    private int getTickCounter() {
        return (Integer)this.method_5841().method_12789(TICK_COUNTER);
    }

    private void setTickCounter(int i) {
        this.method_5841().method_12778(TICK_COUNTER, (Object)i);
    }

    private boolean getIsStuck() {
        return (Boolean)this.method_5841().method_12789(IS_STUCK);
    }

    private void setIsStuck(boolean bl) {
        this.method_5841().method_12778(IS_STUCK, (Object)bl);
    }

    private static class_1291 getAntidoteEffect(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("AntidoteEffect") || Objects.equals(nbt.method_10558("Antidote"), "Awkward")) {
            return null;
        }
        class_2960 antidoteLocation = new class_2960(stack.method_7948().method_10558("AntidoteEffect"));
        return Objects.requireNonNull((class_1291)class_7923.field_41174.method_10223(antidoteLocation));
    }

    public static int getDuration(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("Duration")) {
            return nbt.method_10550("Duration") * 20;
        }
        return 36000;
    }

    @NotNull
    protected class_1792 method_16942() {
        return (class_1792)JNEItems.GRENADE_ANTIDOTE.get();
    }

    protected float method_7490() {
        return 0.05f;
    }
}

