/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.feature.custom;

import com.mojang.serialization.Codec;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_4780;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class WarpedFungusFeature
extends class_3031<class_4780> {
    public WarpedFungusFeature(Codec<class_4780> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_4780> context) {
        class_5281 worldGenLevel = context.method_33652();
        class_2338 originPos = context.method_33655();
        class_5819 random = context.method_33654();
        class_2794 chunkGenerator = context.method_33653();
        class_4780 config = (class_4780)context.method_33656();
        class_2248 baseBlock = config.field_22435.method_26204();
        class_2338 placePos = null;
        class_2680 baseBlockState = worldGenLevel.method_8320(originPos.method_10074());
        if (baseBlockState.method_27852(baseBlock)) {
            placePos = originPos;
        }
        if (placePos == null) {
            return false;
        }
        int height = class_3532.method_15395((class_5819)random, (int)9, (int)13);
        if (random.method_43048(12) == 0) {
            height *= 2;
        }
        if (!config.field_22194) {
            int maxGenDepth = chunkGenerator.method_12104();
            if (placePos.method_10264() + height + 1 >= maxGenDepth) {
                return false;
            }
        }
        boolean largeStem = !config.field_22194 && random.method_43057() < 0.06f;
        worldGenLevel.method_8652(originPos, class_2246.field_10124.method_9564(), 4);
        this.placeStem(worldGenLevel, random, config, placePos, height, largeStem);
        this.placeHat(worldGenLevel, random, config, placePos, height, largeStem);
        return true;
    }

    private static boolean isReplaceable(class_5281 level, class_2338 pos, class_4780 config, boolean checkReplaceableBlocks) {
        if (level.method_16358(pos, class_4970.class_4971::method_45474)) {
            return true;
        }
        return checkReplaceableBlocks && config.field_44709.test((Object)level, (Object)pos);
    }

    private void placeStem(class_5281 level, class_5819 random, class_4780 config, class_2338 pos, int height, boolean largeStem) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_2680 stemState = config.field_22191;
        int stemRadius = largeStem ? 1 : 0;
        for (int x = -stemRadius; x <= stemRadius; ++x) {
            for (int z = -stemRadius; z <= stemRadius; ++z) {
                boolean isCorner = largeStem && class_3532.method_15382((int)x) == stemRadius && class_3532.method_15382((int)z) == stemRadius;
                for (int y = 0; y < height; ++y) {
                    mutableBlockPos.method_25504((class_2382)pos, x, y, z);
                    if (!WarpedFungusFeature.isReplaceable(level, (class_2338)mutableBlockPos, config, true)) continue;
                    if (config.field_22194) {
                        if (!level.method_8320(mutableBlockPos.method_10074()).method_26215()) {
                            level.method_22352((class_2338)mutableBlockPos, true);
                        }
                        level.method_8652((class_2338)mutableBlockPos, stemState, 3);
                        continue;
                    }
                    if (isCorner) {
                        if (!(random.method_43057() < 0.1f)) continue;
                        this.method_13153((class_1945)level, (class_2338)mutableBlockPos, stemState);
                        continue;
                    }
                    this.method_13153((class_1945)level, (class_2338)mutableBlockPos, stemState);
                }
            }
        }
    }

    private void placeHat(class_5281 level, class_5819 random, class_4780 config, class_2338 pos, int height, boolean largeStem) {
        int stemHeight;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        boolean beardValid = config.field_22192.method_26164(JNETags.Blocks.WART_BEARD_FEATURE_VALID);
        int hatHeight = Math.min(random.method_43048(1 + height / 3) + 5, height);
        for (int y = stemHeight = height - hatHeight; y <= height; ++y) {
            int hatRadius;
            int n = hatRadius = y < height - random.method_43048(3) ? 2 : 1;
            if (hatHeight > 8 && y < stemHeight + 4) {
                hatRadius = 3;
            }
            if (largeStem) {
                ++hatRadius;
            }
            for (int x = -hatRadius; x <= hatRadius; ++x) {
                for (int z = -hatRadius; z <= hatRadius; ++z) {
                    boolean isEdgeX = x == -hatRadius || x == hatRadius;
                    boolean isEdgeZ = z == -hatRadius || z == hatRadius;
                    boolean isCenter = !isEdgeX && !isEdgeZ && y != height;
                    boolean isCorner = isEdgeX && isEdgeZ;
                    boolean lowHat = y < stemHeight + 3;
                    mutableBlockPos.method_25504((class_2382)pos, x, y, z);
                    if (!WarpedFungusFeature.isReplaceable(level, (class_2338)mutableBlockPos, config, false)) continue;
                    if (config.field_22194 && !level.method_8320(mutableBlockPos.method_10074()).method_26215()) {
                        level.method_22352((class_2338)mutableBlockPos, true);
                    }
                    if (lowHat) {
                        if (isCenter) continue;
                        this.placeHatDropBlock((class_1936)level, random, (class_2338)mutableBlockPos, config.field_22192, beardValid);
                        continue;
                    }
                    if (isCenter) {
                        this.placeHatBlock((class_1936)level, random, config, mutableBlockPos, 0.1f, 0.2f, beardValid ? 0.1f : 0.0f);
                        continue;
                    }
                    if (isCorner) {
                        this.placeHatBlock((class_1936)level, random, config, mutableBlockPos, 0.01f, 0.7f, beardValid ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock((class_1936)level, random, config, mutableBlockPos, 5.0E-4f, 0.98f, beardValid ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(class_1936 level, class_5819 random, class_4780 config, class_2338.class_2339 pos, float probability1, float probability2, float probability3) {
        if (random.method_43057() < probability1) {
            this.method_13153((class_1945)level, (class_2338)pos, config.field_22193);
        } else if (random.method_43057() < probability2) {
            this.method_13153((class_1945)level, (class_2338)pos, config.field_22192);
            WarpedFungusFeature.tryPlaceBeard((class_2338)pos, level);
        }
    }

    private void placeHatDropBlock(class_1936 level, class_5819 random, class_2338 pos, class_2680 state, boolean beardValid) {
        if (level.method_8320(pos.method_10074()).method_27852(state.method_26204())) {
            this.method_13153((class_1945)level, pos, state);
        } else if ((double)random.method_43057() < 0.15) {
            this.method_13153((class_1945)level, pos, state);
        } else if (level.method_8320(pos.method_10084()).method_27852(state.method_26204())) {
            WarpedFungusFeature.tryPlaceBeard(pos, level);
        }
    }

    private static void tryPlaceBeard(class_2338 pos, class_1936 level) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503().method_10098(class_2350.field_11033);
        if (level.method_22347((class_2338)mutableBlockPos) && level.method_22347(mutableBlockPos.method_10074()) && level.method_8320(mutableBlockPos.method_10084()).method_26164(JNETags.Blocks.WART_BEARD_FEATURE_VALID)) {
            level.method_8652((class_2338)mutableBlockPos, ((class_2248)JNEBlocks.WARPED_WART_BEARD.get()).method_9564(), 2);
        }
    }
}

