/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.structure.custom;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class GiantJigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<class_3195.class_7150> addPieces(class_3195.class_7149 context, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int maxDepth, class_2338 pos, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        class_2338 blockPos2;
        class_5455 registryAccess = context.comp_561();
        class_2794 chunkGenerator = context.comp_562();
        class_3485 structureTemplateManager = context.comp_565();
        class_5539 levelHeightAccessor = context.comp_569();
        class_2919 worldgenRandom = context.comp_566();
        class_2378 registry = registryAccess.method_30530(class_7924.field_41249);
        class_2470 rotation = class_2470.method_16548((class_5819)worldgenRandom);
        class_3785 structureTemplatePool = (class_3785)startPool.comp_349();
        class_3784 structurePoolElement = structureTemplatePool.method_16631((class_5819)worldgenRandom);
        if (structurePoolElement == class_3777.field_16663) {
            return Optional.empty();
        }
        if (startJigsawName.isPresent()) {
            class_2960 resourceLocation = startJigsawName.get();
            Optional<class_2338> optional3 = GiantJigsawPlacement.getRandomNamedJigsaw(structurePoolElement, resourceLocation, pos, rotation, structureTemplateManager, worldgenRandom);
            if (optional3.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourceLocation, (Object)startPool.method_40230().map(resourceKey -> resourceKey.method_29177().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos2 = optional3.get();
        } else {
            blockPos2 = pos;
        }
        class_2338 vec3i = blockPos2.method_10059((class_2382)pos);
        class_2338 blockPos3 = pos.method_10059((class_2382)vec3i);
        class_3790 poolElementStructurePiece = new class_3790(structureTemplateManager, structurePoolElement, blockPos3, structurePoolElement.method_19308(), rotation, structurePoolElement.method_16628(structureTemplateManager, blockPos3, rotation));
        class_3341 boundingBox = poolElementStructurePiece.method_14935();
        int k = (boundingBox.method_35418() + boundingBox.method_35415()) / 2;
        int l = (boundingBox.method_35420() + boundingBox.method_35417()) / 2;
        int m = projectStartToHeightmap.isPresent() ? pos.method_10264() + chunkGenerator.method_20402(k, l, projectStartToHeightmap.get(), levelHeightAccessor, context.comp_564()) : blockPos3.method_10264();
        int n = boundingBox.method_35416() + poolElementStructurePiece.method_16646();
        poolElementStructurePiece.method_14922(0, m - n, 0);
        int o = m + vec3i.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(k, o, l), structurePiecesBuilder -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolElementStructurePiece);
            if (maxDepth > 0) {
                class_238 aABB = new class_238((double)(k - maxDistanceFromCenter), (double)(o - 64), (double)(l - maxDistanceFromCenter), (double)(k + maxDistanceFromCenter + 1), (double)(o + 64 + 1), (double)(l + maxDistanceFromCenter + 1));
                class_265 voxelShape = class_259.method_1072((class_265)class_259.method_1078((class_238)aABB), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)boundingBox)), (class_247)class_247.field_16886);
                GiantJigsawPlacement.addPiecesChild(context.comp_564(), maxDepth, useExpansionHack, chunkGenerator, structureTemplateManager, levelHeightAccessor, (class_5819)worldgenRandom, (class_2378<class_3785>)registry, poolElementStructurePiece, list, voxelShape);
                Objects.requireNonNull(structurePiecesBuilder);
                list.forEach(arg_0 -> ((class_6626)structurePiecesBuilder).method_35462(arg_0));
            }
        }));
    }

    private static Optional<class_2338> getRandomNamedJigsaw(class_3784 structurePoolElement, class_2960 resourceLocation, class_2338 blockPos, class_2470 rotation, class_3485 structureTemplateManager, class_2919 worldgenRandom) {
        List list = structurePoolElement.method_16627(structureTemplateManager, blockPos, rotation, (class_5819)worldgenRandom);
        Optional<class_2338> optional = Optional.empty();
        for (class_3499.class_3501 structureBlockInfo : list) {
            class_2960 resourceLocation2 = class_2960.method_12829((String)structureBlockInfo.comp_1343().method_10558("name"));
            if (!resourceLocation.equals((Object)resourceLocation2)) continue;
            optional = Optional.of(structureBlockInfo.comp_1341());
            break;
        }
        return optional;
    }

    private static void addPiecesChild(class_7138 randomState, int i, boolean bl, class_2794 chunkGenerator, class_3485 structureTemplateManager, class_5539 levelHeightAccessor, class_5819 randomSource, class_2378<class_3785> registry, class_3790 poolElementStructurePiece, List<class_3790> list, class_265 voxelShape) {
        Placer placer = new Placer(registry, i, chunkGenerator, structureTemplateManager, list, randomSource);
        placer.placing.addLast(new PieceState(poolElementStructurePiece, (MutableObject<class_265>)new MutableObject((Object)voxelShape), 0));
        while (!placer.placing.isEmpty()) {
            PieceState pieceState = placer.placing.removeFirst();
            placer.tryPlacingChildren(pieceState.piece, pieceState.free, pieceState.depth, bl, levelHeightAccessor, randomState);
        }
    }

    public static boolean generateJigsaw(class_3218 serverLevel, class_6880<class_3785> holder, class_2960 resourceLocation, int i, class_2338 blockPos, boolean bl) {
        class_2794 chunkGenerator = serverLevel.method_14178().method_12129();
        class_3485 structureTemplateManager = serverLevel.method_14183();
        class_5138 structureManager = serverLevel.method_27056();
        class_5819 randomSource = serverLevel.method_8409();
        class_3195.class_7149 generationContext = new class_3195.class_7149(serverLevel.method_30349(), chunkGenerator, chunkGenerator.method_12098(), serverLevel.method_14178().method_41248(), structureTemplateManager, serverLevel.method_8412(), new class_1923(blockPos), (class_5539)serverLevel, holderx -> true);
        Optional<class_3195.class_7150> optional = GiantJigsawPlacement.addPieces(generationContext, holder, Optional.of(resourceLocation), i, blockPos, false, Optional.empty(), 512);
        if (optional.isPresent()) {
            class_6626 structurePiecesBuilder = optional.get().method_44019();
            for (class_3443 structurePiece : structurePiecesBuilder.method_38714().comp_132()) {
                if (!(structurePiece instanceof class_3790)) continue;
                class_3790 poolElementStructurePiece = (class_3790)structurePiece;
                poolElementStructurePiece.method_27236((class_5281)serverLevel, structureManager, chunkGenerator, randomSource, class_3341.method_14665(), blockPos, bl);
            }
            return true;
        }
        return false;
    }

    static final class Placer {
        private final class_2378<class_3785> pools;
        private final int maxDepth;
        private final class_2794 chunkGenerator;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> pieces;
        private final class_5819 random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(class_2378<class_3785> registry, int i, class_2794 chunkGenerator, class_3485 structureTemplateManager, List<? super class_3790> list, class_5819 randomSource) {
            this.pools = registry;
            this.maxDepth = i;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.pieces = list;
            this.random = randomSource;
        }

        void tryPlacingChildren(class_3790 poolElementStructurePiece, MutableObject<class_265> sizeLimit, int i, boolean bl, class_5539 levelHeightAccessor, class_7138 randomState) {
            class_3784 structurePoolElement = poolElementStructurePiece.method_16644();
            class_2338 blockPos = poolElementStructurePiece.method_16648();
            class_2470 rotation = poolElementStructurePiece.method_16888();
            class_3785.class_3786 projection = structurePoolElement.method_16624();
            boolean bl2 = projection == class_3785.class_3786.field_16687;
            MutableObject<class_265> mutableObject2 = new MutableObject<class_265>();
            class_3341 boundingBox = poolElementStructurePiece.method_14935();
            int j = boundingBox.method_35416();
            block0: for (class_3499.class_3501 structureBlockInfo : structurePoolElement.method_16627(this.structureTemplateManager, blockPos, rotation, this.random)) {
                class_3784 structurePoolElement2;
                MutableObject<class_265> mutableObject3;
                class_2350 direction = class_3748.method_26378((class_2680)structureBlockInfo.comp_1342());
                class_2338 blockPos2 = structureBlockInfo.comp_1341();
                class_2338 blockPos3 = blockPos2.method_10093(direction);
                int k = blockPos2.method_10264() - j;
                int l = -1;
                class_5321<class_3785> resourceKey = Placer.readPoolName(structureBlockInfo);
                Optional optional = this.pools.method_40264(resourceKey);
                if (optional.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourceKey.method_29177());
                    continue;
                }
                class_6880 holder = (class_6880)optional.get();
                if (((class_3785)holder.comp_349()).method_16632() == 0 && !holder.method_40225(class_5468.field_26254)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourceKey.method_29177());
                    continue;
                }
                class_6880 holder2 = ((class_3785)holder.comp_349()).method_46736();
                if (((class_3785)holder2.comp_349()).method_16632() == 0 && !holder2.method_40225(class_5468.field_26254)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)holder2.method_40230().map(resourceKeyx -> resourceKeyx.method_29177().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean bl3 = boundingBox.method_14662((class_2382)blockPos3);
                if (bl3) {
                    mutableObject3 = mutableObject2;
                    if (mutableObject2.getValue() == null) {
                        mutableObject2.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)boundingBox)));
                    }
                } else {
                    mutableObject3 = sizeLimit;
                }
                ArrayList list = Lists.newArrayList();
                if (i != this.maxDepth) {
                    list.addAll(((class_3785)holder.comp_349()).method_16633(this.random));
                }
                list.addAll(((class_3785)holder2.comp_349()).method_16633(this.random));
                Iterator var29 = list.iterator();
                while (var29.hasNext() && (structurePoolElement2 = (class_3784)var29.next()) != class_3777.field_16663) {
                    for (class_2470 rotation2 : class_2470.method_16547((class_5819)this.random)) {
                        List list2 = structurePoolElement2.method_16627(this.structureTemplateManager, class_2338.field_10980, rotation2, this.random);
                        class_3341 boundingBox2 = structurePoolElement2.method_16628(this.structureTemplateManager, class_2338.field_10980, rotation2);
                        int m = bl && boundingBox2.method_14660() <= 16 ? list2.stream().mapToInt(structureBlockInfox -> {
                            if (!boundingBox2.method_14662((class_2382)structureBlockInfox.comp_1341().method_10093(class_3748.method_26378((class_2680)structureBlockInfox.comp_1342())))) {
                                return 0;
                            }
                            class_5321<class_3785> templatePoolResourceKey = Placer.readPoolName(structureBlockInfox);
                            Optional optionalJ1 = this.pools.method_40264(templatePoolResourceKey);
                            Optional<class_6880> optional2 = optionalJ1.map(holderJ3 -> ((class_3785)holderJ3.comp_349()).method_46736());
                            int p = optionalJ1.map(holderJ1 -> ((class_3785)holderJ1.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                            int h = optional2.map(holderJ2 -> ((class_3785)holderJ2.comp_349()).method_19309(this.structureTemplateManager)).orElse(0);
                            return Math.max(p, h);
                        }).max().orElse(0) : 0;
                        for (class_3499.class_3501 structureBlockInfo2 : list2) {
                            int u;
                            int s;
                            int q;
                            if (!class_3748.method_16546((class_3499.class_3501)structureBlockInfo, (class_3499.class_3501)structureBlockInfo2)) continue;
                            class_2338 blockPos4 = structureBlockInfo2.comp_1341();
                            class_2338 blockPos5 = blockPos3.method_10059((class_2382)blockPos4);
                            class_3341 boundingBox3 = structurePoolElement2.method_16628(this.structureTemplateManager, blockPos5, rotation2);
                            int n = boundingBox3.method_35416();
                            class_3785.class_3786 projection2 = structurePoolElement2.method_16624();
                            boolean bl4 = projection2 == class_3785.class_3786.field_16687;
                            int o = blockPos4.method_10264();
                            int p = k - o + class_3748.method_26378((class_2680)structureBlockInfo.comp_1342()).method_10164();
                            if (bl2 && bl4) {
                                q = j + p;
                            } else {
                                if (l == -1) {
                                    l = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, levelHeightAccessor, randomState);
                                }
                                q = l - o;
                            }
                            int r = q - n;
                            class_3341 boundingBox4 = boundingBox3.method_19311(0, r, 0);
                            class_2338 blockPos6 = blockPos5.method_10069(0, r, 0);
                            if (m > 0) {
                                s = Math.max(m + 1, boundingBox4.method_35419() - boundingBox4.method_35416());
                                boundingBox4.method_34389(new class_2338(boundingBox4.method_35415(), boundingBox4.method_35416() + s, boundingBox4.method_35417()));
                            }
                            if (class_259.method_1074((class_265)((class_265)mutableObject3.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)boundingBox4)), (class_247)class_247.field_16893)) continue;
                            mutableObject3.setValue((Object)class_259.method_1082((class_265)((class_265)mutableObject3.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)boundingBox4)), (class_247)class_247.field_16886));
                            s = poolElementStructurePiece.method_16646();
                            int t = bl4 ? s - p : structurePoolElement2.method_19308();
                            class_3790 poolElementStructurePiece2 = new class_3790(this.structureTemplateManager, structurePoolElement2, blockPos6, t, rotation2, boundingBox4);
                            if (bl2) {
                                u = j + k;
                            } else if (bl4) {
                                u = q + o;
                            } else {
                                if (l == -1) {
                                    l = this.chunkGenerator.method_20402(blockPos2.method_10263(), blockPos2.method_10260(), class_2902.class_2903.field_13194, levelHeightAccessor, randomState);
                                }
                                u = l + p / 2;
                            }
                            poolElementStructurePiece.method_16647(new class_3780(blockPos3.method_10263(), u - k + s, blockPos3.method_10260(), p, projection2));
                            poolElementStructurePiece2.method_16647(new class_3780(blockPos2.method_10263(), u - o + t, blockPos2.method_10260(), -p, projection));
                            this.pieces.add((class_3790)poolElementStructurePiece2);
                            if (i + 1 > this.maxDepth) continue block0;
                            this.placing.addLast(new PieceState(poolElementStructurePiece2, mutableObject3, i + 1));
                            continue block0;
                        }
                    }
                }
            }
        }

        private static class_5321<class_3785> readPoolName(class_3499.class_3501 structureBlockInfo) {
            return class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)new class_2960(structureBlockInfo.comp_1343().method_10558("pool")));
        }
    }

    static final class PieceState {
        final class_3790 piece;
        final MutableObject<class_265> free;
        final int depth;

        PieceState(class_3790 poolElementStructurePiece, MutableObject<class_265> mutableObject, int i) {
            this.piece = poolElementStructurePiece;
            this.free = mutableObject;
            this.depth = i;
        }
    }
}

