/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.worldgen.structure.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.jadenxgamer.netherexp.registry.worldgen.structure.JNEStructureType;
import net.jadenxgamer.netherexp.registry.worldgen.structure.custom.GiantJigsawPlacement;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3785;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import org.jetbrains.annotations.NotNull;

public class GiantJigsawStructure
extends class_3195 {
    public static final Codec<GiantJigsawStructure> CODEC = class_5699.method_51699((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)GiantJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(arg -> arg.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(arg -> arg.startJigsawName), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(arg -> arg.maxDepth), (App)class_6122.field_31540.fieldOf("start_height").forGetter(arg -> arg.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(arg -> arg.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(arg -> arg.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(arg -> arg.maxDistanceFromCenter)).apply((Applicative)instance, GiantJigsawStructure::new)), GiantJigsawStructure::verifyRange).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int maxDepth;
    private final class_6122 startHeight;
    private final boolean useExpansionHack;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static DataResult<GiantJigsawStructure> verifyRange(GiantJigsawStructure arg) {
        int i = switch (arg.method_42701()) {
            default -> throw new IncompatibleClassChangeError();
            case class_5847.field_28922 -> 0;
            case class_5847.field_28923, class_5847.field_38431, class_5847.field_38432 -> 12;
        };
        return arg.maxDistanceFromCenter + i > 256 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 256") : DataResult.success((Object)((Object)arg));
    }

    public GiantJigsawStructure(class_3195.class_7302 structure, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int maxDepth, class_6122 startHeight, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(structure);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public GiantJigsawStructure(class_3195.class_7302 structure, class_6880<class_3785> startPool, int maxDepth, class_6122 startHeight, boolean useExpansionHack, class_2902.class_2903 projectStartToHeightmap) {
        this(structure, startPool, Optional.empty(), maxDepth, startHeight, useExpansionHack, Optional.of(projectStartToHeightmap), 240);
    }

    public GiantJigsawStructure(class_3195.class_7302 structure, class_6880<class_3785> startPool, int maxDepth, class_6122 startHeight, boolean useExpansionHack) {
        this(structure, startPool, Optional.empty(), maxDepth, startHeight, useExpansionHack, Optional.empty(), 240);
    }

    @NotNull
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        int i = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), i, chunkPos.method_8328());
        return GiantJigsawPlacement.addPieces(context, this.startPool, this.startJigsawName, this.maxDepth, blockPos, this.useExpansionHack, this.projectStartToHeightmap, this.maxDistanceFromCenter);
    }

    @NotNull
    public class_7151<?> method_41618() {
        return (class_7151)JNEStructureType.GIANT_JIGSAW.get();
    }
}

