/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.network;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.client.sound.PlayerInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.RibbitInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.supporters.RibbitOptionsJSON;
import com.yungnickyoung.minecraft.ribbits.client.supporters.SupportersListClient;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.ISoundManagerDuck;
import com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.accessor.ClientLevelAccessor;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import com.yungnickyoung.minecraft.ribbits.network.packet.RequestSupporterHatStatePacket;
import com.yungnickyoung.minecraft.ribbits.network.packet.ToggleSupporterPacket;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import com.yungnickyoung.minecraft.ribbits.util.BufferUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ClientPacketHandlerFabric {
    private static final Map<UUID, List<Consumer<class_1297>>> pendingEntityActions = new HashMap<UUID, List<Consumer<class_1297>>>();

    public static void onEntityLoad(class_1297 entity) {
        UUID entityId = entity.method_5667();
        if (pendingEntityActions.containsKey(entityId)) {
            List<Consumer<class_1297>> actions = pendingEntityActions.remove(entityId);
            for (Consumer<class_1297> action : actions) {
                action.accept(entity);
            }
        }
    }

    public static void clearPendingActions() {
        pendingEntityActions.clear();
    }

    private static void queueOrExecute(class_310 client, UUID entityId, Consumer<class_1297> action) {
        class_638 clientLevel = client.field_1687;
        if (clientLevel == null) {
            return;
        }
        class_1297 entity = (class_1297)((ClientLevelAccessor)clientLevel).callGetEntities().method_31808(entityId);
        if (entity == null) {
            pendingEntityActions.computeIfAbsent(entityId, k -> new ArrayList()).add(action);
        } else {
            action.accept(entity);
        }
    }

    public static void receiveStartSingle(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        UUID entityId = buf.method_10790();
        RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(buf.method_10810());
        int tickOffset = buf.readInt();
        if (instrument == null) {
            RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with null instrument!");
            return;
        }
        if (instrument == RibbitInstrumentModule.NONE) {
            RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with NONE instrument!");
            return;
        }
        ClientPacketHandlerFabric.queueOrExecute(client, entityId, entity -> {
            if (!(entity instanceof RibbitEntity)) {
                RibbitsCommon.LOGGER.error("Tried to play music for a non-ribbit entity!");
                return;
            }
            RibbitEntity ribbit = (RibbitEntity)((Object)entity);
            class_3414 instrumentSoundEvent = instrument.getSoundEvent();
            client.execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new RibbitInstrumentSoundInstance(ribbit, tickOffset, instrumentSoundEvent)));
        });
    }

    public static void receiveStartAll(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        List<UUID> entityIds = BufferUtils.readUUIDList(buf);
        List<class_2960> instrumentIds = BufferUtils.readResourceLocationList(buf);
        int tickOffset = buf.readInt();
        if (entityIds.size() != instrumentIds.size()) {
            RibbitsCommon.LOGGER.error("Received Start Music All packet with {} ribbits and {} instruments!", (Object)entityIds.size(), (Object)instrumentIds.size());
            return;
        }
        for (int i = 0; i < entityIds.size(); ++i) {
            RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(instrumentIds.get(i));
            if (instrument == null) {
                RibbitsCommon.LOGGER.error("Tried to play music in receiveStartAll for a ribbit with null instrument!");
                return;
            }
            if (instrument == RibbitInstrumentModule.NONE) {
                RibbitsCommon.LOGGER.error("Tried to play music in receiveStartAll for a ribbit with NONE instrument!");
                return;
            }
            ClientPacketHandlerFabric.queueOrExecute(client, entityIds.get(i), entity -> {
                if (!(entity instanceof RibbitEntity)) {
                    RibbitsCommon.LOGGER.error("Tried to play music in receiveStartAll for a non-ribbit entity!");
                    return;
                }
                RibbitEntity ribbit = (RibbitEntity)((Object)entity);
                class_3414 instrumentSoundEvent = instrument.getSoundEvent();
                client.execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new RibbitInstrumentSoundInstance(ribbit, tickOffset, instrumentSoundEvent)));
            });
        }
    }

    public static void receiveStop(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        UUID entityId = buf.method_10790();
        ClientPacketHandlerFabric.queueOrExecute(client, entityId, entity -> client.execute(() -> ((ISoundManagerDuck)class_310.method_1551().method_1483()).ribbits$stopRibbitsMusic(entityId)));
    }

    public static void receiveStartMaraca(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        UUID performerId = buf.method_10790();
        ClientPacketHandlerFabric.queueOrExecute(client, performerId, performer -> {
            if (!(performer instanceof class_1657)) {
                RibbitsCommon.LOGGER.error("Received Start Maraca packet for non-Player performer with UUID {}!", (Object)performerId);
                return;
            }
            class_1657 playerPerformer = (class_1657)performer;
            client.execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)new PlayerInstrumentSoundInstance(playerPerformer, -1, (class_3414)SoundModule.MUSIC_MARACA.get())));
        });
    }

    public static void receiveStopMaraca(class_310 client, class_634 clientPacketListener, class_2540 buf, PacketSender responseSender) {
        UUID performerId = buf.method_10790();
        ClientPacketHandlerFabric.queueOrExecute(client, performerId, performer -> client.execute(() -> ((ISoundManagerDuck)class_310.method_1551().method_1483()).ribbits$stopMaraca(performerId)));
    }

    public static void receiveToggleSupporterHat(ToggleSupporterPacket packet, class_746 player, PacketSender responseSender) {
        SupportersListClient.toggleSupporterHat(packet.playerUUID(), packet.enabled());
    }

    public static void receiveSupporterHatStateRequest(RequestSupporterHatStatePacket packet, class_746 player, PacketSender responseSender) {
        SupportersListClient.clear();
        packet.enabledSupporterHatPlayers().forEach(playerUUID -> SupportersListClient.toggleSupporterHat(playerUUID, true));
        Services.SUPPORTER_HELPER.notifyServerOfSupporterHatState(RibbitOptionsJSON.get().isSupporterHatEnabled());
    }
}

