/*
 * Decompiled with CFR 0.152.
 */
package net.elidhan.anim_guns.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.elidhan.anim_guns.animations.AnimationHandler;
import net.elidhan.anim_guns.client.render.GunRenderer;
import net.elidhan.anim_guns.entity.projectile.BulletProjectileEntity;
import net.elidhan.anim_guns.item.AttachmentItem;
import net.elidhan.anim_guns.mixininterface.IFPlayerWithGun;
import net.elidhan.anim_guns.network.ModNetworking;
import net.elidhan.anim_guns.util.AttachmentUtil;
import net.elidhan.anim_guns.util.BulletUtil;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_756;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GunItem
extends class_1792
implements FabricItem,
GeoItem {
    private final String id;
    private final class_1792 ammoItem;
    private final float damage;
    private final int shotCount;
    private final int fireRate;
    private final int magSize;
    private final int reloadTime;
    protected final class_3414 shotSound;
    protected final class_3414[] reloadSounds;
    private final Vector2f spread;
    private final Vector2f cameraRecoil;
    private final Vector3f viewModelRecoilMult;
    private final AttachmentItem.AttachType[] acceptedAttachmentTypes;
    private final fireType firingType;
    protected final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    protected final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GunItem(class_1792.class_1793 settings, String id, class_1792 ammoItem, float damage, int shotCount, int fireRate, int magSize, int reloadTime, class_3414 shotSound, class_3414[] reloadSounds, Vector2f spread, Vector2f cameraRecoil, Vector3f viewModelRecoilMult, AttachmentItem.AttachType[] acceptedAttachmentTypes, fireType firingType) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.id = id;
        this.ammoItem = ammoItem;
        this.damage = damage;
        this.shotCount = shotCount;
        this.fireRate = fireRate;
        this.magSize = magSize;
        this.reloadTime = reloadTime;
        this.spread = spread;
        this.cameraRecoil = cameraRecoil;
        this.shotSound = shotSound;
        this.reloadSounds = reloadSounds;
        this.viewModelRecoilMult = viewModelRecoilMult;
        this.acceptedAttachmentTypes = acceptedAttachmentTypes;
        this.firingType = firingType;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!stack.method_7948().method_10573("GeckoLibID", 99) && world instanceof class_3218) {
            stack.method_7948().method_10544("GeckoLibID", AnimatableIdCache.getFreeId((class_3218)((class_3218)world)));
        }
    }

    public void shoot(class_3222 player, class_1799 stack) {
        IFPlayerWithGun player1;
        class_1937 world = player.method_37908();
        if (world.method_8608()) {
            return;
        }
        if (!stack.method_7948().method_10545("ammo")) {
            stack.method_7948().method_10569("ammo", 0);
        }
        if (stack.method_7948().method_10550("ammo") <= 0) {
            return;
        }
        if (player.method_7357().method_7904((class_1792)this)) {
            return;
        }
        player.method_7357().method_7906((class_1792)this, this.fireRate);
        for (int i = 0; i < this.shotCount; ++i) {
            BulletProjectileEntity bullet = new BulletProjectileEntity((class_1309)player, player.method_37908(), this.damage, this.shotCount);
            bullet.method_5814(player.method_23317(), player.method_23320(), player.method_23321());
            double spreadX = (double)(-this.spread.x) + Math.random() * (double)(this.spread.x - -this.spread.x);
            double spreadY = (double)(-this.spread.y) + Math.random() * (double)(this.spread.y - -this.spread.y);
            class_243 horiSpread = BulletUtil.horiSpread((class_1657)player, spreadX);
            class_243 vertiSpread = BulletUtil.vertiSpread((class_1657)player, spreadY);
            class_243 result = player.method_5720().method_1019(vertiSpread).method_1019(horiSpread);
            bullet.method_7485(result.method_10216(), result.method_10214(), result.method_10215(), 20.0f, 0.0f);
            bullet.method_7432((class_1297)player);
            world.method_8649((class_1297)bullet);
        }
        if (!player.method_7337()) {
            stack.method_7948().method_10569("ammo", stack.method_7948().method_10550("ammo") - 1);
        }
        if (player instanceof IFPlayerWithGun && (player1 = (IFPlayerWithGun)player).isReloading()) {
            player1.stopReload();
        }
        world.method_43128(null, player.method_19538().method_10216(), player.method_19538().method_10214(), player.method_19538().method_10215(), this.shotSound, class_3419.field_15248, 1.0f, 1.0f);
        AnimationHandler.playAnim(player, stack, GeoItem.getId((class_1799)stack), "firing");
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModNetworking.S2C_SHOT, (class_2540)PacketByteBufs.empty());
    }

    public void tickReload(class_3222 player, class_1799 stack, int tick) {
    }

    public String getSightID(class_1799 currentItemStack) {
        if (currentItemStack.method_7948().method_10558("sightID").isEmpty()) {
            currentItemStack.method_7948().method_10582("sightID", "default");
        }
        return currentItemStack.method_7948().method_10558("sightID");
    }

    public String getGripID(class_1799 currentItemStack) {
        if (currentItemStack.method_7948().method_10558("gripID").isEmpty()) {
            currentItemStack.method_7948().method_10582("gripID", "default");
        }
        return currentItemStack.method_7948().method_10558("gripID");
    }

    public String getMuzzleID(class_1799 currentItemStack) {
        if (currentItemStack.method_7948().method_10558("muzzleID").isEmpty()) {
            currentItemStack.method_7948().method_10582("muzzleID", "default");
        }
        return currentItemStack.method_7948().method_10558("muzzleID");
    }

    public boolean isSilenced(class_1799 gun) {
        class_2487 nbtCompound = gun.method_7948();
        class_2499 nbtList = nbtCompound.method_10554("Items", 10);
        Optional<class_2487> optional = nbtList.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).filter(item -> class_1799.method_7915((class_2487)item).method_7909() instanceof AttachmentItem && ((AttachmentItem)class_1799.method_7915((class_2487)item).method_7909()).silencesGun()).findFirst();
        return optional.isPresent();
    }

    public boolean isScoped(class_1799 gun) {
        class_2487 nbtCompound = gun.method_7948();
        return nbtCompound.method_10577("isScoped");
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        if (otherStack.method_7960()) {
            AttachmentUtil.removeFirstStack(stack).ifPresent(itemStack -> {
                player.method_5783(class_3417.field_34377, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
                cursorStackReference.method_32332(itemStack);
            });
        } else {
            int i = AttachmentUtil.addAttachment(stack, otherStack, this.acceptedAttachmentTypes);
            if (i > 0) {
                otherStack.method_7934(i);
                player.method_5783(class_3417.field_34376, 0.8f, 0.8f + player.method_37908().method_8409().method_43057() * 0.4f);
            }
        }
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        IFPlayerWithGun player;
        if (hand != class_1268.field_5808) {
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        if (user instanceof IFPlayerWithGun && !(player = (IFPlayerWithGun)user).isReloading()) {
            player.toggleAim(!player.isAiming());
        }
        return class_1271.method_22430((Object)user.method_5998(hand));
    }

    public fireType getFiringType() {
        return this.firingType;
    }

    public int getReloadTime() {
        return this.reloadTime;
    }

    public String getID() {
        return this.id;
    }

    public int getMagSize() {
        return this.magSize;
    }

    public class_1792 getAmmoItem() {
        return this.ammoItem;
    }

    public float getRecoilX() {
        return this.cameraRecoil.x;
    }

    public float getRecoilY() {
        return this.cameraRecoil.y;
    }

    public float getRecoilMult(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        class_2499 list = nbtCompound.method_10554("Items", 10);
        float recoilMult = 1.0f;
        List<class_2487> l = list.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).toList();
        for (class_2487 n : l) {
            recoilMult *= ((AttachmentItem)class_1799.method_7915((class_2487)n).method_7909()).getRecoilMult();
        }
        return recoilMult;
    }

    public Vector3f getAimVMRecoilMult() {
        return this.viewModelRecoilMult;
    }

    public boolean method_7838(class_1799 stack) {
        return false;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)("Damage: " + String.format("%.1f", Float.valueOf(this.damage)) + (String)(this.shotCount > 1 ? " x " + this.shotCount : ""))).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)("Shot cooldown: " + this.fireRate + (this.fireRate == 1 ? " tick" : " ticks"))).method_27692(class_124.field_1080));
        float rTime = (float)this.reloadTime / 20.0f;
        tooltip.add((class_2561)class_2561.method_43471((String)("Reload time: " + String.format("%.1f", Float.valueOf(rTime)) + (rTime == 1.0f ? " second" : " seconds"))).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"Ammo type: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43471((String)String.valueOf(this.ammoItem.method_7876())).method_27692(class_124.field_1065)));
        tooltip.add((class_2561)class_2561.method_43473());
        tooltip.add((class_2561)class_2561.method_43471((String)"Accepted attachments:").method_27692(class_124.field_1068));
        if (this.acceptedAttachmentTypes.length < 1) {
            tooltip.add((class_2561)class_2561.method_43471((String)"NONE").method_27692(class_124.field_1061));
        }
        for (AttachmentItem.AttachType acceptedAttachmentType : this.acceptedAttachmentTypes) {
            tooltip.add((class_2561)class_2561.method_43471((String)acceptedAttachmentType.toString()).method_27692(class_124.field_1062));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final GunRenderer renderer;
            {
                this.renderer = new GunRenderer(new class_2960("anim_guns", GunItem.this.id));
            }

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    protected PlayState predicate(AnimationState<GunItem> animationState) {
        if (animationState.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != class_811.field_4322) {
            return PlayState.STOP;
        }
        if (animationState.getController().getAnimationState() == AnimationController.State.STOPPED) {
            animationState.getController().tryTriggerAnimation("idle");
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    public static enum fireType {
        AUTO,
        SEMI;

    }
}

