/*
 * Decompiled with CFR 0.152.
 */
package net.elidhan.anim_guns.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.elidhan.anim_guns.animations.AnimationHandler;
import net.elidhan.anim_guns.item.GunItem;
import net.elidhan.anim_guns.item.GunSingleLoaderItem;
import net.elidhan.anim_guns.mixininterface.IFPlayerWithGun;
import net.elidhan.anim_guns.util.InventoryUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import software.bernie.geckolib.animatable.GeoItem;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements IFPlayerWithGun {
    @Unique
    private static final class_2940<Boolean> IS_AIMING = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Integer> RELOAD_TICK = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Boolean> IS_RELOADING = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    @Unique
    private class_1799 currentGun = class_1799.field_8037;
    @Unique
    private int meleeTick = 0;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"tickMovement"}, at={@At(value="HEAD")})
    public void getCurrentGun(CallbackInfo ci) {
        if (this.method_6047().method_7948().method_10580("GeckoLibID") != this.currentGun.method_7948().method_10580("GeckoLibID") && this.method_37908() instanceof class_3218) {
            this.toggleAim(false);
            this.stopReload();
        }
        this.currentGun = this.method_6047();
    }

    @Inject(method={"tickMovement"}, at={@At(value="TAIL")})
    public void tickMovement(CallbackInfo ci) {
        if (this.meleeTick > 0) {
            --this.meleeTick;
        }
        if (this.isReloading()) {
            this.tickReload();
        }
    }

    @Override
    public void startReload() {
        this.toggleAim(false);
        this.setReloading(true);
    }

    @Override
    public void stopReload() {
        this.setReloadProgressTick(0);
        this.setReloading(false);
    }

    @Unique
    private void tickReload() {
        if (!(this.method_37908() instanceof class_3218) || !(this.currentGun.method_7909() instanceof GunItem)) {
            return;
        }
        GunItem gun = (GunItem)this.currentGun.method_7909();
        if (gun instanceof GunSingleLoaderItem && InventoryUtil.itemCountInInventory((class_1657)((class_3222)this), gun.getAmmoItem()) <= 0) {
            if (this.currentGun.method_7909() instanceof GunItem) {
                AnimationHandler.playAnim((class_3222)this, this.currentGun, GeoItem.getId((class_1799)this.currentGun), "reload_2");
            }
            this.stopReload();
        }
        gun.tickReload((class_3222)this, this.currentGun, this.getReloadProgressTick());
        if (this.getReloadProgressTick() >= ((GunItem)this.currentGun.method_7909()).getReloadTime()) {
            int ammoNeeded = gun.getMagSize() - this.currentGun.method_7948().method_10550("ammo");
            int ammoAvailable = InventoryUtil.itemCountInInventory((class_1657)((class_3222)this), gun.getAmmoItem());
            int ammoToPut = Math.min(ammoAvailable, ammoNeeded);
            this.currentGun.method_7948().method_10569("ammo", ammoToPut + this.currentGun.method_7948().method_10550("ammo"));
            InventoryUtil.removeItemFromInventory((class_1657)((class_3222)this), gun.getAmmoItem(), ammoToPut);
            this.stopReload();
            return;
        }
        this.setReloadProgressTick(this.getReloadProgressTick() + 1);
    }

    @Override
    public void setReloadProgressTick(int reloadTick) {
        this.field_6011.method_12778(RELOAD_TICK, (Object)reloadTick);
    }

    @Override
    public int getReloadProgressTick() {
        return (Integer)this.field_6011.method_12789(RELOAD_TICK);
    }

    @Override
    public void setReloading(boolean reloading) {
        this.field_6011.method_12778(IS_RELOADING, (Object)reloading);
    }

    @Override
    public boolean isReloading() {
        return (Boolean)this.field_6011.method_12789(IS_RELOADING);
    }

    @Override
    public void melee() {
        this.toggleAim(false);
        this.meleeTick = 10;
    }

    @Override
    public int getMeleeProgress() {
        return this.meleeTick;
    }

    @WrapOperation(method={"attack"}, constant={@Constant(classValue=class_1829.class)})
    private boolean sweepMeleeIfGun(Object obj, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{obj}) != false || obj instanceof GunItem;
    }

    @Inject(method={"resetLastAttackedTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontResetIfGun(CallbackInfo ci) {
        if (this.method_6047().method_7909() instanceof GunItem) {
            ci.cancel();
        }
    }

    @Override
    public void toggleAim(boolean b) {
        this.field_6011.method_12778(IS_AIMING, (Object)b);
        if (b) {
            this.method_5728(false);
        }
    }

    @Override
    public boolean isAiming() {
        return (Boolean)this.field_6011.method_12789(IS_AIMING);
    }

    @Inject(method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"}, at={@At(value="HEAD")})
    public void dropGun(class_1799 stack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<class_1542> cir) {
        if (stack.method_7948().method_10550("GeckoLibID") == this.currentGun.method_7948().method_10550("GeckoLibID")) {
            this.currentGun = class_1799.field_8037;
        }
    }

    @Inject(method={"initDataTracker"}, at={@At(value="HEAD")})
    private void initDataTracker(CallbackInfo ci) {
        this.field_6011.method_12784(IS_AIMING, (Object)false);
        this.field_6011.method_12784(IS_RELOADING, (Object)false);
        this.field_6011.method_12784(RELOAD_TICK, (Object)0);
    }
}

