/*
 * Decompiled with CFR 0.152.
 */
package net.elidhan.anim_guns.util;

import java.util.Optional;
import java.util.stream.Stream;
import net.elidhan.anim_guns.item.AttachmentItem;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class AttachmentUtil {
    public static int addAttachment(class_1799 gun, class_1799 attachment, AttachmentItem.AttachType[] acceptedAttachmentTypes) {
        if (attachment.method_7960() || !(attachment.method_7909() instanceof AttachmentItem)) {
            return 0;
        }
        class_2487 nbtCompound = gun.method_7948();
        if (!nbtCompound.method_10545("Items")) {
            nbtCompound.method_10566("Items", (class_2520)new class_2499());
        }
        int i = AttachmentUtil.getExistingAttachments(gun);
        int k = Math.min(attachment.method_7947(), 3 - i);
        if (k == 0) {
            return 0;
        }
        class_2499 nbtList = nbtCompound.method_10554("Items", 10);
        Optional<class_2487> existingAttach = AttachmentUtil.checkExistingAttachType(attachment, nbtList);
        if (existingAttach.isPresent() || !AttachmentUtil.acceptedAttachment(((AttachmentItem)attachment.method_7909()).getAttachType(), acceptedAttachmentTypes)) {
            return 0;
        }
        String attachID = ((AttachmentItem)attachment.method_7909()).getId();
        AttachmentItem.AttachType attachType = ((AttachmentItem)attachment.method_7909()).getAttachType();
        switch (attachType) {
            case SIGHT: {
                nbtCompound.method_10582("sightID", attachID);
                break;
            }
            case SCOPE: {
                nbtCompound.method_10582("sightID", attachID);
                nbtCompound.method_10556("isScoped", true);
                break;
            }
            case GRIP: {
                nbtCompound.method_10582("gripID", attachID);
                break;
            }
            case MUZZLE: {
                nbtCompound.method_10582("muzzleID", attachID);
            }
        }
        class_1799 itemStack2 = attachment.method_46651(k);
        class_2487 nbtCompound3 = new class_2487();
        itemStack2.method_7953(nbtCompound3);
        nbtList.method_10531(0, (class_2520)nbtCompound3);
        return 1;
    }

    public static Optional<class_1799> removeFirstStack(class_1799 gun) {
        class_2487 nbtCompound = gun.method_7948();
        if (!nbtCompound.method_10545("Items")) {
            return Optional.empty();
        }
        class_2499 nbtList = nbtCompound.method_10554("Items", 10);
        if (nbtList.isEmpty()) {
            return Optional.empty();
        }
        class_2487 nbtCompound2 = nbtList.method_10602(0);
        class_1799 attachment = class_1799.method_7915((class_2487)nbtCompound2);
        nbtList.method_10536(0);
        AttachmentItem.AttachType attachType = ((AttachmentItem)attachment.method_7909()).getAttachType();
        switch (attachType) {
            case SIGHT: {
                nbtCompound.method_10582("sightID", "default");
                break;
            }
            case SCOPE: {
                nbtCompound.method_10582("sightID", "default");
                nbtCompound.method_10556("isScoped", false);
                break;
            }
            case GRIP: {
                nbtCompound.method_10582("gripID", "default");
                break;
            }
            case MUZZLE: {
                nbtCompound.method_10582("muzzleID", "default");
            }
        }
        if (nbtList.isEmpty()) {
            gun.method_7983("Items");
        }
        return Optional.of(attachment);
    }

    public static int getExistingAttachments(class_1799 gun) {
        return AttachmentUtil.getAttachments(gun).mapToInt(class_1799::method_7947).sum();
    }

    public static Stream<class_1799> getAttachments(class_1799 gun) {
        class_2487 nbtCompound = gun.method_7969();
        if (nbtCompound == null) {
            return Stream.empty();
        }
        class_2499 nbtList = nbtCompound.method_10554("Items", 10);
        return nbtList.stream().map(class_2487.class::cast).map(class_1799::method_7915);
    }

    public static Optional<class_2487> checkExistingAttachType(class_1799 attachment, class_2499 items) {
        if (attachment.method_31574(class_1802.field_27023)) {
            return Optional.empty();
        }
        return items.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).filter(item -> class_1799.method_7915((class_2487)item).method_7909() instanceof AttachmentItem && (((AttachmentItem)class_1799.method_7915((class_2487)item).method_7909()).getAttachType() == ((AttachmentItem)attachment.method_7909()).getAttachType() || ((AttachmentItem)class_1799.method_7915((class_2487)item).method_7909()).getAttachType().equals((Object)AttachmentItem.AttachType.SCOPE) && ((AttachmentItem)attachment.method_7909()).getAttachType().equals((Object)AttachmentItem.AttachType.SIGHT) || ((AttachmentItem)class_1799.method_7915((class_2487)item).method_7909()).getAttachType().equals((Object)AttachmentItem.AttachType.SIGHT) && ((AttachmentItem)attachment.method_7909()).getAttachType().equals((Object)AttachmentItem.AttachType.SCOPE))).findFirst();
    }

    public static boolean acceptedAttachment(AttachmentItem.AttachType attachType, AttachmentItem.AttachType[] acceptedAttachmentTypes) {
        for (AttachmentItem.AttachType attachType2 : acceptedAttachmentTypes) {
            if (attachType != attachType2) continue;
            return true;
        }
        return false;
    }
}

